/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.ext.udc.impl;

import java.io.IOException;
import java.net.URL;
import java.net.URLConnection;
import java.util.Map;
import org.neo4j.ext.udc.impl.UdcInformationCollector;

public class Pinger {
    private final String address;
    private final UdcInformationCollector collector;
    private int pingCount = 0;

    public Pinger(String address, UdcInformationCollector collector) {
        this.address = address;
        this.collector = collector;
        if (collector.getCrashPing()) {
            this.pingCount = -1;
        }
    }

    public void ping() throws IOException {
        ++this.pingCount;
        Map<String, String> usageDataMap = this.collector.getUdcParams();
        StringBuilder uri = new StringBuilder("http://" + this.address + "/" + "?");
        for (String key : usageDataMap.keySet()) {
            uri.append(key);
            uri.append("=");
            uri.append(usageDataMap.get(key));
            uri.append("+");
        }
        if (this.pingCount == 0) {
            uri.append("p=-1");
            ++this.pingCount;
        } else {
            uri.append("p=").append(this.pingCount);
        }
        URL url = new URL(uri.toString());
        URLConnection con = url.openConnection();
        con.setDoInput(true);
        con.setDoOutput(false);
        con.setUseCaches(false);
        con.connect();
        con.getInputStream();
    }

    public Integer getPingCount() {
        return this.pingCount;
    }
}

