/*
 * Decompiled with CFR 0.152.
 */
package org.objectweb.jorm.mapper.rdb.adapter;

import java.sql.Connection;
import java.sql.ResultSet;
import java.sql.SQLException;
import org.objectweb.jorm.mapper.rdb.adapter.BasicRdbAdapter;
import org.objectweb.jorm.mapper.rdb.adapter.api.RdbAdapterException;

public class CloudscapeAdapter
extends BasicRdbAdapter {
    private static final String CLOUDSCAPESUBSTRING = "substr";
    private static final String CLOUDSCAPECONCAT = "||";
    private static final String CLOUDSCAPEFIRSTLOCATE = "locate";

    public CloudscapeAdapter() {
        super("cloudscape");
    }

    public boolean supportBatchPreparedStatement() {
        return false;
    }

    public String getSqlType(int typeCode, boolean usedInPK, int size, int scale) throws RdbAdapterException {
        switch (typeCode) {
            case 0: 
            case 8: {
                return "SMALLINT";
            }
            case 2: 
            case 10: {
                return "SMALLINT";
            }
            case 16: 
            case 18: {
                if (size != -1) {
                    return "VARCHAR(" + size + ")";
                }
                return "VARCHAR(256)";
            }
            case 19: 
            case 20: {
                if (size != -1) {
                    return "VARCHAR(" + size + ") FOR BIT DATA";
                }
                return "VARCHAR(256) FOR BIT DATA";
            }
            case 21: {
                if (size != -1) {
                    return "DECIMAL(" + size + ",0)";
                }
                return "DECIMAL(31,0)";
            }
            case 22: {
                if (size != -1) {
                    if (scale != -1) {
                        return "DECIMAL(" + size + ", " + scale + ")";
                    }
                    return "DECIMAL(" + size + ", 4)";
                }
                return "DECIMAL(31,4)";
            }
        }
        return super.getSqlType(typeCode, usedInPK, size, scale);
    }

    public String getValueAsSQLString(Object value, int typeCode) {
        if (value == null) {
            return null;
        }
        switch (typeCode) {
            case 21: 
            case 22: {
                return value.toString();
            }
        }
        return super.getValueAsSQLString(value, typeCode);
    }

    public String getSubstringName() {
        return CLOUDSCAPESUBSTRING;
    }

    public String getConcatExpression(String op1, String op2) {
        return op1 + CLOUDSCAPECONCAT + op2;
    }

    public String getFirstLocateExpression(String substring, String instring) {
        return "locate(" + substring + ", " + instring + ")";
    }

    public String getIndexedLocateExpression(String instring, String substring, String fromIndex) {
        return "locate(" + substring + ", " + instring + ", " + fromIndex + ")";
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected boolean existRelation(Connection connection, String relName, String[] relationTypes) throws SQLException {
        boolean existtable = false;
        ResultSet rs = null;
        if (relationTypes == null) {
            relationTypes = new String[]{"TABLE", "VIEW"};
        }
        try {
            rs = connection.getMetaData().getTables(null, null, null, relationTypes);
            while (rs.next() && !existtable) {
                existtable = relName.equalsIgnoreCase(rs.getString(3));
            }
        }
        finally {
            if (rs != null) {
                rs.close();
            }
        }
        return existtable;
    }

    public String getSubqueryAlias() {
        return " as foo";
    }

    public String getCreateSequence(String seqName) throws UnsupportedOperationException {
        throw new UnsupportedOperationException("Cloudscape does not support SEQUENCE");
    }

    public String getCreateSequence(String seqName, Integer startid, Integer inc, Integer cache) {
        throw new UnsupportedOperationException("Cloudscape does not support SEQUENCE");
    }

    public String getDropSequence(String seqName) throws UnsupportedOperationException {
        throw new UnsupportedOperationException("Cloudscape does not support SEQUENCE");
    }
}

