/*
 * Decompiled with CFR 0.152.
 */
package org.objectweb.jorm.mapper.rdb.adapter;

import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Time;
import java.sql.Timestamp;
import java.util.Date;
import org.objectweb.jorm.mapper.rdb.adapter.BasicArray;
import org.objectweb.jorm.mapper.rdb.adapter.BasicRdbAdapter;
import org.objectweb.jorm.mapper.rdb.adapter.api.RdbAdapterException;

public class MysqlAdapter
extends BasicRdbAdapter {
    private static final String MYSQLINDEXEDLOCATE = "locate";
    private int varcharSize = 254;
    private int varcharSizeInPk = 200;
    public int varbinarySize = 254;
    public int varbinarySizeInPk = 200;

    public MysqlAdapter() {
        super("mysql");
    }

    public boolean supportBatchPreparedStatement() {
        return false;
    }

    public int fetchResultSetSize(ResultSet rs) throws SQLException {
        return -1;
    }

    public void setVarcharSize(int s) {
        this.varcharSize = s;
    }

    public void setVarcharSizeInPk(int s) {
        this.varcharSizeInPk = s;
    }

    public String getSqlType(int typeCode, boolean usedInPK, int size, int scale) throws RdbAdapterException {
        int realsize = size;
        if (BasicArray.isArray(typeCode)) {
            throw new UnsupportedOperationException("Mysql does not support java.sql.Types.ARRAY");
        }
        switch (typeCode) {
            case 16: {
                if (realsize == -1) {
                    realsize = usedInPK ? this.varcharSizeInPk : this.varcharSize;
                }
                return usedInPK ? "VARCHAR(" + realsize + ")  NOT NULL" : "LONGTEXT ";
            }
            case 20: {
                return "LONGTEXT";
            }
            case 21: {
                if (size == -1) {
                    size = 127;
                }
                return "DECIMAL(" + size + ",0)";
            }
            case 22: {
                if (size != -1) {
                    if (scale != -1) {
                        return "DECIMAL(" + size + ", " + scale + ")";
                    }
                    return "DECIMAL(" + size + ")";
                }
                return "DECIMAL(127,127)";
            }
            case 19: {
                if (realsize == -1) {
                    realsize = usedInPK ? this.varbinarySizeInPk : this.varbinarySize;
                }
                return usedInPK ? "VARCHAR(" + realsize + ") BINARY NOT NULL" : "LONGTEXT ";
            }
            case 18: {
                if (realsize == -1) {
                    realsize = usedInPK ? this.varbinarySizeInPk : this.varbinarySize;
                }
                return usedInPK ? "VARCHAR(" + realsize + ") NOT NULL" : "LONGTEXT ";
            }
            case 17: {
                return "DATETIME";
            }
            case 6: 
            case 14: {
                return "FLOAT";
            }
        }
        String res = super.getSqlType(typeCode, usedInPK, size, scale);
        if (usedInPK) {
            res = res + " NOT NULL";
        }
        return res;
    }

    public int getSqlTypeCode(int typeCode, String sqlColumnType) throws RdbAdapterException {
        if (BasicArray.isArray(typeCode)) {
            throw new UnsupportedOperationException("Mysql does not support java.sql.Types.ARRAY");
        }
        switch (typeCode) {
            case 17: {
                if (sqlColumnType == null) {
                    return 93;
                }
                String str = sqlColumnType.toUpperCase();
                if (str.startsWith("DATE")) {
                    return 91;
                }
                if (str.startsWith("TIMESTAMP")) {
                    return 93;
                }
                if (str.startsWith("TIME")) {
                    return 92;
                }
                return 93;
            }
        }
        return super.getSqlTypeCode(typeCode, sqlColumnType);
    }

    public char getChar(ResultSet rs, int idx, char nullValue) throws SQLException {
        String res = rs.getString(idx);
        if (rs.wasNull() || res == null) {
            return nullValue;
        }
        if (res.length() == 0) {
            return ' ';
        }
        return res.charAt(0);
    }

    public Character getOchar(ResultSet rs, int idx, Character nullValue) throws SQLException {
        String res = rs.getString(idx);
        if (rs.wasNull() || res == null) {
            return nullValue;
        }
        if (res.length() == 0) {
            return new Character(' ');
        }
        return new Character(res.charAt(0));
    }

    public Date getDate(ResultSet rs, int idx, String sqlColumnType, Date nullValue) throws SQLException {
        String str;
        Date res = sqlColumnType == null ? rs.getTimestamp(idx) : ((str = sqlColumnType.toUpperCase()).startsWith("TIMESTAMP") || str.equals("DATETIME") ? rs.getTimestamp(idx) : (str.startsWith("DATE") ? rs.getDate(idx) : (str.startsWith("TIME") ? rs.getTime(idx) : rs.getTimestamp(idx))));
        return rs.wasNull() ? nullValue : res;
    }

    public String getIndexedLocateExpression(String instring, String substring, String fromIndex) {
        return "locate(" + substring + ", " + instring + ", " + fromIndex + ")";
    }

    public void setDate(PreparedStatement ps, int idx, Date o, String columnType) throws SQLException {
        if (columnType == null) {
            if (o == null) {
                ps.setTimestamp(idx, new Timestamp(0L));
            } else if (o instanceof Timestamp) {
                ps.setTimestamp(idx, (Timestamp)o);
            } else {
                ps.setTimestamp(idx, new Timestamp(o.getTime()));
            }
        } else if (columnType.startsWith("TIMESTAMP") || columnType.equals("DATETIME")) {
            if (o == null) {
                ps.setTimestamp(idx, new Timestamp(0L));
            } else if (o instanceof Timestamp) {
                ps.setTimestamp(idx, (Timestamp)o);
            } else {
                ps.setTimestamp(idx, new Timestamp(o.getTime()));
            }
        } else if (columnType.startsWith("TIME")) {
            if (o == null) {
                ps.setTime(idx, new Time(0L));
            } else if (o instanceof Time) {
                ps.setTime(idx, (Time)o);
            } else {
                ps.setTime(idx, new Time(o.getTime()));
            }
        } else if (columnType.startsWith("DATE")) {
            if (o == null) {
                ps.setDate(idx, new java.sql.Date(0L));
            } else if (o instanceof java.sql.Date) {
                ps.setDate(idx, (java.sql.Date)o);
            } else {
                ps.setDate(idx, new java.sql.Date(o.getTime()));
            }
        }
    }

    public String getCreateSequence(String seqName) throws UnsupportedOperationException {
        throw new UnsupportedOperationException("Mysql does not support SEQUENCE");
    }

    public String getCreateSequence(String seqName, Integer startid, Integer inc, Integer cache) {
        throw new UnsupportedOperationException("Mysql does not support SEQUENCE");
    }

    public String getDropSequence(String seqName) throws UnsupportedOperationException {
        throw new UnsupportedOperationException("Mysql does not support SEQUENCE");
    }

    protected void modifySelectClauseWithRange(StringBuffer sb, boolean rangeStart, boolean rangeSize) {
    }

    protected void modifyQueryWithRange(StringBuffer sb, boolean rangeStart, boolean rangeSize) {
        if (rangeSize || rangeStart) {
            if (rangeStart) {
                sb.append(" LIMIT ?, ");
            } else {
                sb.append(" LIMIT 0, ");
            }
            if (rangeSize) {
                sb.append(" ? ");
            } else {
                sb.append(" 18446744073709551615 ");
            }
        }
    }

    public int getRangeParametersAtStart() {
        return 1;
    }

    public String getSubqueryAlias() {
        return "foo";
    }

    public Object getArray(ResultSet rs, int idx, Object nullValue, int typeCode) throws SQLException {
        throw new UnsupportedOperationException("Mysql does not support java.sql.Types.ARRAY");
    }

    public String getArrayValueAsSQLString(Object array, int typeCode, String begin, String realsep, String end) {
        throw new UnsupportedOperationException("Mysql does not support java.sql.Types.ARRAY");
    }

    public boolean supportArray(int elemTypeCode) {
        return false;
    }

    public String getDropIndex(String name, String tableName) throws UnsupportedOperationException {
        return "DROP INDEX " + name + " ON " + tableName;
    }
}

