/*
 * Decompiled with CFR 0.152.
 */
package org.objectweb.jorm.mapper.rdb.adapter;

import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.util.HashMap;
import java.util.Map;
import java.util.StringTokenizer;
import org.objectweb.jorm.mapper.rdb.adapter.BasicRdbAdapter;
import org.objectweb.jorm.mapper.rdb.adapter.api.RdbAdapterException;

public class OracleAdapter
extends BasicRdbAdapter {
    private static final String PROP_BASE = "org.objectweb.jorm.adapter.oracle.";
    private static final String ORACLEFIRSTLOCATE = "instr";
    public static final String[][] PROPS = new String[][]{{"org.objectweb.jorm.adapter.oracle.varchar", "256"}, {"org.objectweb.jorm.adapter.oracle.bytearray", "1999"}, {"org.objectweb.jorm.adapter.oracle.jorm_chararray", "1999"}, {"org.objectweb.jorm.adapter.oracle.varchar.pk", "256"}};
    public static final Map properties = new HashMap(PROPS.length);
    private static final String RNUM = "RNUM_";
    private int varcharSize = OracleAdapter.getDefaultSize(0);
    private int defaultBytearraySize = OracleAdapter.getDefaultSize(1);
    private int defaultChararraySize = OracleAdapter.getDefaultSize(2);
    private int varcharSizeInPk = OracleAdapter.getDefaultSize(3);
    private final String[] GROUP_FUNCTIONS = new String[]{"AVG", "COUNT", "MAX", "MIN", "SUM", "STDDEV", "VARIANCE"};

    private static final int getDefaultSize(int idx) {
        return Integer.parseInt((String)properties.get(PROPS[idx][0]));
    }

    public OracleAdapter() {
        super("oracle");
    }

    public OracleAdapter(String name) {
        super(name);
    }

    public void setVarcharSize(int s) {
        this.varcharSize = s;
    }

    public void setVarcharSizeInPk(int s) {
        this.varcharSizeInPk = s;
    }

    public boolean supportBatchPreparedStatement() {
        return false;
    }

    public String getSqlType(int typeCode, boolean usedInPK, int size, int scale) throws RdbAdapterException {
        int realsize = size;
        switch (typeCode) {
            case 0: 
            case 2: 
            case 3: 
            case 5: 
            case 7: 
            case 8: 
            case 10: 
            case 11: 
            case 13: 
            case 15: 
            case 21: 
            case 22: {
                return "NUMBER";
            }
            case 16: {
                if (realsize == -1) {
                    realsize = usedInPK ? this.varcharSizeInPk : this.varcharSize;
                }
                return "VARCHAR(" + realsize + ")";
            }
            case 19: {
                if (realsize == -1) {
                    realsize = this.defaultBytearraySize;
                }
                return (realsize > 2000 ? "LONG " : "") + "RAW(" + realsize + ")";
            }
            case 18: {
                if (realsize == -1) {
                    realsize = this.defaultChararraySize;
                }
                return (realsize > 2000 ? "LONG " : "") + "RAW(" + realsize + ")";
            }
            case 20: {
                return "BLOB";
            }
            case 17: {
                return "DATE";
            }
        }
        return super.getSqlType(typeCode, usedInPK, size, scale);
    }

    public String getFirstLocateExpression(String substring, String instring) {
        return "instr(" + instring + ", " + substring + ")";
    }

    public String getIndexedLocateExpression(String instring, String substring, String fromIndex) {
        return "instr(" + instring + ", " + substring + ", " + fromIndex + ")";
    }

    public void writeTableAlias(String alias, StringBuffer sb) {
        sb.append(" ");
        sb.append(alias);
    }

    public String getColumnAliasExpr(String aliasName) {
        return " " + aliasName + " ";
    }

    public void writeColumnAlias(String alias, StringBuffer sb) {
        sb.append(" " + alias + " ");
    }

    public String handleOrderBy(String query) {
        return "SELECT * FROM (" + query + ")";
    }

    public String getNextValInSequence(String seqName) {
        return "select " + seqName + ".nextval from dual";
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public void getManyNextValInSequence(Connection conn, String seqName, int numberOfNextVal) throws RdbAdapterException {
        StringBuffer sb = new StringBuffer();
        String query = "select " + seqName + ".nextval from dual";
        PreparedStatement ps = null;
        try {
            try {
                ps = conn.prepareStatement(query);
                for (int i = 0; i < numberOfNextVal; ++i) {
                    ps.executeQuery();
                }
                Object var9_9 = null;
            }
            catch (SQLException e) {
                throw new RdbAdapterException(e, "Impossible to allocate " + numberOfNextVal + " identifier" + " on the sequence: " + seqName);
            }
        }
        catch (Throwable throwable) {
            Object var9_10 = null;
            try {
                if (ps == null) throw throwable;
                ps.close();
                throw throwable;
            }
            catch (SQLException e) {
                // empty catch block
            }
            throw throwable;
        }
        try {}
        catch (SQLException e) {}
        if (ps == null) return;
        ps.close();
        return;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected boolean existRelation(Connection connection, String relName, String[] relationTypes) throws SQLException {
        boolean existtable = false;
        ResultSet rs = null;
        if (relationTypes == null) {
            relationTypes = new String[]{"TABLE", "VIEW"};
        }
        String schema = null;
        if (relName.indexOf(46) != -1) {
            schema = relName.substring(0, relName.indexOf(46));
            relName = relName.substring(relName.indexOf(46) + 1);
        }
        try {
            rs = connection.getMetaData().getTables(null, schema, null, relationTypes);
            while (rs.next() && !existtable) {
                existtable = relName.equalsIgnoreCase(rs.getString(3));
            }
        }
        finally {
            if (rs != null) {
                rs.close();
            }
        }
        return existtable;
    }

    public boolean existSequence(Connection connection, String seqName) throws SQLException {
        return this.existRelation(connection, seqName, new String[]{"SEQUENCE"});
    }

    public String getQuery(String selectClause, String fromClause, String whereClause, String orderBy, String groupBy, boolean rangeStart, boolean rangeSize) {
        StringBuffer sb = new StringBuffer();
        if (rangeStart || rangeSize) {
            this.appendSelectClauseForRangeWithOrder(sb, selectClause);
        }
        this.appendClause(sb, "SELECT ", selectClause);
        this.appendClause(sb, " FROM ", fromClause);
        this.appendClause(sb, " WHERE ", whereClause);
        this.appendClause(sb, " ORDER BY ", orderBy);
        this.appendClause(sb, " GROUP BY ", groupBy);
        this.modifyQueryWithRange(sb, rangeStart, rangeSize);
        return sb.toString();
    }

    protected void modifySelectClauseWithRange(StringBuffer sb, boolean rangeStart, boolean rangeSize) {
        if (rangeStart || rangeSize) {
            sb.insert(0, "SELECT * FROM (");
            sb.append(", ROWNUM as ").append(RNUM);
        }
    }

    protected void appendSelectClauseForRangeWithOrder(StringBuffer sb, String selectClause) {
        String pfs = this.extractProjectedFieldFromClause(selectClause);
        sb.append("SELECT ").append(pfs).append(" FROM (");
        sb.append("SELECT ").append(pfs).append(" , ROWNUM as ").append(RNUM);
        sb.append(" FROM (");
    }

    private String extractProjectedFieldFromClause(String selectClause) {
        StringTokenizer st = new StringTokenizer(selectClause, ",", false);
        StringBuffer sb = new StringBuffer();
        while (st.hasMoreTokens()) {
            String projElem = st.nextToken();
            int idx = projElem.indexOf(" as ");
            if (idx != -1) {
                projElem = projElem.substring(idx + 4);
            } else {
                idx = projElem.lastIndexOf(46);
                if (idx != -1) {
                    projElem = projElem.substring(idx + 1);
                }
            }
            sb.append(projElem);
            if (!st.hasMoreElements()) continue;
            sb.append(", ");
        }
        return sb.toString();
    }

    protected void modifyQueryWithRange(StringBuffer sb, boolean rangeStart, boolean rangeSize) {
        if (rangeStart || rangeSize) {
            sb.append("))");
            String clause = " WHERE ";
            if (rangeStart) {
                sb.append(clause);
                clause = " AND ";
                sb.append(RNUM).append(" > ?");
            }
            if (rangeSize) {
                sb.append(clause);
                sb.append(RNUM).append(" <=  ?");
                if (rangeStart) {
                    sb.append("+ ?");
                }
            }
        }
    }

    private boolean containGroupFunction(String selectClause) {
        if (selectClause == null || selectClause.length() == 0) {
            return false;
        }
        String selectCl = selectClause.toUpperCase();
        for (int i = 0; i < this.GROUP_FUNCTIONS.length; ++i) {
            if (selectCl.indexOf(this.GROUP_FUNCTIONS[i]) == -1) continue;
            return true;
        }
        return false;
    }

    public int getRangeParametersAtStart() {
        return 1;
    }

    public String getValueAsSQLString(Object value, int typeCode) {
        switch (typeCode) {
            case 21: 
            case 22: {
                return value.toString();
            }
        }
        return super.getValueAsSQLString(value, typeCode);
    }

    static {
        for (int i = 0; i < PROPS.length; ++i) {
            properties.put(PROPS[i][0], System.getProperty(PROPS[i][0], PROPS[i][1]));
        }
    }
}

