/*
 * Decompiled with CFR 0.152.
 */
package org.objectweb.jorm.mapper.rdb.lib;

import java.io.PrintWriter;
import java.sql.Connection;
import java.sql.DriverManager;
import java.sql.SQLException;
import javax.sql.DataSource;
import org.objectweb.jorm.api.PException;

public class ConnectionSpecJDBC
implements DataSource {
    String url;
    String user = null;
    String passwd = null;
    PrintWriter pw;
    int timeout = 0;

    public ConnectionSpecJDBC(String url, String driver) throws PException {
        this.url = url;
        try {
            Class.forName(driver);
        }
        catch (ClassNotFoundException e) {
            throw new PException(e, "Unable to load JDBC driver class: " + driver);
        }
    }

    public ConnectionSpecJDBC(String url, String driver, String user, String passwd) throws PException {
        this(url, driver);
        this.user = user;
        this.passwd = passwd;
    }

    public Connection getConnection() throws SQLException {
        if (this.user != null && this.passwd != null) {
            return DriverManager.getConnection(this.url, this.user, this.passwd);
        }
        return DriverManager.getConnection(this.url);
    }

    public Connection getConnection(String username, String password) throws SQLException {
        return DriverManager.getConnection(this.url, username, password);
    }

    public PrintWriter getLogWriter() throws SQLException {
        return this.pw;
    }

    public void setLogWriter(PrintWriter out) throws SQLException {
        this.pw = out;
    }

    public void setLoginTimeout(int seconds) throws SQLException {
        this.timeout = seconds;
    }

    public int getLoginTimeout() throws SQLException {
        return this.timeout;
    }
}

