/*
 * Decompiled with CFR 0.152.
 */
package org.objectweb.jorm.mapper.rdb.metainfo;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashSet;
import java.util.Iterator;
import org.objectweb.jorm.api.PClassMapping;
import org.objectweb.jorm.api.PException;
import org.objectweb.jorm.api.PMapper;
import org.objectweb.jorm.mapper.rdb.adapter.api.JoinedTable;
import org.objectweb.jorm.mapper.rdb.adapter.api.RdbAdapter;
import org.objectweb.jorm.mapper.rdb.lib.PMapperRdb;
import org.objectweb.jorm.mapper.rdb.lib.RdbExtentGenInfos;
import org.objectweb.jorm.mapper.rdb.lib.RdbExtentMappingInfos;
import org.objectweb.jorm.mapper.rdb.lib.RdbPPolymorphicClass;
import org.objectweb.jorm.mapper.rdb.metainfo.RdbClassMapping;
import org.objectweb.jorm.mapper.rdb.metainfo.RdbJoin;
import org.objectweb.jorm.mapper.rdb.metainfo.RdbMapping;
import org.objectweb.jorm.mapper.rdb.metainfo.RdbPrimitiveElementMapping;
import org.objectweb.jorm.mapper.rdb.util.ColumnAliasing;
import org.objectweb.jorm.metainfo.api.Class;
import org.objectweb.jorm.metainfo.api.ClassProject;
import org.objectweb.jorm.metainfo.api.MetaObject;
import org.objectweb.jorm.metainfo.api.PrimitiveElement;
import org.objectweb.jorm.metainfo.api.PrimitiveElementMapping;
import org.objectweb.jorm.metainfo.lib.BasicMetaObject;

public class RdbInheritanceQuery
extends BasicMetaObject {
    private static final long serialVersionUID = 1L;
    private static int pkIndex = 0;
    public static final String PK = "pk";
    private RdbClassMapping rdbClassMapping;
    private String queryPrefetch;
    private String queryPKOnly;
    private String queryPKAndFields;
    private Collection fieldsPrefetch;
    private Collection fieldsPKOnly;
    private Collection fieldsPKAndFields;
    private Collection prefetchClasses;

    public RdbInheritanceQuery(MetaObject parent) {
        super(parent);
        this.rdbClassMapping = (RdbClassMapping)parent;
        this.queryPrefetch = "";
        this.queryPKOnly = "";
        this.queryPKAndFields = "";
        this.fieldsPrefetch = new ArrayList();
        this.fieldsPKOnly = new ArrayList();
        this.fieldsPKAndFields = new ArrayList();
        this.prefetchClasses = new ArrayList();
    }

    public String getExtentQuery(PMapper mapper, boolean prefetch, boolean pkOnly, String primaryKey, PClassMapping pcm) {
        if (prefetch) {
            return this.getQueryPrefetch(mapper, primaryKey, pcm);
        }
        if (pkOnly) {
            return this.getQueryPKOnly(mapper, primaryKey, pcm);
        }
        return this.getQueryPKAndFields(mapper, primaryKey, pcm);
    }

    public Collection getPKfield() {
        return this.fieldsPKOnly;
    }

    public Collection getExtentFieldsNames(boolean prefetch, boolean pkOnly) {
        if (prefetch) {
            return this.fieldsPrefetch;
        }
        if (pkOnly) {
            return this.fieldsPKOnly;
        }
        return this.fieldsPKAndFields;
    }

    public void addFieldPKOnly(Collection c) {
        Iterator itC = c.iterator();
        while (itC.hasNext()) {
            String s = (String)itC.next();
            if (this.fieldsPKOnly.contains(s)) continue;
            this.fieldsPKOnly.add(s);
        }
    }

    public void addFieldPrefetch(Collection fields, Collection classes) {
        Iterator itF = fields.iterator();
        Iterator itC = classes.iterator();
        while (itF.hasNext()) {
            String field = (String)itF.next();
            String className = (String)itC.next();
            if (this.fieldsPrefetch.contains(field)) continue;
            this.fieldsPrefetch.add(field);
            this.prefetchClasses.add(className);
        }
    }

    public void addFieldPKAndFields(Collection c) {
        Iterator itC = c.iterator();
        while (itC.hasNext()) {
            String s = (String)itC.next();
            if (this.fieldsPKAndFields.contains(s)) continue;
            this.fieldsPKAndFields.add(s);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private String getQueryPKOnly(PMapper mapper, String primaryKey, PClassMapping pcm) {
        if (!this.queryPKOnly.equals("")) {
            return this.queryPKOnly;
        }
        PClassMapping pClassMapping = pcm;
        synchronized (pClassMapping) {
            if (!this.queryPKOnly.equals("")) {
                return this.queryPKOnly;
            }
            RdbExtentGenInfos extentGenInfos = new RdbExtentGenInfos(this.logger);
            try {
                RdbAdapter adapter = ((PMapperRdb)mapper).getRdbAdapter();
                if (adapter == null) {
                    throw new PException("No rdb adapter found on the mapper: " + mapper);
                }
                Collection emis = extentGenInfos.getPolymorphicClassExtent((Class)this.rdbClassMapping.getLinkedMO(), this.rdbClassMapping.getProjectName(), this.rdbClassMapping.getMapperName(), false);
                JoinedTable jt = null;
                JoinedTable.Join joinCond = null;
                Iterator itEmis = emis.iterator();
                while (itEmis.hasNext()) {
                    RdbExtentMappingInfos emi = (RdbExtentMappingInfos)itEmis.next();
                    this.addFieldPKOnly(emi.getColumnAliases(false, primaryKey, null));
                    jt = new JoinedTable(emi.getMainTable().getName());
                    HashSet hsJoins = emi.getJoins();
                    Iterator itJoins = hsJoins.iterator();
                    while (itJoins.hasNext()) {
                        RdbJoin rdbJoin = (RdbJoin)itJoins.next();
                        joinCond = jt.createChildren(rdbJoin.getExternalTable().getName());
                        int pos = 0;
                        Iterator itCName = rdbJoin.getPTJoinColumnNames().iterator();
                        while (itCName.hasNext()) {
                            String cName = (String)itCName.next();
                            joinCond.addJoinColumn(cName, (String)rdbJoin.getETJoinColumnNames().get(pos));
                            ++pos;
                        }
                    }
                    this.queryPKOnly = this.queryPKOnly + adapter.getQuery(emi.getSelectPKOnly(adapter, primaryKey), Collections.singletonList(jt), emi.getWhereParameter(pcm), false, false);
                    if (!itEmis.hasNext()) continue;
                    this.queryPKOnly = this.queryPKOnly + " UNION ";
                }
            }
            catch (Exception e) {
                e.printStackTrace();
            }
        }
        return this.queryPKOnly;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private String getQueryPKAndFields(PMapper mapper, String primaryKey, PClassMapping pcm) {
        if (!this.queryPKAndFields.equals("")) {
            return this.queryPKAndFields;
        }
        PClassMapping pClassMapping = pcm;
        synchronized (pClassMapping) {
            if (!this.queryPKAndFields.equals("")) {
                return this.queryPKAndFields;
            }
            RdbExtentGenInfos extentGenInfos = new RdbExtentGenInfos(this.logger);
            try {
                RdbAdapter adapter = ((PMapperRdb)mapper).getRdbAdapter();
                if (adapter == null) {
                    throw new PException("No rdb adapter found on the mapper: " + mapper);
                }
                Collection emis = extentGenInfos.getPolymorphicClassExtent((Class)this.rdbClassMapping.getLinkedMO(), this.rdbClassMapping.getProjectName(), this.rdbClassMapping.getMapperName(), false);
                JoinedTable jt = null;
                JoinedTable.Join joinCond = null;
                Iterator itEmis = emis.iterator();
                while (itEmis.hasNext()) {
                    RdbExtentMappingInfos emi = (RdbExtentMappingInfos)itEmis.next();
                    this.addFieldPKAndFields(emi.getColumnAliases(false, primaryKey, (Class)this.rdbClassMapping.getLinkedMO()));
                    jt = new JoinedTable(emi.getMainTable().getName());
                    HashSet hsJoins = emi.getJoins();
                    Iterator itJoins = hsJoins.iterator();
                    while (itJoins.hasNext()) {
                        RdbJoin rdbJoin = (RdbJoin)itJoins.next();
                        joinCond = jt.createChildren(rdbJoin.getExternalTable().getName());
                        int pos = 0;
                        Iterator itCName = rdbJoin.getPTJoinColumnNames().iterator();
                        while (itCName.hasNext()) {
                            String cName = (String)itCName.next();
                            joinCond.addJoinColumn(cName, (String)rdbJoin.getETJoinColumnNames().get(pos));
                            ++pos;
                        }
                    }
                    this.queryPKAndFields = this.queryPKAndFields + adapter.getQuery(emi.getSelectPKAndFields(adapter, (Class)this.rdbClassMapping.getLinkedMO()), Collections.singletonList(jt), emi.getWhereParameter(pcm), false, false);
                    if (!itEmis.hasNext()) continue;
                    this.queryPKAndFields = this.queryPKAndFields + " UNION ";
                }
            }
            catch (Exception e) {
                e.printStackTrace();
            }
        }
        return this.queryPKAndFields;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * WARNING - void declaration
     */
    private String getQueryPrefetch(PMapper mapper, String primaryKey, PClassMapping pcm) {
        if (!this.queryPrefetch.equals("")) {
            return this.queryPrefetch;
        }
        PClassMapping pClassMapping = pcm;
        synchronized (pClassMapping) {
            if (!this.queryPrefetch.equals("")) {
                return this.queryPrefetch;
            }
            RdbExtentGenInfos extentGenInfos = new RdbExtentGenInfos(this.logger);
            try {
                RdbAdapter adapter = ((PMapperRdb)mapper).getRdbAdapter();
                if (adapter == null) {
                    throw new PException("No rdb adapter found on the mapper: " + mapper);
                }
                Collection emis = extentGenInfos.getPolymorphicClassExtent((Class)this.rdbClassMapping.getLinkedMO(), this.rdbClassMapping.getProjectName(), this.rdbClassMapping.getMapperName(), true);
                JoinedTable jt = null;
                JoinedTable.Join joinCond = null;
                Iterator itEmis = emis.iterator();
                while (itEmis.hasNext()) {
                    void var18_19;
                    String pkString;
                    RdbExtentMappingInfos emi = (RdbExtentMappingInfos)itEmis.next();
                    this.addFieldPrefetch(emi.getColumnAliases(true, "", null), emi.getColumnClasses());
                    this.addFieldPKOnly(emi.getColumnAliases(false, primaryKey, null));
                    jt = new JoinedTable(emi.getMainTable().getName());
                    HashSet hsJoins = emi.getJoins();
                    Iterator itJoins = hsJoins.iterator();
                    while (itJoins.hasNext()) {
                        RdbJoin rdbJoin = (RdbJoin)itJoins.next();
                        joinCond = jt.createChildren(rdbJoin.getExternalTable().getName());
                        int pos = 0;
                        Iterator itCName = rdbJoin.getPTJoinColumnNames().iterator();
                        while (itCName.hasNext()) {
                            String cName = (String)itCName.next();
                            joinCond.addJoinColumn(cName, (String)rdbJoin.getETJoinColumnNames().get(pos));
                            ++pos;
                        }
                    }
                    String currentQuery = adapter.getQuery(emi.getSelectPrefetch(adapter, this.rdbClassMapping.getJormClass()), Collections.singletonList(jt), emi.getWhereParameter(pcm), false, false);
                    int fromIndex = currentQuery.toUpperCase().indexOf(" FROM ");
                    String tmpQuery = currentQuery.substring(0, fromIndex);
                    PClassMapping currentPCM = mapper.lookup(emi.getClazz().getFQName());
                    if (currentPCM instanceof RdbPPolymorphicClass) {
                        pkString = ((RdbPPolymorphicClass)((Object)currentPCM)).getPNameFields();
                    } else if (currentPCM == pcm) {
                        pkString = primaryKey;
                    } else {
                        throw new RuntimeException("Impossible to compute the inheritance query with prefetch of the persistent class " + pcm.getClassName());
                    }
                    tmpQuery = tmpQuery + ", " + this.aliasPK((String)var18_19, adapter) + " ";
                    currentQuery = tmpQuery = tmpQuery + currentQuery.substring(fromIndex);
                    this.queryPrefetch = this.queryPrefetch + currentQuery;
                    if (!itEmis.hasNext()) continue;
                    this.queryPrefetch = this.queryPrefetch + " UNION ";
                }
            }
            catch (Exception e) {
                e.printStackTrace();
            }
            this.setSubTreeFieldAssociationTable(mapper, pcm);
        }
        return this.queryPrefetch;
    }

    public void setSubTreeFieldAssociationTable(PMapper mapper, PClassMapping pcm) {
        try {
            ArrayList<PClassMapping> pcms = new ArrayList<PClassMapping>();
            pcms.add(pcm);
            PClassMapping[] subPCMs = pcm.getSubPCMs();
            if (subPCMs != null) {
                for (int indexPCM = 0; indexPCM < subPCMs.length; ++indexPCM) {
                    pcms.add(subPCMs[indexPCM]);
                }
            }
            String[] classes = new String[this.prefetchClasses.size()];
            Iterator it = this.prefetchClasses.iterator();
            int i = 0;
            while (it.hasNext()) {
                classes[i++] = (String)it.next();
            }
            String mapperName = mapper.getMapperName();
            if (mapperName.indexOf(".") != -1) {
                mapperName = mapperName.substring(0, mapperName.indexOf("."));
            }
            Iterator itPCM = pcms.iterator();
            while (itPCM.hasNext()) {
                PClassMapping currentPCM = (PClassMapping)itPCM.next();
                ArrayList<IndexedPEM> indexes = new ArrayList<IndexedPEM>(0);
                Class clazz = mapper.getMetaInfoManager().getClass(currentPCM.getClassName());
                ClassProject cp = clazz.getClassProject(currentPCM.getProjectName());
                RdbMapping rdbm = (RdbMapping)cp.getMapping(mapperName);
                RdbClassMapping rdbcm = (RdbClassMapping)rdbm.getClassMapping();
                Class cl = rdbcm.getJormClass();
                if (cl == null) {
                    return;
                }
                Collection superClasses = this.getSuperClasses(cl);
                for (int indexField = 0; indexField < this.prefetchClasses.size(); ++indexField) {
                    PrimitiveElementMapping pem;
                    if (!superClasses.contains(classes[indexField])) continue;
                    String fieldName = (String)((ArrayList)this.fieldsPrefetch).get(indexField);
                    RdbJoin rdbJoin = ((RdbPrimitiveElementMapping)(pem = rdbcm.getPrimitiveElementMapping(fieldName = ColumnAliasing.getColumnFromAlias(fieldName), true))).getJoinByPrimitiveElement((PrimitiveElement)cl.getTypedElement(fieldName));
                    IndexedPEM indexedPem = new IndexedPEM(pem, rdbJoin != null ? rdbJoin.getName() : "", indexField);
                    indexes.add(indexedPem);
                }
                Collections.sort(indexes);
                int[] table = new int[indexes.size()];
                for (int j = 0; j < table.length; ++j) {
                    table[j] = ((IndexedPEM)indexes.get((int)j)).index;
                }
                currentPCM.addAssociation(pcm, table);
            }
        }
        catch (PException e) {
            e.printStackTrace();
        }
    }

    private Collection getSuperClasses(Class cl) {
        ArrayList<String> superClasses = new ArrayList<String>(1);
        superClasses.add(cl.getFQName());
        Iterator it = cl.getAllAncestors().iterator();
        while (it.hasNext()) {
            Class currentClass = (Class)it.next();
            superClasses.add(currentClass.getFQName());
        }
        return superClasses;
    }

    private String aliasPK(String primaryKey, RdbAdapter adapter) {
        String tmp = primaryKey;
        String aliasName = PK;
        String separator = ",";
        int separatorIndex = tmp.indexOf(separator);
        int localPkIndex = 0;
        while (separatorIndex != -1) {
            String alias = adapter.getColumnAliasExpr(aliasName + localPkIndex++);
            String beginning = primaryKey.substring(0, separatorIndex);
            String end = primaryKey.substring(separatorIndex);
            primaryKey = beginning + alias + end;
            separatorIndex = primaryKey.indexOf(separator, separatorIndex + alias.length() + 1);
        }
        primaryKey = primaryKey + adapter.getColumnAliasExpr(aliasName + localPkIndex++);
        return primaryKey;
    }

    private class IndexedPEM
    implements Comparable {
        protected PrimitiveElementMapping pem;
        protected int index;
        protected String joinName;

        public IndexedPEM(PrimitiveElementMapping pem, String joinName, int index) {
            this.pem = pem;
            this.joinName = joinName;
            this.index = index;
        }

        public int compareTo(Object o) {
            IndexedPEM indexedPem = (IndexedPEM)o;
            int result = ((RdbPrimitiveElementMapping)this.pem).compareTo(indexedPem.pem);
            if (result == 0) {
                result = this.joinName.compareTo(indexedPem.joinName);
            }
            return result;
        }
    }
}

