/*
 * Decompiled with CFR 0.152.
 */
package org.objectweb.jorm.metainfo.lib;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import org.objectweb.jorm.metainfo.api.Class;
import org.objectweb.jorm.metainfo.api.ClassMapping;
import org.objectweb.jorm.metainfo.api.ClassProject;
import org.objectweb.jorm.metainfo.api.ClassRef;
import org.objectweb.jorm.metainfo.api.GenClassRef;
import org.objectweb.jorm.metainfo.api.Mapping;
import org.objectweb.jorm.metainfo.api.MetaObject;
import org.objectweb.jorm.metainfo.api.NameDef;
import org.objectweb.jorm.metainfo.api.Package;
import org.objectweb.jorm.metainfo.api.PrimitiveElement;
import org.objectweb.jorm.metainfo.api.ScalarField;
import org.objectweb.jorm.metainfo.api.TypedElement;
import org.objectweb.jorm.metainfo.lib.BasicClassProject;
import org.objectweb.jorm.metainfo.lib.BasicClassRef;
import org.objectweb.jorm.metainfo.lib.BasicGenClassRef;
import org.objectweb.jorm.metainfo.lib.BasicMetaObject;
import org.objectweb.jorm.metainfo.lib.BasicNameDef;
import org.objectweb.jorm.metainfo.lib.BasicPrimitiveElement;
import org.objectweb.jorm.metainfo.lib.BasicScalarField;
import org.objectweb.jorm.metainfo.lib.FieldComparator;
import org.objectweb.jorm.type.api.PType;
import org.objectweb.medor.expression.api.Expression;
import org.objectweb.medor.expression.api.ExpressionException;
import org.objectweb.medor.expression.api.MalformedExpressionException;
import org.objectweb.medor.expression.api.Operator;
import org.objectweb.medor.expression.api.ParameterOperand;
import org.objectweb.medor.expression.parser.api.ParameterTypeProvider;
import org.objectweb.medor.expression.parser.string.ExpressionParser;
import org.objectweb.util.monolog.api.BasicLevel;

public class BasicClass
extends BasicMetaObject
implements Class {
    private boolean abstractClass;
    private String fileName;
    private String name;
    private ArrayList nameDefs;
    private HashMap nd2Exp;
    private HashMap nd2Key;
    private Map classRefs;
    private Map genClassRefs;
    private Map primitiveElements;
    private Map hiddenFields;
    private Map pe2Value;
    private ArrayList derivedClasses;
    private Map superClasses;
    private HashMap classProjects;

    public BasicClass(String className, MetaObject parent) {
        super(parent);
        this.name = className;
        this.abstractClass = false;
        this.classRefs = new HashMap();
        this.genClassRefs = new HashMap();
        this.nameDefs = new ArrayList();
        this.primitiveElements = new HashMap();
        this.hiddenFields = new HashMap();
        this.derivedClasses = new ArrayList();
        this.superClasses = new HashMap();
        this.classProjects = new HashMap();
        this.fileName = this.getFQName().replace('.', System.getProperty("file.separator").charAt(0)) + ".pd";
    }

    protected Collection getChildren() {
        ArrayList res = new ArrayList();
        res.addAll(this.nameDefs);
        res.addAll(this.classProjects.values());
        res.addAll(this.superClasses.values());
        res.addAll(this.getAllFields());
        res.addAll(this.getAllHiddenFields());
        return res;
    }

    public Package getPackage() {
        return (Package)this.parent;
    }

    public String getFileName() {
        return this.fileName;
    }

    public void setFileName(String filename) {
        this.fileName = filename;
    }

    public boolean isAbstract() {
        return this.abstractClass;
    }

    public void setAbstract(boolean isAbstract) {
        this.abstractClass = isAbstract;
    }

    public String getName() {
        return this.name;
    }

    public String getFQName() {
        String packName = null;
        MetaObject parent = this.getParent();
        if (parent instanceof Package) {
            packName = ((Package)parent).getName();
        }
        if (packName == null || packName.length() == 0) {
            return this.name;
        }
        return packName + "." + this.name;
    }

    public TypedElement getTypedElement(String fieldName) {
        if (this.debug) {
            this.logger.log(BasicLevel.DEBUG, (Object)("try to return field (" + fieldName + ")"));
        }
        TypedElement res = null;
        res = (TypedElement)this.primitiveElements.get(fieldName);
        if (res != null) {
            if (this.debug) {
                this.logger.log(BasicLevel.DEBUG, (Object)"the field is a PrimitiveElement object");
            }
            return res;
        }
        res = (TypedElement)this.hiddenFields.get(fieldName);
        if (res != null) {
            if (this.debug) {
                this.logger.log(BasicLevel.DEBUG, (Object)"the field is an hiddenfield object");
            }
            return res;
        }
        res = (TypedElement)this.classRefs.get(fieldName);
        if (this.classRefs.get(fieldName) != null) {
            if (this.debug) {
                this.logger.log(BasicLevel.DEBUG, (Object)"the field is a ClassRef object");
            }
            return res;
        }
        res = (TypedElement)this.genClassRefs.get(fieldName);
        if (res != null) {
            if (this.debug) {
                this.logger.log(BasicLevel.DEBUG, (Object)"the field is a GenClassRef object");
            }
            return (GenClassRef)this.genClassRefs.get(fieldName);
        }
        Iterator it = this.getSuperClasses().iterator();
        while (it.hasNext() && res == null) {
            res = ((Class)it.next()).getTypedElement(fieldName);
        }
        if (res == null && this.debug) {
            this.logger.log(BasicLevel.DEBUG, (Object)("the field (" + fieldName + ") is not defined in the current class"));
        }
        return res;
    }

    public TypedElement removeTypedElement(String fieldName) {
        TypedElement res = (TypedElement)this.primitiveElements.remove(fieldName);
        if (res != null) {
            return res;
        }
        res = (TypedElement)this.hiddenFields.remove(fieldName);
        if (res != null) {
            return res;
        }
        res = (TypedElement)this.classRefs.remove(fieldName);
        if (this.classRefs.get(fieldName) != null) {
            return res;
        }
        res = (TypedElement)this.genClassRefs.remove(fieldName);
        return res;
    }

    public NameDef createNameDef() {
        if (this.debug) {
            this.logger.log(BasicLevel.DEBUG, (Object)("create a new NameDef () for the current Class '" + this.name + "'"));
        }
        BasicNameDef newNameDef = new BasicNameDef(this);
        this.setLoggingOnChild(newNameDef);
        this.nameDefs.add(newNameDef);
        return newNameDef;
    }

    public NameDef getNameDef(String name) {
        Iterator iter = this.nameDefs.iterator();
        while (iter.hasNext()) {
            NameDef nameDef = (NameDef)iter.next();
            if (!nameDef.getName().equals(name)) continue;
            return nameDef;
        }
        return null;
    }

    public Collection getNameDefs() {
        return this.nameDefs;
    }

    public synchronized Expression getInheritanceFilter(NameDef nd) throws ExpressionException {
        Expression filter;
        Expression expression = filter = this.nd2Exp == null ? null : (Expression)this.nd2Exp.get(nd);
        if (filter instanceof String) {
            filter = this.parseInheritanceFilter((String)((Object)filter), nd);
            this.nd2Exp.put(nd, filter);
        }
        if (filter == null && !this.superClasses.isEmpty()) {
            Iterator it = this.getSuperClasses().iterator();
            while (it.hasNext() && filter == null) {
                Class cl = (Class)it.next();
                filter = cl.getInheritanceFilter(nd);
            }
        }
        return filter;
    }

    public Object getInheritanceNamingKey(NameDef nd) {
        return this.nd2Key == null ? null : this.nd2Key.get(nd);
    }

    public void setInheritanceFilter(NameDef nd, Expression e) {
        if (nd == null || e == null) {
            return;
        }
        if (this.nd2Exp == null) {
            this.nd2Exp = new HashMap(5);
        }
        this.nd2Exp.put(nd, e);
    }

    public void setInheritanceFilter(NameDef nd, String filter) {
        if (nd == null || filter == null) {
            return;
        }
        if (this.nd2Exp == null) {
            this.nd2Exp = new HashMap(5);
        }
        this.nd2Exp.put(nd, filter);
    }

    public void setInheritanceNamingKey(NameDef nd, Object key) {
        if (nd == null) {
            return;
        }
        if (this.nd2Key == null) {
            this.nd2Key = new HashMap(5);
        }
        this.nd2Key.put(nd, key);
    }

    public PrimitiveElement createPrimitiveElement(String fieldName, PType type, int size, int scale) {
        PrimitiveElement result;
        if (this.debug) {
            this.logger.log(BasicLevel.DEBUG, (Object)("create a new PrimitiveElement (" + fieldName + ") for the current Class (" + this.name + ")"));
        }
        if ((result = (PrimitiveElement)this.primitiveElements.get(fieldName)) != null) {
            if (this.logger != null) {
                this.logger.log(BasicLevel.WARN, (Object)("Try to create an existing PrimitiveElement (" + fieldName + "), return existing one"));
            }
        } else {
            result = new BasicPrimitiveElement(fieldName, type, size, scale, this);
            this.setLoggingOnChild(result);
            this.primitiveElements.put(fieldName, result);
        }
        return result;
    }

    public void setConstantValue(String fieldName, String cv) {
        if (this.pe2Value == null) {
            this.pe2Value = new HashMap();
        }
        this.pe2Value.put(fieldName, cv);
    }

    public String getConstantValue(String fieldName) {
        return this.pe2Value == null ? null : (String)this.pe2Value.get(fieldName);
    }

    public ScalarField createHiddenField(String fieldName, PType type, int size, int scale) {
        ScalarField result;
        if (this.debug) {
            this.logger.log(BasicLevel.DEBUG, (Object)("create a new HiddenField (" + fieldName + ") for the current class (" + this.name + ")"));
        }
        if ((result = (ScalarField)this.hiddenFields.get(fieldName)) != null) {
            if (this.logger != null) {
                this.logger.log(BasicLevel.WARN, (Object)("Try to create an existing HiddenField (" + fieldName + "), return existing one"));
            }
        } else {
            result = new BasicScalarField(fieldName, type, size, scale, this);
            this.setLoggingOnChild(result);
            this.hiddenFields.put(fieldName, result);
        }
        return result;
    }

    public ClassRef createClassRef(String fieldName, Class class_) {
        ClassRef result;
        if (this.debug) {
            this.logger.log(BasicLevel.DEBUG, (Object)("create a new ClassRef (" + fieldName + ") for the current Class (" + this.name + ")"));
        }
        if ((result = (ClassRef)this.classRefs.get(fieldName)) != null) {
            if (this.logger != null) {
                this.logger.log(BasicLevel.WARN, (Object)("attention, try to create an existing ClassRef (" + fieldName + "), return existing one"));
            }
        } else {
            result = new BasicClassRef(fieldName, class_, this);
            this.setLoggingOnChild(result);
            this.classRefs.put(fieldName, result);
        }
        return result;
    }

    public GenClassRef createGenClassRef(String fieldName, String genName) {
        GenClassRef result;
        if (this.debug) {
            this.logger.log(BasicLevel.DEBUG, (Object)("create a new GenClassRef (" + genName + ") from field (" + fieldName + ") from Class (" + this.name + ")"));
        }
        if ((result = (GenClassRef)this.genClassRefs.get(fieldName)) != null) {
            if (this.logger != null) {
                this.logger.log(BasicLevel.WARN, (Object)("attention, try to create an existing GenClassRef (" + fieldName + "), return existing one"));
            }
        } else {
            result = new BasicGenClassRef(genName, fieldName, this);
            this.setLoggingOnChild(result);
            this.genClassRefs.put(fieldName, result);
        }
        return result;
    }

    protected List listField() {
        return this.listField(new ArrayList());
    }

    protected List listField(List allFields) {
        allFields.addAll(this.primitiveElements.values());
        allFields.addAll(this.classRefs.values());
        allFields.addAll(this.genClassRefs.values());
        Collections.sort(allFields, FieldComparator.instance);
        return allFields;
    }

    protected List listAllFields(List allFields) {
        this.listField(allFields);
        Iterator iter = this.getSuperClasses().iterator();
        while (iter.hasNext()) {
            ((BasicClass)iter.next()).listAllFields(allFields);
        }
        return allFields;
    }

    public Collection getFields() {
        List fields = this.listField(new ArrayList());
        Collections.sort(fields, FieldComparator.instance);
        return fields;
    }

    public Collection getAllFields() {
        List allFields = this.listAllFields(new ArrayList());
        Collections.sort(allFields, FieldComparator.instance);
        return allFields;
    }

    protected List listHiddenFields(List allFields) {
        allFields.addAll(this.hiddenFields.values());
        return allFields;
    }

    protected List listAllHiddenField(List allFields) {
        this.listHiddenFields(allFields);
        Iterator iter = this.getSuperClasses().iterator();
        while (iter.hasNext()) {
            ((BasicClass)iter.next()).listAllHiddenField(allFields);
        }
        return allFields;
    }

    public Collection getHiddenFields() {
        List hiddenFields = this.listHiddenFields(new ArrayList());
        Collections.sort(hiddenFields, FieldComparator.instance);
        return hiddenFields;
    }

    public Collection getAllHiddenFields() {
        List allFields = this.listAllHiddenField(new ArrayList());
        Collections.sort(allFields, FieldComparator.instance);
        return allFields;
    }

    public ScalarField getHiddenField(String fieldName) {
        if (this.debug) {
            this.logger.log(BasicLevel.DEBUG, (Object)("try to return an hidden field (" + fieldName + ")"));
        }
        return (ScalarField)this.hiddenFields.get(fieldName);
    }

    public Collection getSubClasses() {
        return this.derivedClasses;
    }

    public Collection getSuperClasses() {
        return this.superClasses.values();
    }

    public Class getSuperClass(String fqcn) {
        return (Class)this.superClasses.get(fqcn);
    }

    public void addSuperClass(Class class_) {
        if (class_ != null && !this.superClasses.containsKey(class_.getFQName())) {
            this.superClasses.put(class_.getFQName(), class_);
            class_.addSubClass(this);
        }
    }

    public void addSubClass(Class class_) {
        if (class_ != null && !this.derivedClasses.contains(class_)) {
            this.derivedClasses.add(class_);
            class_.addSuperClass(this);
        }
    }

    public int getInheritedClassNumber() {
        return this.superClasses.size();
    }

    public List getAllAncestors() {
        if (this.superClasses.isEmpty()) {
            return Collections.EMPTY_LIST;
        }
        ArrayList<Class> ancestors = new ArrayList<Class>();
        ancestors.add(this);
        for (int i = 0; i < ancestors.size(); ++i) {
            Class clazz = (Class)ancestors.get(i);
            Collection c = clazz.getSuperClasses();
            Iterator it = c.iterator();
            while (it.hasNext()) {
                Class superClass = (Class)it.next();
                if (ancestors.contains(superClass)) continue;
                ancestors.add(superClass);
            }
        }
        ancestors.remove(0);
        return ancestors;
    }

    public List getAncestors() {
        if (this.superClasses.isEmpty()) {
            return Collections.EMPTY_LIST;
        }
        ArrayList<Class> ancestors = new ArrayList<Class>();
        ArrayList<Class> roots = new ArrayList<Class>();
        ancestors.add(this);
        while (!ancestors.isEmpty()) {
            Class clazz = (Class)ancestors.remove(0);
            Collection c = clazz.getSuperClasses();
            if (c.isEmpty()) {
                if (roots.contains(clazz)) continue;
                roots.add(clazz);
                continue;
            }
            Iterator it = c.iterator();
            while (it.hasNext()) {
                Class superClass = (Class)it.next();
                if (ancestors.contains(superClass)) continue;
                ancestors.add(superClass);
            }
        }
        return roots;
    }

    public boolean isPolymorphic() {
        return !this.getSubClasses().isEmpty() || !this.getSuperClasses().isEmpty();
    }

    public PType getPType() {
        try {
            PType type = this.getManager().getPTypeSpace().getPType(this.getFQName());
            if (type != null) {
                return type;
            }
            if (this.superClasses.isEmpty()) {
                return this.getManager().getPTypeSpace().createPType(this.getFQName());
            }
            List ancestors = this.getAllAncestors();
            ArrayList<String[]> couples = new ArrayList<String[]>(ancestors.size());
            for (int i = 0; i < ancestors.size(); ++i) {
                Class clazz = (Class)ancestors.get(i);
                Collection superClasses = clazz.getSuperClasses();
                Iterator it = superClasses.iterator();
                while (it.hasNext()) {
                    Class superClass = (Class)it.next();
                    couples.add(new String[]{clazz.getFQName(), superClass.getFQName()});
                }
            }
            return this.getManager().getPTypeSpace().createPType(this.getFQName(), (String[][])couples.toArray((T[])new String[couples.size()][]));
        }
        catch (Exception e) {
            this.logger.log(BasicLevel.ERROR, (Object)("impossible to compute the PType of the class " + this.getFQName()), (Throwable)e);
            return null;
        }
    }

    public int getFieldRefNumber() {
        return this.classRefs.size();
    }

    public ClassProject getClassProject(String projectName) {
        return (ClassProject)this.classProjects.get(projectName);
    }

    public ClassMapping getClassMapping(String projectName, String mapperName) {
        ClassProject cp = (ClassProject)this.classProjects.get(projectName);
        if (cp == null) {
            return null;
        }
        Mapping mapping = cp.getMapping(mapperName);
        if (mapping == null) {
            return null;
        }
        return mapping.getClassMapping();
    }

    public Collection getClassProjects() {
        return this.classProjects.values();
    }

    public void addClassProject(String projectName, ClassProject classProject) {
        if (!this.classProjects.containsKey(projectName)) {
            this.classProjects.put(projectName, classProject);
        }
    }

    public ClassProject createClassProject(String projectName) {
        ClassProject cp;
        if (this.debug) {
            this.logger.log(BasicLevel.DEBUG, (Object)("create a new ClassProject for the current Class (" + this.name + ") projectName=<" + projectName + ">"));
        }
        if ((cp = (ClassProject)this.classProjects.get(projectName)) == null) {
            cp = new BasicClassProject(projectName, this);
            this.classProjects.put(projectName, cp);
            return cp;
        }
        if (this.debug) {
            this.logger.log(BasicLevel.DEBUG, (Object)("return the existing ClassProject " + projectName));
        }
        return cp;
    }

    public ClassProject removeClassProject(String projectname) {
        return (ClassProject)this.classProjects.remove(projectname);
    }

    public Expression parseInheritanceFilter(String filter, NameDef nd) throws ExpressionException {
        return new ExpressionParser().parse(filter, new BasicParameterTypeProvider());
    }

    public boolean generateKFPNC() throws ExpressionException {
        Expression exp = null;
        for (int i = 0; i < this.nameDefs.size(); ++i) {
            NameDef nd = (NameDef)this.nameDefs.get(i);
            exp = this.getInheritanceFilter(nd);
            if (this.detectFilterElementNotInPK(exp, nd)) continue;
            return true;
        }
        return false;
    }

    public boolean detectFilterElementNotInPK(Expression exp, NameDef nd) throws ExpressionException {
        if (exp instanceof Operator) {
            Operator operator = (Operator)exp;
            int nb = operator.getOperandNumber();
            if (nb == 1) {
                return this.detectFilterElementNotInPK(operator.getExpression(0), nd);
            }
            if (nb == 2) {
                return this.detectFilterElementNotInPK(operator.getExpression(0), nd) || this.detectFilterElementNotInPK(operator.getExpression(1), nd);
            }
            throw new ExpressionException("Operators with more than 2 operands are not supported: " + exp);
        }
        if (exp instanceof ParameterOperand) {
            ParameterOperand po = (ParameterOperand)exp;
            if (nd.isNameRef()) {
                Collection fields = nd.getNameRef().getProjection().values();
                return !fields.contains(po.getName());
            }
            return !po.getName().equals(nd.getFieldName());
        }
        return false;
    }

    private class BasicParameterTypeProvider
    implements ParameterTypeProvider {
        private BasicParameterTypeProvider() {
        }

        public PType getParameterPType(String s) throws MalformedExpressionException {
            TypedElement te = BasicClass.this.getTypedElement(s);
            return te == null ? null : te.getType();
        }
    }
}

