/*
 * Decompiled with CFR 0.152.
 */
package org.objectweb.jorm.metainfo.lib;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import org.objectweb.jorm.metainfo.api.CompositeName;
import org.objectweb.jorm.metainfo.api.MetaObject;
import org.objectweb.jorm.metainfo.api.Package;
import org.objectweb.jorm.metainfo.api.ScalarField;
import org.objectweb.jorm.metainfo.lib.BasicMetaObject;
import org.objectweb.jorm.metainfo.lib.BasicScalarField;
import org.objectweb.jorm.metainfo.lib.FieldComparator;
import org.objectweb.jorm.type.api.PType;
import org.objectweb.util.monolog.api.BasicLevel;

public class BasicCompositeName
extends BasicMetaObject
implements CompositeName {
    private ArrayList inheritedCompositeNames;
    private Map scalarFields;
    private String name = null;

    public BasicCompositeName(String className, MetaObject parent) {
        super(parent);
        this.name = className;
        this.scalarFields = new HashMap(5);
        this.inheritedCompositeNames = new ArrayList();
    }

    public String getName() {
        return this.name;
    }

    public String getFQName() {
        String res = ((Package)this.parent).getName();
        if (res == null || res.length() == 0) {
            return this.name;
        }
        return res + "." + this.name;
    }

    public void addInheritedCompositeName(CompositeName cn) {
        if (this.debug && cn != null) {
            this.logger.log(BasicLevel.DEBUG, (Object)("The current compositename (" + this.name + ") inherits from the composite name (" + cn.getName() + ")"));
        }
        if (cn != null) {
            this.inheritedCompositeNames.add(cn);
        }
    }

    public Iterator iterateInheritedCompositeName() {
        return this.getSuperCompositeNames().iterator();
    }

    public Collection getSuperCompositeNames() {
        return this.inheritedCompositeNames;
    }

    public CompositeName getInheritedCompositeName(String name) {
        CompositeName res = null;
        boolean found = false;
        Iterator iter = this.iterateInheritedCompositeName();
        while (iter.hasNext() && !found) {
            res = (CompositeName)iter.next();
            if (!res.getName().equals(name)) continue;
            found = true;
        }
        if (found) {
            return res;
        }
        return null;
    }

    public ScalarField getScalarField(String fieldname) {
        if (this.debug) {
            this.logger.log(BasicLevel.DEBUG, (Object)("try to return field (" + fieldname + ")"));
        }
        ScalarField res = (ScalarField)this.scalarFields.get(fieldname);
        if (this.debug && res == null) {
            this.logger.log(BasicLevel.DEBUG, (Object)("the field (" + fieldname + ") is not defined in the current class"));
        }
        return res;
    }

    public int getInheritedCompositeNameNumber() {
        return this.inheritedCompositeNames.size();
    }

    public ScalarField createCompositeNameField(String fieldname, PType type, int size, int scale) {
        ScalarField result;
        if (this.debug) {
            this.logger.log(BasicLevel.DEBUG, (Object)("create a new NameField (" + fieldname + ") for the current CompositeName (" + this.name + ")"));
        }
        if ((result = (ScalarField)this.scalarFields.get(fieldname)) != null) {
            if (this.logger != null) {
                this.logger.log(BasicLevel.WARN, (Object)("attention, try to create an existing ScalarField (" + fieldname + "), return existing one"));
            }
        } else {
            result = new BasicScalarField(fieldname, type, size, scale, this);
            this.setLoggingOnChild(result);
            this.scalarFields.put(fieldname, result);
        }
        return result;
    }

    public int getFieldNumber() {
        return this.scalarFields.size();
    }

    public Iterator iterateField() {
        return this.scalarFields.values().iterator();
    }

    public Collection getFields() {
        return this.scalarFields.values();
    }

    public Collection getAllFields() {
        ArrayList allFields = new ArrayList();
        allFields.addAll(this.scalarFields.values());
        Iterator iter = this.inheritedCompositeNames.iterator();
        while (iter.hasNext()) {
            CompositeName aCN = (CompositeName)iter.next();
            allFields.addAll(aCN.getAllFields());
        }
        Collections.sort(allFields, FieldComparator.instance);
        return allFields;
    }

    public Iterator iterateAllField() {
        return this.getAllFields().iterator();
    }

    public Collection getAllField() {
        return this.getAllFields();
    }

    protected Collection getChildren() {
        return this.getAllFields();
    }
}

