/*
 * Decompiled with CFR 0.152.
 */
package org.objectweb.jorm.metainfo.lib;

import java.io.PrintStream;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import java.util.Map;
import org.objectweb.jorm.metainfo.api.Class;
import org.objectweb.jorm.metainfo.api.ClassMapping;
import org.objectweb.jorm.metainfo.api.ClassProject;
import org.objectweb.jorm.metainfo.api.ClassRef;
import org.objectweb.jorm.metainfo.api.CompositeName;
import org.objectweb.jorm.metainfo.api.GenClassMapping;
import org.objectweb.jorm.metainfo.api.GenClassRef;
import org.objectweb.jorm.metainfo.api.Manager;
import org.objectweb.jorm.metainfo.api.Mapping;
import org.objectweb.jorm.metainfo.api.MappingFactory;
import org.objectweb.jorm.metainfo.api.MappingPrinter;
import org.objectweb.jorm.metainfo.api.MetaObject;
import org.objectweb.jorm.metainfo.api.NameDef;
import org.objectweb.jorm.metainfo.api.NameRef;
import org.objectweb.jorm.metainfo.api.Package;
import org.objectweb.jorm.metainfo.api.PrimitiveElement;
import org.objectweb.jorm.metainfo.api.PrimitiveElementMapping;
import org.objectweb.jorm.metainfo.api.Reference;
import org.objectweb.jorm.metainfo.api.TypedElement;
import org.objectweb.jorm.metainfo.lib.BasicMetaObject;
import org.objectweb.jorm.type.api.PType;
import org.objectweb.util.monolog.api.Logger;
import org.objectweb.util.monolog.wrapper.printwriter.PrintStreamImpl;

public class MetaInfoPrinter {
    ArrayList mappingprinters = null;
    public static final String TAB = "    ";

    public static void printMO(MetaObject mo) {
        MetaInfoPrinter.printMO("", mo, System.out);
    }

    public static void printMO(String prefix, MetaObject mo, PrintStream out) {
        new MetaInfoPrinter(mo).print(prefix, mo, out);
    }

    public MetaInfoPrinter() {
        this.mappingprinters = new ArrayList();
    }

    public MetaInfoPrinter(MetaObject mo) {
        this(((BasicMetaObject)mo).getManager());
    }

    public MetaInfoPrinter(Manager m) {
        Collection c = m.getMappingFactories();
        this.mappingprinters = new ArrayList(c.size());
        Iterator it = c.iterator();
        while (it.hasNext()) {
            this.mappingprinters.add(((MappingFactory)it.next()).createMappingPrinter());
        }
    }

    public void addMappingPrinter(MappingPrinter vmp) {
        this.mappingprinters.add(vmp);
    }

    public void print(String p, MetaObject mo, Logger logger) {
        this.print(p, mo, (PrintStream)new PrintStreamImpl(logger));
    }

    public void print(String p, MetaObject mo, PrintStream out) {
        if (mo instanceof Package) {
            this.print(p, (Package)mo, out);
        } else if (mo instanceof Class) {
            this.print(p, (Class)mo, out);
        } else if (mo instanceof CompositeName) {
            this.print(p, (CompositeName)mo, out);
        } else if (mo instanceof TypedElement) {
            this.print(p, (TypedElement)mo, out);
        } else if (mo instanceof NameDef) {
            this.print(p, (NameDef)mo, out);
        } else if (mo instanceof NameRef) {
            this.print(p, (NameRef)mo, out);
        } else if (mo instanceof ClassMapping) {
            this.print(p, (ClassMapping)mo, out);
        } else if (mo instanceof GenClassMapping) {
            this.print(p, (GenClassMapping)mo, out);
        } else if (mo instanceof PrimitiveElementMapping) {
            this.print(p, (PrimitiveElementMapping)mo, out);
        } else {
            out.print("Unknown meta object: " + mo);
        }
    }

    public void print(String p, Manager mgr, PrintStream out) {
        out.println("Print the meta information of the mnanager: " + mgr);
        Iterator it = mgr.getPackages().iterator();
        while (it.hasNext()) {
            this.print(p, (Package)it.next(), out);
        }
    }

    public void print(String p, Package sc, PrintStream out) {
        Iterator it = sc.getClasses().iterator();
        while (it.hasNext()) {
            this.print(p, (Class)it.next(), out);
        }
        it = sc.iterateCompositeName();
        while (it.hasNext()) {
            this.print(p, (CompositeName)it.next(), out);
        }
    }

    public void print(String p, CompositeName cn, PrintStream out) {
        out.println(p + "* CompositeName " + cn.getFQName());
        Iterator it = cn.getAllFields().iterator();
        while (it.hasNext()) {
            this.print(p, (TypedElement)it.next(), out);
        }
    }

    public void print(String p, Class clazz, PrintStream out) {
        out.println(p + "* Class " + clazz.getFQName());
        Iterator it = clazz.getSuperClasses().iterator();
        while (it.hasNext()) {
            out.println(p + TAB + "extends " + ((Class)it.next()).getFQName());
        }
        out.println(p + "Persistent fields");
        it = clazz.getAllFields().iterator();
        while (it.hasNext()) {
            this.print(p + TAB, (TypedElement)it.next(), out);
        }
        it = clazz.getAllHiddenFields().iterator();
        out.println(p + "Hidden persistent fields");
        while (it.hasNext()) {
            this.print(p + TAB, (TypedElement)it.next(), out);
        }
        it = clazz.getNameDefs().iterator();
        out.println(p + "NameDef of the class " + clazz.getName());
        while (it.hasNext()) {
            this.print(p + TAB, (NameDef)it.next(), out);
        }
        it = clazz.getClassProjects().iterator();
        while (it.hasNext()) {
            ClassProject cp = (ClassProject)it.next();
            String msg = p + "Project: " + cp.getProjectName() + ",";
            Iterator mit = cp.getMappings().iterator();
            if (!mit.hasNext()) {
                out.println(msg + " no mapping defined ");
            }
            while (mit.hasNext()) {
                Mapping m = (Mapping)mit.next();
                out.println(msg + " Mapper: " + m.getMapperName());
                this.print(p, m.getClassMapping(), out);
                Iterator gcmit = m.getGenClassMappings().iterator();
                while (gcmit.hasNext()) {
                    this.print(p + TAB, (GenClassMapping)gcmit.next(), out);
                }
            }
        }
    }

    public void print(String p, TypedElement te, PrintStream out) {
        if (te == null) {
            out.print("ERROR: null field");
            return;
        }
        PType type = te.getType();
        String strtype = type == null ? " type is null" : te.getType().getJormName();
        out.print(p + "- Field  " + strtype + " " + te.getName());
        if (te instanceof Reference) {
            this.print(p, (Reference)te, out);
        } else if (te instanceof PrimitiveElement) {
            this.print(p, (PrimitiveElement)te, out);
        } else {
            out.print("ERROR: Unknon typedlement" + te);
        }
    }

    public void print(String p, PrimitiveElement pe, PrintStream out) {
        if (pe.isScalar()) {
            out.println(" (scalar)");
        } else {
            out.println();
        }
    }

    public void print(String p, Reference ref, PrintStream out) {
        if (ref instanceof ClassRef) {
            this.print((ClassRef)ref, out);
        } else if (ref instanceof GenClassRef) {
            this.print(p, (GenClassRef)ref, out);
        }
        out.println(p + "NameDef of the reference " + ref.getName());
        Iterator it = ref.getRefNameDef().iterator();
        while (it.hasNext()) {
            this.print(p + TAB, (NameDef)it.next(), out);
        }
    }

    public void print(String p, NameDef nd, PrintStream out) {
        if (nd.isFieldName()) {
            out.println(p + "fieldName: " + nd.getFieldName());
        } else if (nd.isNameRef()) {
            this.print(p, nd.getNameRef(), out);
        }
    }

    public void print(String p, NameRef nr, PrintStream out) {
        out.println(p + "NameRef name: " + nr.getName() + " / Compsosite name: " + nr.getCompositeName());
        out.println(p + TAB + "Projection: " + nr.getCompositeName());
        Map proj = nr.getProjection();
        Iterator it = proj.entrySet().iterator();
        while (it.hasNext()) {
            Map.Entry me = it.next();
            out.println(p + TAB + "composite field name: " + me.getKey() + " / class field Name: " + me.getValue());
        }
    }

    public void print(ClassRef cr, PrintStream out) {
        out.println("ClassRef: " + cr.getClassName());
    }

    public void print(String p, GenClassRef gcr, PrintStream out) {
        out.println(p + "GenClass " + gcr.getName() + "hidden persistent fields");
        Iterator it = gcr.getHiddenFields().iterator();
        while (it.hasNext()) {
            this.print(p + TAB, (TypedElement)it.next(), out);
        }
        out.println(p + "NameDef of the GenClass " + gcr.getName());
        it = gcr.getIdNameDef().iterator();
        while (it.hasNext()) {
            this.print(p + TAB, (NameDef)it.next(), out);
        }
        out.println(p + "=====Gen class " + gcr.getName() + " element: begin");
        if (gcr.isPrimitive()) {
            out.println(p + "GenClassRef " + gcr.getName() + " has a PrimitveElement");
            this.print(p + TAB, (TypedElement)gcr.getPrimitiveElement(), out);
        } else if (gcr.isClassRef()) {
            out.println(p + "GenClassRef " + gcr.getName() + " has a PrimitveElement");
            this.print(p + TAB, (TypedElement)gcr.getClassRef(), out);
        } else if (gcr.isGenClassRef()) {
            out.println(p + "GenClassRef " + gcr.getName() + " has a GenClassRef");
            this.print(p + TAB, (TypedElement)gcr.getGenClassRef(), out);
        } else {
            out.print("ERROR: unknown inner element type of the gen class: " + gcr.getName());
        }
        out.println(p + "=====Gen class " + gcr.getName() + " element: end");
        out.println(p + "ClassMapping of the genclass " + gcr.getName());
    }

    public void print(String p, PrimitiveElementMapping vm, PrintStream out) {
        Iterator it = this.mappingprinters.iterator();
        while (it.hasNext()) {
            MappingPrinter mp = (MappingPrinter)it.next();
            if (!mp.canPrint(vm)) continue;
            mp.print(p + TAB, vm, out);
            return;
        }
        out.println(p + "WARN: Unable to print the value mapping: " + vm);
    }

    public void print(String p, ClassMapping cm, PrintStream out) {
        Iterator it = this.mappingprinters.iterator();
        while (it.hasNext()) {
            MappingPrinter mp = (MappingPrinter)it.next();
            if (!mp.canPrint(cm)) continue;
            mp.print(p + TAB, cm, out);
            return;
        }
        out.println(p + "WARN: Unable to print the class mapping: " + cm);
    }

    public void print(String p, GenClassMapping gcm, PrintStream out) {
        Iterator it = this.mappingprinters.iterator();
        while (it.hasNext()) {
            MappingPrinter mp = (MappingPrinter)it.next();
            if (!mp.canPrint(gcm)) continue;
            mp.print(p + TAB, gcm, out);
            return;
        }
        out.println(p + "WARN: Unable to print the genclass mapping: " + gcm);
    }
}

