/*
 * Decompiled with CFR 0.152.
 */
package org.objectweb.jorm.type.api;

import java.io.Serializable;
import org.objectweb.jorm.type.api.PTypeSpace;

public class PType
implements Serializable {
    public static final int NOSIZE = -1;
    public static final short TYPECODE_BOOLEAN = 0;
    public static final short TYPECODE_CHAR = 1;
    public static final short TYPECODE_BYTE = 2;
    public static final short TYPECODE_SHORT = 3;
    public static final short TYPECODE_INT = 4;
    public static final short TYPECODE_LONG = 5;
    public static final short TYPECODE_FLOAT = 6;
    public static final short TYPECODE_DOUBLE = 7;
    public static final short TYPECODE_OBJBOOLEAN = 8;
    public static final short TYPECODE_OBJCHAR = 9;
    public static final short TYPECODE_OBJBYTE = 10;
    public static final short TYPECODE_OBJSHORT = 11;
    public static final short TYPECODE_OBJINT = 12;
    public static final short TYPECODE_OBJLONG = 13;
    public static final short TYPECODE_OBJFLOAT = 14;
    public static final short TYPECODE_OBJDOUBLE = 15;
    public static final short TYPECODE_STRING = 16;
    public static final short TYPECODE_DATE = 17;
    public static final short TYPECODE_CHARARRAY = 18;
    public static final short TYPECODE_BYTEARRAY = 19;
    public static final short TYPECODE_SERIALIZED = 20;
    public static final short TYPECODE_BIGINTEGER = 21;
    public static final short TYPECODE_BIGDECIMAL = 22;
    public static final short TYPECODE_REFERENCE = 23;
    public static final short TYPECODE_OBJECT = 203;
    public static final short TYPECODE_COLLECTION = 204;
    private short typeCode;
    private String jormName;
    private String javaName;
    private Class javaClass;
    private String codingName;
    private String progConstName;
    private PTypeSpace typeSpace;

    protected PType(short typecode, String jormname, String javaname, Class javaclass, String constname, String codingname) {
        this.typeCode = typecode;
        this.jormName = jormname;
        this.javaName = javaname;
        this.javaClass = javaclass;
        this.codingName = codingname;
        this.progConstName = constname;
        this.typeSpace = null;
    }

    protected PType(String classname, PTypeSpace typespace) {
        this.typeCode = (short)23;
        this.jormName = classname;
        this.javaName = "java.lang.Object";
        this.typeSpace = typespace;
    }

    public boolean isa(PType pt) {
        switch (this.typeCode) {
            case 0: {
                return pt.typeCode == 0;
            }
            case 1: {
                switch (pt.typeCode) {
                    case 1: 
                    case 4: 
                    case 5: 
                    case 6: 
                    case 7: {
                        return true;
                    }
                }
                return false;
            }
            case 2: {
                switch (pt.typeCode) {
                    case 2: 
                    case 3: 
                    case 4: 
                    case 5: 
                    case 6: 
                    case 7: {
                        return true;
                    }
                }
                return false;
            }
            case 3: {
                switch (pt.typeCode) {
                    case 3: 
                    case 4: 
                    case 5: 
                    case 6: 
                    case 7: {
                        return true;
                    }
                }
                return false;
            }
            case 4: {
                switch (pt.typeCode) {
                    case 4: 
                    case 5: 
                    case 6: 
                    case 7: {
                        return true;
                    }
                }
                return false;
            }
            case 5: {
                switch (pt.typeCode) {
                    case 5: 
                    case 6: 
                    case 7: {
                        return true;
                    }
                }
                return false;
            }
            case 6: {
                switch (pt.typeCode) {
                    case 6: 
                    case 7: {
                        return true;
                    }
                }
                return false;
            }
            case 7: {
                return pt.typeCode == 7;
            }
            case 8: {
                return pt.typeCode == 8 || pt.typeCode == 20;
            }
            case 9: {
                switch (pt.typeCode) {
                    case 9: 
                    case 12: 
                    case 13: 
                    case 14: 
                    case 15: 
                    case 20: {
                        return true;
                    }
                }
                return false;
            }
            case 10: {
                switch (pt.typeCode) {
                    case 10: 
                    case 11: 
                    case 12: 
                    case 13: 
                    case 14: 
                    case 15: 
                    case 20: {
                        return true;
                    }
                }
                return false;
            }
            case 11: {
                switch (pt.typeCode) {
                    case 11: 
                    case 12: 
                    case 13: 
                    case 14: 
                    case 15: 
                    case 20: {
                        return true;
                    }
                }
                return false;
            }
            case 12: {
                switch (pt.typeCode) {
                    case 12: 
                    case 13: 
                    case 14: 
                    case 15: 
                    case 20: {
                        return true;
                    }
                }
                return false;
            }
            case 13: {
                switch (pt.typeCode) {
                    case 13: 
                    case 14: 
                    case 15: 
                    case 20: {
                        return true;
                    }
                }
                return false;
            }
            case 14: {
                switch (pt.typeCode) {
                    case 14: 
                    case 15: 
                    case 20: {
                        return true;
                    }
                }
                return false;
            }
            case 15: {
                return pt.typeCode == 15 || pt.typeCode == 20;
            }
            case 16: {
                return pt.typeCode == 16 || pt.typeCode == 20;
            }
            case 17: {
                return pt.typeCode == 17 || pt.typeCode == 20;
            }
            case 20: {
                return pt.typeCode == 20;
            }
            case 22: {
                return pt.typeCode == 22 || pt.typeCode == 20;
            }
            case 23: {
                if (pt.typeCode != 23) {
                    return false;
                }
                PTypeSpace pts = this.typeSpace;
                if (pts == null) {
                    pts = pt.getPTypeSpace();
                }
                return pts.isa(this, pt);
            }
        }
        return false;
    }

    public boolean equals(Object o) {
        if (!(o instanceof PType)) {
            return false;
        }
        PType p = (PType)o;
        return p.getTypeCode() == this.typeCode && (this.typeCode != 23 || this.jormName.equals(p.getJormName()));
    }

    public PType[] getInheritedPType() {
        return null;
    }

    public String getJormName() {
        return this.jormName;
    }

    public String getJavaName() {
        return this.javaName;
    }

    public Class getJavaClass() {
        return this.javaClass;
    }

    public String getCodingName() {
        return this.codingName;
    }

    public String getProgName() {
        return this.progConstName;
    }

    public PType getNestedPType() {
        return null;
    }

    public PTypeSpace getPTypeSpace() {
        return this.typeSpace;
    }

    public PType[] getSubTypes() {
        return this.typeSpace.getSubTypes(this);
    }

    public PType[] getDirectSubTypes() {
        PType[] subtypes = this.typeSpace.getSubTypes(this);
        if (subtypes.length == 0) {
            return subtypes;
        }
        int nbOfDirectSubType = 0;
        for (int i = 0; i < subtypes.length; ++i) {
            if (!subtypes[i].isDirectSubType(this)) {
                subtypes[i] = null;
                continue;
            }
            ++nbOfDirectSubType;
        }
        if (nbOfDirectSubType == 0) {
            return new PType[0];
        }
        if (nbOfDirectSubType == subtypes.length) {
            return subtypes;
        }
        PType[] result = new PType[nbOfDirectSubType];
        for (int i = 0; i < subtypes.length; ++i) {
            if (subtypes[i] == null) continue;
            result[--nbOfDirectSubType] = subtypes[i];
        }
        return result;
    }

    public boolean isDirectSubType(PType parent) {
        return this.isa(parent);
    }

    public int getTypeCode() {
        return this.typeCode;
    }
}

