/*
 * Decompiled with CFR 0.152.
 */
package org.objectweb.medor.eval.cache.lib;

import org.objectweb.medor.api.MedorException;
import org.objectweb.medor.api.TupleStructure;
import org.objectweb.medor.eval.cache.api.CachedTupleCollection;
import org.objectweb.medor.eval.cache.api.CollectionCache;
import org.objectweb.medor.tuple.api.Tuple;
import org.objectweb.medor.tuple.api.TupleCollection;

public class WindowCachedTupleCollection
implements CachedTupleCollection {
    private boolean closed = false;
    private CollectionCache tupleCache;
    private TupleCollection tc;
    private int cursor = 1;

    public WindowCachedTupleCollection(TupleCollection tc, CollectionCache tupleCache) throws MedorException {
        this.tupleCache = tupleCache;
        this.tc = tc;
    }

    public void close() throws MedorException {
        this.closed = true;
    }

    public TupleStructure getMetaData() throws MedorException {
        return this.tc.getMetaData();
    }

    public CollectionCache getCache() {
        return this.tupleCache;
    }

    public boolean isLast() throws MedorException {
        if (this.tc.getRow() == this.cursor) {
            return this.tc.isLast();
        }
        return !this.tupleCache.contains(this.cursor + 1);
    }

    public boolean next() throws MedorException {
        if (!this.isLast()) {
            ++this.cursor;
            if (!this.tupleCache.contains(this.cursor + 1)) {
                this.tc.next();
            }
            return true;
        }
        return false;
    }

    public void first() throws MedorException {
        this.cursor = 1;
        this.tupleCache.initialize();
        this.tc.first();
    }

    public Tuple getTuple() throws MedorException {
        Tuple t = null;
        t = this.tupleCache.getTuple(this.cursor);
        if (t == null) {
            t = this.tc.getTuple();
            this.tupleCache.putTuple(this.cursor, t);
            if (this.tc.isLast()) {
                this.tupleCache.setCanInsert(false);
            }
        }
        return t;
    }

    public Tuple getTuple(int row) throws MedorException {
        Tuple t = null;
        t = this.tupleCache.getTuple(row);
        if (t == null) {
            t = this.tc.getTuple(row);
            this.tupleCache.putTuple(row, t);
            if (this.tc.isLast()) {
                this.tupleCache.setCanInsert(false);
            }
        }
        return t;
    }

    public boolean row(int numTuple) throws MedorException {
        this.cursor = numTuple;
        this.tupleCache.initialize();
        return this.tc.row(numTuple);
    }

    public int getRow() throws MedorException {
        return this.cursor;
    }

    public boolean isEmpty() throws MedorException {
        return this.tc.isEmpty();
    }

    public int getLeftTCCursor() {
        return 0;
    }

    public int getRightTCCursor() {
        return 0;
    }
}

