/*
 * Decompiled with CFR 0.152.
 */
package org.objectweb.medor.eval.lib;

import org.objectweb.medor.api.MedorException;
import org.objectweb.medor.eval.api.EvaluationMetaData;
import org.objectweb.medor.eval.api.NodeEvaluator;
import org.objectweb.medor.eval.api.NodeEvaluatorFactory;
import org.objectweb.medor.eval.lib.BinaryIteratifNodeEvaluator;
import org.objectweb.medor.eval.lib.UnaryIteratifNodeEvaluator;
import org.objectweb.medor.query.api.QueryNode;

public class IteratifNodeEvaluatorFactory
implements NodeEvaluatorFactory {
    public NodeEvaluator createNodeEvaluator(QueryNode node, NodeEvaluator[] subEvaluators, EvaluationMetaData evalMD) throws MedorException {
        if (node.getChildren().length == 1 || subEvaluators.length == 1) {
            return new UnaryIteratifNodeEvaluator(node, subEvaluators[0], evalMD);
        }
        if (node.getChildren().length == 2 || subEvaluators.length == 2) {
            return new BinaryIteratifNodeEvaluator(node, subEvaluators[0], subEvaluators[1], evalMD);
        }
        throw new MedorException("This QueryNode is not evaluable: too many children (" + node.getChildren().length + ").");
    }
}

