/*
 * Decompiled with CFR 0.152.
 */
package org.objectweb.medor.expression.lib;

import java.math.BigDecimal;
import java.math.BigInteger;
import java.sql.Time;
import java.sql.Timestamp;
import java.util.Date;
import org.objectweb.medor.expression.api.Expression;
import org.objectweb.medor.expression.api.TypingException;
import org.objectweb.medor.expression.lib.BasicBinaryArithmeticOperator;

public class DivideBy
extends BasicBinaryArithmeticOperator {
    private static final long serialVersionUID = 8115928471067985393L;

    public DivideBy() {
    }

    public DivideBy(Expression l, Expression r) {
        super(l, r);
    }

    public int evaluate(int op1, int op2) {
        return op1 / op2;
    }

    public int evaluate(int op1, short op2) {
        return op1 / op2;
    }

    public long evaluate(int op1, long op2) {
        return (long)op1 / op2;
    }

    public float evaluate(int op1, float op2) {
        return (float)op1 / op2;
    }

    public double evaluate(int op1, double op2) {
        return (double)op1 / op2;
    }

    public float evaluate(float op1, float op2) {
        return op1 / op2;
    }

    public float evaluate(float op1, short op2) {
        return op1 / (float)op2;
    }

    public float evaluate(float op1, int op2) {
        return op1 / (float)op2;
    }

    public float evaluate(float op1, long op2) {
        return op1 / (float)op2;
    }

    public double evaluate(float op1, double op2) {
        return (double)op1 / op2;
    }

    public int evaluate(char op1, char op2) {
        return op1 / op2;
    }

    public long evaluate(long op1, long op2) {
        return op1 / op2;
    }

    public long evaluate(long op1, short op2) {
        return op1 / (long)op2;
    }

    public long evaluate(long op1, int op2) {
        return op1 / (long)op2;
    }

    public float evaluate(long op1, float op2) {
        return (float)op1 / op2;
    }

    public double evaluate(long op1, double op2) {
        return (double)op1 / op2;
    }

    public double evaluate(double op1, double op2) {
        return op1 / op2;
    }

    public double evaluate(double op1, short op2) {
        return op1 / (double)op2;
    }

    public double evaluate(double op1, int op2) {
        return op1 / (double)op2;
    }

    public double evaluate(double op1, float op2) {
        double res = op1 / (double)op2;
        return res;
    }

    public double evaluate(double op1, long op2) {
        return op1 / (double)op2;
    }

    public BigDecimal evaluate(BigDecimal op1, BigDecimal op2) {
        return op1.divide(op2, 7);
    }

    public BigInteger evaluate(BigInteger op1, BigInteger op2) {
        return op1.mod(op2);
    }

    public String evaluate(String op1, String op2) throws TypingException {
        throw new TypingException("div(String, String)?");
    }

    public String evaluate(String op1, char op2) throws TypingException {
        throw new TypingException("div(String, Char)?");
    }

    public String evaluate(char op1, String op2) throws TypingException {
        throw new TypingException("div(char, String)?");
    }

    public Timestamp evaluate(Timestamp op1, Timestamp op2) throws TypingException {
        throw new TypingException("div(Timestamp, Timestamp)?");
    }

    public Time evaluate(Time op1, Time op2) throws TypingException {
        throw new TypingException("div(Time, Time)?");
    }

    public Date evaluate(Date op1, Date op2) throws TypingException {
        throw new TypingException("div(Date, Date)?");
    }

    public String getOperatorString() {
        return "/";
    }
}

