/*
 * Decompiled with CFR 0.152.
 */
package org.objectweb.medor.expression.lib;

import org.objectweb.jorm.type.api.PType;
import org.objectweb.medor.expression.api.Expression;
import org.objectweb.medor.expression.api.ExpressionException;
import org.objectweb.medor.expression.api.MalformedExpressionException;
import org.objectweb.medor.expression.api.Operand;
import org.objectweb.medor.expression.api.ParameterOperand;
import org.objectweb.medor.expression.lib.BasicUnaryOperator;
import org.objectweb.medor.expression.lib.BasicVariableOperand;

public class TypeConverter
extends BasicUnaryOperator {
    private static final long serialVersionUID = -5990898823556245854L;

    public TypeConverter(PType newType) throws MalformedExpressionException {
        if (newType == null) {
            throw new MalformedExpressionException("Null PType not supported");
        }
        this.type = newType;
    }

    public TypeConverter(Expression operand, PType newType) throws MalformedExpressionException {
        this(newType);
        this.setExpression(0, operand);
    }

    public String getOperatorString() {
        return "cast(" + this.type.getJavaName() + ")";
    }

    /*
     * WARNING - void declaration
     */
    public Operand evaluate(ParameterOperand[] values, Object o) throws ExpressionException {
        if (this.expressions[0] == null) {
            throw new ExpressionException("No inner operand specified");
        }
        Operand subOperand = this.expressions[0].evaluate(values, o);
        PType subType = this.expressions[0].getType();
        switch (this.type.getTypeCode()) {
            case 0: 
            case 8: {
                void var5_13;
                switch (subType.getTypeCode()) {
                    case 0: 
                    case 8: {
                        boolean bl = subOperand.getBoolean();
                        break;
                    }
                    case 2: 
                    case 10: {
                        boolean bl = subOperand.getByte() > 0;
                        break;
                    }
                    case 3: 
                    case 11: {
                        boolean bl = subOperand.getShort() > 0;
                        break;
                    }
                    case 4: 
                    case 12: {
                        boolean bl = subOperand.getInt() > 0;
                        break;
                    }
                    case 5: 
                    case 13: {
                        boolean bl = subOperand.getLong() > 0L;
                        break;
                    }
                    case 6: 
                    case 14: {
                        boolean bl = subOperand.getFloat() > 0.0f;
                        break;
                    }
                    case 7: 
                    case 15: {
                        boolean bl = subOperand.getDouble() > 0.0;
                        break;
                    }
                    case 16: {
                        boolean bl = Boolean.valueOf(subOperand.getString());
                        break;
                    }
                    default: {
                        throw new ExpressionException("Impossible to convert " + subType.getJavaName() + " to " + this.type.getJavaName());
                    }
                }
                if (this.type.getTypeCode() == 0) {
                    this.result.setValue((boolean)var5_13);
                } else {
                    this.result.setValue(var5_13 != false ? Boolean.TRUE : Boolean.FALSE);
                }
            }
            case 1: 
            case 9: {
                void var5_23;
                switch (subType.getTypeCode()) {
                    case 1: 
                    case 9: {
                        char c = subOperand.getChar();
                        break;
                    }
                    case 2: 
                    case 10: {
                        char c = (char)subOperand.getByte();
                        break;
                    }
                    case 3: 
                    case 11: {
                        char c = (char)subOperand.getShort();
                        break;
                    }
                    case 4: 
                    case 12: {
                        char c = (char)subOperand.getInt();
                        break;
                    }
                    case 5: 
                    case 13: {
                        char c = (char)subOperand.getLong();
                        break;
                    }
                    case 6: 
                    case 14: {
                        char c = (char)subOperand.getFloat();
                        break;
                    }
                    case 7: 
                    case 15: {
                        char c = (char)subOperand.getDouble();
                        break;
                    }
                    case 16: {
                        String str = subOperand.getString();
                        if (str == null) {
                            boolean bl = false;
                            break;
                        }
                        char c = str.charAt(0);
                        break;
                    }
                    default: {
                        throw new ExpressionException("Impossible to convert " + subType.getJavaName() + " to " + this.type.getJavaName());
                    }
                }
                if (this.type.getTypeCode() == 1) {
                    this.result.setValue((char)var5_23);
                } else {
                    this.result.setValue(new Character((char)var5_23));
                }
            }
            case 2: 
            case 10: {
                void var5_32;
                switch (subType.getTypeCode()) {
                    case 0: 
                    case 8: {
                        byte by = subOperand.getBoolean() ? (byte)1 : 0;
                        break;
                    }
                    case 2: 
                    case 10: {
                        byte by = subOperand.getByte();
                        break;
                    }
                    case 3: 
                    case 11: {
                        byte by = (byte)subOperand.getShort();
                        break;
                    }
                    case 4: 
                    case 12: {
                        byte by = (byte)subOperand.getInt();
                        break;
                    }
                    case 5: 
                    case 13: {
                        byte by = (byte)subOperand.getLong();
                        break;
                    }
                    case 6: 
                    case 14: {
                        byte by = (byte)subOperand.getFloat();
                        break;
                    }
                    case 7: 
                    case 15: {
                        byte by = (byte)subOperand.getDouble();
                        break;
                    }
                    case 16: {
                        byte by = Byte.valueOf(subOperand.getString());
                        break;
                    }
                    default: {
                        throw new ExpressionException("Impossible to convert " + subType.getJavaName() + " to " + this.type.getJavaName());
                    }
                }
                if (this.type.getTypeCode() == 2) {
                    this.result.setValue((byte)var5_32);
                } else {
                    this.result.setValue(new Byte((byte)var5_32));
                }
            }
            case 3: 
            case 11: {
                void var5_41;
                switch (subType.getTypeCode()) {
                    case 0: 
                    case 8: {
                        short s = subOperand.getBoolean() ? (byte)1 : 0;
                        break;
                    }
                    case 2: 
                    case 10: {
                        short s = subOperand.getByte();
                        break;
                    }
                    case 3: 
                    case 11: {
                        short s = subOperand.getShort();
                        break;
                    }
                    case 4: 
                    case 12: {
                        short s = (short)subOperand.getInt();
                        break;
                    }
                    case 5: 
                    case 13: {
                        short s = (short)subOperand.getLong();
                        break;
                    }
                    case 6: 
                    case 14: {
                        short s = (short)subOperand.getFloat();
                        break;
                    }
                    case 7: 
                    case 15: {
                        short s = (short)subOperand.getDouble();
                        break;
                    }
                    case 16: {
                        short s = Short.valueOf(subOperand.getString());
                        break;
                    }
                    default: {
                        throw new ExpressionException("Impossible to convert " + subType.getJavaName() + " to " + this.type.getJavaName());
                    }
                }
                if (this.type.getTypeCode() == 3) {
                    this.result.setValue((short)var5_41);
                } else {
                    this.result.setValue(new Short((short)var5_41));
                }
            }
            case 4: 
            case 12: {
                void var5_50;
                switch (subType.getTypeCode()) {
                    case 0: 
                    case 8: {
                        boolean bl = subOperand.getBoolean();
                        break;
                    }
                    case 2: 
                    case 10: {
                        byte by = subOperand.getByte();
                        break;
                    }
                    case 3: 
                    case 11: {
                        short s = subOperand.getShort();
                        break;
                    }
                    case 4: 
                    case 12: {
                        int n = subOperand.getInt();
                        break;
                    }
                    case 5: 
                    case 13: {
                        int n = (int)subOperand.getLong();
                        break;
                    }
                    case 6: 
                    case 14: {
                        int n = (int)subOperand.getFloat();
                        break;
                    }
                    case 7: 
                    case 15: {
                        int n = (int)subOperand.getDouble();
                        break;
                    }
                    case 16: {
                        int n = Integer.valueOf(subOperand.getString());
                        break;
                    }
                    default: {
                        throw new ExpressionException("Impossible to convert " + subType.getJavaName() + " to " + this.type.getJavaName());
                    }
                }
                if (this.type.getTypeCode() == 4) {
                    this.result.setValue((int)var5_50);
                } else {
                    this.result.setValue(new Integer((int)var5_50));
                }
            }
            case 5: 
            case 13: {
                long l;
                switch (subType.getTypeCode()) {
                    case 0: 
                    case 8: {
                        l = subOperand.getBoolean() ? 1 : 0;
                        break;
                    }
                    case 2: 
                    case 10: {
                        l = subOperand.getByte();
                        break;
                    }
                    case 3: 
                    case 11: {
                        l = subOperand.getShort();
                        break;
                    }
                    case 4: 
                    case 12: {
                        l = subOperand.getInt();
                        break;
                    }
                    case 5: 
                    case 13: {
                        l = subOperand.getLong();
                        break;
                    }
                    case 6: 
                    case 14: {
                        l = (long)subOperand.getFloat();
                        break;
                    }
                    case 7: 
                    case 15: {
                        l = (long)subOperand.getDouble();
                        break;
                    }
                    case 16: {
                        l = Long.valueOf(subOperand.getString());
                        break;
                    }
                    default: {
                        throw new ExpressionException("Impossible to convert " + subType.getJavaName() + " to " + this.type.getJavaName());
                    }
                }
                if (this.type.getTypeCode() == 5) {
                    this.result.setValue(l);
                } else {
                    this.result.setValue(new Long(l));
                }
            }
            case 6: 
            case 14: {
                float f;
                switch (subType.getTypeCode()) {
                    case 0: 
                    case 8: {
                        f = subOperand.getBoolean() ? (byte)1 : 0;
                        break;
                    }
                    case 2: 
                    case 10: {
                        f = subOperand.getByte();
                        break;
                    }
                    case 3: 
                    case 11: {
                        f = subOperand.getShort();
                        break;
                    }
                    case 4: 
                    case 12: {
                        f = subOperand.getInt();
                        break;
                    }
                    case 5: 
                    case 13: {
                        f = subOperand.getLong();
                        break;
                    }
                    case 6: 
                    case 14: {
                        f = subOperand.getFloat();
                        break;
                    }
                    case 7: 
                    case 15: {
                        f = (float)subOperand.getDouble();
                        break;
                    }
                    case 16: {
                        f = Float.valueOf(subOperand.getString()).floatValue();
                        break;
                    }
                    default: {
                        throw new ExpressionException("Impossible to convert " + subType.getJavaName() + " to " + this.type.getJavaName());
                    }
                }
                if (this.type.getTypeCode() == 5) {
                    this.result.setValue(f);
                } else {
                    this.result.setValue(new Float(f));
                }
            }
            case 7: 
            case 15: {
                double d;
                switch (subType.getTypeCode()) {
                    case 0: 
                    case 8: {
                        d = subOperand.getBoolean() ? (byte)1 : 0;
                        break;
                    }
                    case 2: 
                    case 10: {
                        d = subOperand.getByte();
                        break;
                    }
                    case 3: 
                    case 11: {
                        d = subOperand.getShort();
                        break;
                    }
                    case 4: 
                    case 12: {
                        d = subOperand.getInt();
                        break;
                    }
                    case 5: 
                    case 13: {
                        d = subOperand.getLong();
                        break;
                    }
                    case 6: 
                    case 14: {
                        d = subOperand.getFloat();
                        break;
                    }
                    case 7: 
                    case 15: {
                        d = subOperand.getDouble();
                        break;
                    }
                    case 16: {
                        d = Double.valueOf(subOperand.getString());
                        break;
                    }
                    default: {
                        throw new ExpressionException("Impossible to convert " + subType.getJavaName() + " to " + this.type.getJavaName());
                    }
                }
                if (this.type.getTypeCode() == 5) {
                    this.result.setValue(d);
                    break;
                }
                this.result.setValue(new Float(d));
                break;
            }
            case 16: {
                void var5_62;
                switch (subType.getTypeCode()) {
                    case 0: 
                    case 8: {
                        String string = "" + subOperand.getBoolean();
                        break;
                    }
                    case 2: 
                    case 10: {
                        String string = "" + subOperand.getByte();
                        break;
                    }
                    case 3: 
                    case 11: {
                        String string = "" + subOperand.getShort();
                        break;
                    }
                    case 4: 
                    case 12: {
                        String string = "" + subOperand.getInt();
                        break;
                    }
                    case 5: 
                    case 13: {
                        String string = "" + subOperand.getLong();
                        break;
                    }
                    case 6: 
                    case 14: {
                        String string = "" + subOperand.getFloat();
                        break;
                    }
                    case 7: 
                    case 15: {
                        String string = "" + subOperand.getDouble();
                        break;
                    }
                    case 16: {
                        String string = subOperand.getString();
                        break;
                    }
                    default: {
                        throw new ExpressionException("Impossible to convert " + subType.getJavaName() + " to " + this.type.getJavaName());
                    }
                }
                this.result.setValue((String)var5_62);
                break;
            }
            default: {
                throw new ExpressionException("Impossible to convert " + subType.getJavaName() + " to " + this.type.getJavaName());
            }
        }
        return this.result;
    }

    public Operand compileExpression() throws ExpressionException, MalformedExpressionException {
        if (this.result == null) {
            this.result = new BasicVariableOperand(this.type);
        }
        this.expressions[0].compileExpression();
        return this.result;
    }
}

