/*
 * Decompiled with CFR 0.152.
 */
package org.objectweb.medor.filter.lib;

import org.objectweb.jorm.type.api.PTypeSpace;
import org.objectweb.medor.api.MedorException;
import org.objectweb.medor.expression.api.Expression;
import org.objectweb.medor.expression.api.ExpressionException;
import org.objectweb.medor.expression.api.MalformedExpressionException;
import org.objectweb.medor.expression.api.Operand;
import org.objectweb.medor.expression.api.ParameterOperand;
import org.objectweb.medor.expression.lib.BasicBinaryOperator;
import org.objectweb.medor.expression.lib.BasicVariableOperand;
import org.objectweb.medor.filter.api.BelongOperator;
import org.objectweb.medor.tuple.api.Tuple;
import org.objectweb.medor.tuple.api.TupleCollection;

public class BasicBelongOperator
extends BasicBinaryOperator
implements BelongOperator {
    public BasicBelongOperator() {
        super(PTypeSpace.BOOLEAN);
    }

    public BasicBelongOperator(Expression e0, Expression e1) {
        super(PTypeSpace.BOOLEAN, e0, e1);
    }

    public Operand evaluate(ParameterOperand[] pos, Object o) throws ExpressionException {
        try {
            this.result.setValue(this.evaluate((Tuple)this.expressions[0].evaluate(pos, o).getObject(), (TupleCollection)this.expressions[1].evaluate(pos, o).getObject()));
        }
        catch (Exception e) {
            throw new ExpressionException("Unevaluable Expression: Not compiled");
        }
        return this.result;
    }

    public boolean evaluate(Tuple tuple, TupleCollection tc) throws MedorException {
        boolean belong = false;
        if (tc.isEmpty()) {
            belong = false;
        } else {
            Tuple element;
            while (!(belong = this.equalTuple(element = tc.getTuple(), tuple)) && tc.next()) {
            }
        }
        return belong;
    }

    private boolean equalTuple(Tuple t1, Tuple t2) throws MedorException {
        boolean equalOperand = true;
        if (t1.getSize() == t2.getSize()) {
            int cpt = 1;
            while (cpt < t1.getSize() && equalOperand) {
                if (t1.getLikeOperand(cpt).getType() != t1.getLikeOperand(cpt).getType()) continue;
                switch (t1.getLikeOperand(cpt).getType().getTypeCode()) {
                    case 4: {
                        equalOperand = t1.getInt(cpt) == t2.getInt(cpt);
                        ++cpt;
                        break;
                    }
                    case 3: {
                        equalOperand = t1.getShort(cpt) == t2.getShort(cpt);
                        ++cpt;
                        break;
                    }
                    case 2: {
                        equalOperand = t1.getByte(cpt) == t2.getByte(cpt);
                        ++cpt;
                        break;
                    }
                    case 5: {
                        equalOperand = t1.getLong(cpt) == t2.getLong(cpt);
                        ++cpt;
                        break;
                    }
                    case 7: {
                        equalOperand = t1.getDouble(cpt) == t2.getDouble(cpt);
                        ++cpt;
                        break;
                    }
                    case 0: {
                        equalOperand = t1.getBoolean(cpt) == t2.getBoolean(cpt);
                        ++cpt;
                        break;
                    }
                    case 6: {
                        equalOperand = t1.getFloat(cpt) == t2.getFloat(cpt);
                        ++cpt;
                        break;
                    }
                    case 16: {
                        equalOperand = t1.getString(cpt).equalsIgnoreCase(t2.getString(cpt));
                        ++cpt;
                        break;
                    }
                    case 22: {
                        equalOperand = t1.getBigDecimal(cpt).equals(t2.getBigDecimal(cpt));
                        ++cpt;
                        break;
                    }
                    case 21: {
                        equalOperand = t1.getBigInteger(cpt).equals(t2.getBigInteger(cpt));
                        ++cpt;
                        break;
                    }
                    case 1: {
                        equalOperand = t1.getChar(cpt) == t2.getChar(cpt);
                        ++cpt;
                        break;
                    }
                    case 17: {
                        equalOperand = t1.getDate(cpt).compareTo(t2.getDate(cpt)) == 0;
                        ++cpt;
                    }
                }
            }
        }
        return equalOperand;
    }

    public Operand compileExpression() throws ExpressionException, MalformedExpressionException {
        if (!this.verified) {
            if (this.expressions[0] == null || this.expressions[1] == null) {
                throw new MalformedExpressionException("null children value");
            }
            this.expressions[0].compileExpression();
            this.expressions[1].compileExpression();
            this.verified = true;
            this.result = new BasicVariableOperand(PTypeSpace.BOOLEAN);
        }
        return this.result;
    }

    public String getOperatorString() {
        return null;
    }
}

