/*
 * Decompiled with CFR 0.152.
 */
package org.objectweb.medor.optim.jorm;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.objectweb.jorm.api.PClassMapping;
import org.objectweb.jorm.api.PException;
import org.objectweb.jorm.api.PMapper;
import org.objectweb.jorm.mapper.rdb.adapter.RdbAdapterFactory;
import org.objectweb.jorm.mapper.rdb.adapter.api.JoinedTable;
import org.objectweb.jorm.mapper.rdb.adapter.api.RdbAdapterException;
import org.objectweb.jorm.mapper.rdb.lib.RdbPPolymorphicClass;
import org.objectweb.jorm.mapper.rdb.metainfo.RdbClassMultiMapping;
import org.objectweb.jorm.mapper.rdb.metainfo.RdbExternalTable;
import org.objectweb.jorm.mapper.rdb.metainfo.RdbGenClassMapping;
import org.objectweb.jorm.mapper.rdb.metainfo.RdbJoin;
import org.objectweb.jorm.mapper.rdb.metainfo.RdbPrimitiveElementMapping;
import org.objectweb.jorm.mapper.rdb.metainfo.RdbTable;
import org.objectweb.jorm.mapper.rdb.util.ColumnAliasing;
import org.objectweb.jorm.metainfo.api.Class;
import org.objectweb.jorm.metainfo.api.GenClassRef;
import org.objectweb.jorm.metainfo.api.NameDef;
import org.objectweb.jorm.metainfo.api.PrimitiveElement;
import org.objectweb.jorm.naming.api.PName;
import org.objectweb.jorm.type.api.PType;
import org.objectweb.jorm.util.lib.StringReplace;
import org.objectweb.medor.api.Field;
import org.objectweb.medor.api.MedorException;
import org.objectweb.medor.datasource.api.DataStore;
import org.objectweb.medor.datasource.lib.ConnectionFactoryDataStore;
import org.objectweb.medor.expression.api.BinaryArithmeticOperator;
import org.objectweb.medor.expression.api.BinaryLogicalOperator;
import org.objectweb.medor.expression.api.Comparator;
import org.objectweb.medor.expression.api.Expression;
import org.objectweb.medor.expression.api.ExpressionException;
import org.objectweb.medor.expression.api.MalformedExpressionException;
import org.objectweb.medor.expression.api.Operand;
import org.objectweb.medor.expression.api.Operator;
import org.objectweb.medor.expression.api.ParameterOperand;
import org.objectweb.medor.expression.api.UnaryArithmeticOperator;
import org.objectweb.medor.expression.lib.And;
import org.objectweb.medor.expression.lib.BasicOperator;
import org.objectweb.medor.expression.lib.BasicVariableOperand;
import org.objectweb.medor.expression.lib.ConditionalAnd;
import org.objectweb.medor.expression.lib.Equal;
import org.objectweb.medor.expression.lib.Not;
import org.objectweb.medor.expression.lib.NotEqual;
import org.objectweb.medor.expression.lib.Or;
import org.objectweb.medor.filter.api.FieldOperand;
import org.objectweb.medor.filter.jorm.lib.CompositePName;
import org.objectweb.medor.filter.jorm.lib.EncodePName;
import org.objectweb.medor.filter.jorm.lib.SinglePName;
import org.objectweb.medor.filter.lib.BasicFieldOperand;
import org.objectweb.medor.filter.lib.Count;
import org.objectweb.medor.filter.lib.ExpressionPrinter;
import org.objectweb.medor.filter.lib.IsEmpty;
import org.objectweb.medor.filter.lib.IsNull;
import org.objectweb.medor.filter.lib.MemberOf;
import org.objectweb.medor.optim.jorm.JormRule;
import org.objectweb.medor.optim.lib.BasicRule;
import org.objectweb.medor.optim.lib.PushNotInExpressionRule;
import org.objectweb.medor.query.api.CalculatedField;
import org.objectweb.medor.query.api.OrderField;
import org.objectweb.medor.query.api.PropagatedField;
import org.objectweb.medor.query.api.QueryNode;
import org.objectweb.medor.query.api.QueryTree;
import org.objectweb.medor.query.api.QueryTreeField;
import org.objectweb.medor.query.jorm.api.JormExtent;
import org.objectweb.medor.query.jorm.lib.ClassExtent;
import org.objectweb.medor.query.jorm.lib.PNameField;
import org.objectweb.medor.query.lib.BasicCalculatedField;
import org.objectweb.medor.query.lib.BasicOrderField;
import org.objectweb.medor.query.lib.BasicQueryTreeField;
import org.objectweb.medor.query.lib.Nest;
import org.objectweb.medor.query.lib.QueryTreePrinter;
import org.objectweb.medor.query.lib.SelectProject;
import org.objectweb.medor.query.rdb.api.QualifiedTable;
import org.objectweb.medor.query.rdb.api.RdbExpField;
import org.objectweb.medor.query.rdb.api.RdbExpQueryLeaf;
import org.objectweb.medor.query.rdb.api.RdbField;
import org.objectweb.medor.query.rdb.lib.BasicQualifiedTable;
import org.objectweb.medor.query.rdb.lib.BasicRdbExpQueryLeaf;
import org.objectweb.util.monolog.api.BasicLevel;

public class JormFlatten2Rdb
extends JormRule {
    private List extents = new ArrayList();
    private List mappings = new ArrayList();
    private List subLeaves = new ArrayList();
    private int alias = 0;
    private List joinedTables = new ArrayList();
    private List mofs = new ArrayList();
    private List mofExtents = new ArrayList();
    private List empties = new ArrayList();

    public JormFlatten2Rdb() {
        super("JormFlatten2Rdb");
    }

    public QueryTree rewrite(QueryTree qt, QueryNode parent) throws MedorException {
        OrderField[] ofields;
        Expression filter;
        HashMap<Field, PropagatedField> localyReplaced;
        this.log.log(BasicLevel.DEBUG, (Object)"JormFlatten2Rdb: Input query tree:");
        QueryTreePrinter.printQueryTree(qt, this.log, BasicLevel.DEBUG);
        this.extents.clear();
        this.mappings.clear();
        this.alias = 0;
        this.joinedTables = new ArrayList();
        this.mofs.clear();
        this.mofExtents.clear();
        this.empties.clear();
        this.subLeaves.clear();
        HashMap<Field, PropagatedField> hashMap = localyReplaced = parent == null ? null : new HashMap<Field, PropagatedField>();
        if (qt instanceof JormExtent) {
            SelectProject p = new SelectProject("");
            Field[] fs = qt.getTupleStructure().getFields();
            for (int i = 0; i < fs.length; ++i) {
                PropagatedField newF = p.addPropagatedField(fs[i].getName(), fs[i].getType(), new QueryTreeField[]{(QueryTreeField)fs[i]});
                if (parent == null) continue;
                localyReplaced.put(fs[i], newF);
            }
            this.replaceUsage(parent, localyReplaced);
            return this.rewrite(p, parent);
        }
        QueryNode qn = (QueryNode)qt;
        QueryTree[] children = qn.getChildren();
        for (int i = 0; i < children.length; ++i) {
            RdbJormExtentMapping rjem = new RdbJormExtentMapping((JormExtent)children[i]);
            rjem.outer = qn.isOuter(children[i]);
            this.extents.add(children[i]);
            this.mappings.add(rjem);
        }
        boolean assignfilter = false;
        try {
            filter = qn.getQueryFilter();
            assignfilter = filter != null;
        }
        catch (Exception e) {
            filter = null;
        }
        if (this.debug) {
            this.logInitialStructure();
            this.log.log(BasicLevel.DEBUG, (Object)"Removing useless pname equality");
        }
        filter = this.removeUseLessPNameEquality(filter);
        if (this.debug) {
            for (int i = 0; i < this.mappings.size(); ++i) {
                this.log.log(BasicLevel.DEBUG, this.mappings.get(i));
            }
            this.log.log(BasicLevel.DEBUG, (Object)("filter: " + ExpressionPrinter.e2str(filter)));
            this.log.log(BasicLevel.DEBUG, (Object)"Updating the projected fields");
        }
        BasicRdbExpQueryLeaf leaf = this.createQueryLeaf((JormExtent)children[0]);
        boolean distinctLeafForCountAll = this.migrateFieldsFromExtentToLeaf(qn, parent, leaf, localyReplaced);
        if (this.debug) {
            this.log.log(BasicLevel.DEBUG, (Object)"Updating the order by clause");
        }
        if ((ofields = qt.getOrderBy()) != null) {
            for (int j = 0; j < ofields.length; ++j) {
                QueryTreeField f = this.getField(ofields[j].getField(), leaf, false);
                ofields[j].setField(f);
            }
        }
        if (this.debug) {
            this.log.log(BasicLevel.DEBUG, (Object)"Updating the filter");
        }
        try {
            filter = this.updateFieldOfExpression(filter, leaf, false);
        }
        catch (ExpressionException e) {
            throw new MedorException(e);
        }
        if (this.debug) {
            this.log.log(BasicLevel.DEBUG, (Object)("filter: " + ExpressionPrinter.e2str(filter)));
        }
        if (assignfilter) {
            qn.setQueryFilter(null);
        }
        leaf.setQueryFilter(filter);
        leaf.setRootJoinedTables(this.joinedTables);
        if (this.debug) {
            this.log.log(BasicLevel.DEBUG, (Object)("joinedTables: " + this.joinedTables));
            this.log.log(BasicLevel.DEBUG, (Object)"JormFlatten2Rdb: Query leaf expression:");
            this.log.log(BasicLevel.DEBUG, (Object)ExpressionPrinter.e2str(filter));
        }
        PushNotInExpressionRule rule = new PushNotInExpressionRule();
        rule.rewrite(leaf, null);
        filter = leaf.getQueryFilter();
        this.splitLeaf(leaf);
        leaf.setDistinct(distinctLeafForCountAll ? true : qt.getDistinct());
        leaf.setIsSubquery(distinctLeafForCountAll);
        if (ofields != null) {
            OrderField[] leafOFields = new BasicOrderField[ofields.length];
            for (int j = 0; j < ofields.length; ++j) {
                BasicOrderField of = new BasicOrderField(ofields[j].getField(), ofields[j].getDesc());
                leafOFields[j] = of;
            }
            leaf.setOrderBy(leafOFields);
        }
        leaf.setQueryFilter(this.updateFilterWithNewLeaves(filter, leaf));
        this.log.log(BasicLevel.DEBUG, (Object)"JormFlatten2Rdb: Output query tree:");
        QueryTreePrinter.printQueryTree(qt, this.log, BasicLevel.DEBUG);
        return qt;
    }

    public RdbJormExtentMapping getMapping(int i) {
        return (RdbJormExtentMapping)this.mappings.get(i);
    }

    public RdbJormExtentMapping getMapping(JormExtent je) {
        int i = this.extents.indexOf(je);
        return i == -1 ? null : (RdbJormExtentMapping)this.mappings.get(i);
    }

    private String getTableAlias(RdbTable table, RdbJoin join) {
        String tableName = table.getName();
        if (tableName.indexOf(".") != -1) {
            tableName = StringReplace.replaceString(".", "_", tableName);
        }
        return join == null ? tableName + "_" + this.alias++ : tableName + "_" + this.alias++ + "_" + join.getName();
    }

    private String getQueryAlias(String tableName) {
        return tableName + "_" + this.alias++;
    }

    private Expression removeUseLessPNameEquality(Expression e) throws MedorException {
        if (e == null) {
            return null;
        }
        if (e instanceof Equal) {
            Equal eq = (Equal)e;
            Expression left = eq.getExpression(0);
            Expression right = eq.getExpression(1);
            if (left instanceof FieldOperand && right instanceof FieldOperand) {
                QueryTreeField qtf2;
                FieldOperand fo1 = (FieldOperand)left;
                FieldOperand fo2 = (FieldOperand)right;
                QueryTreeField qtf1 = (QueryTreeField)fo1.getField();
                if (qtf1 instanceof PNameField & (qtf2 = (QueryTreeField)fo2.getField()) instanceof PNameField) {
                    PNameField pnf1 = (PNameField)qtf1;
                    JormExtent je1 = (JormExtent)pnf1.getQueryTree();
                    this.log.log(BasicLevel.DEBUG, (Object)("JormExtent: " + je1 + " " + je1.getName()));
                    this.log.log(BasicLevel.DEBUG, (Object)("PNameField: " + pnf1.getName()));
                    NameDef nd1 = pnf1.getNameDef(je1);
                    this.log.log(BasicLevel.DEBUG, (Object)("NameDef1: " + nd1));
                    PNameField pnf2 = (PNameField)qtf2;
                    JormExtent je2 = (JormExtent)pnf2.getQueryTree();
                    NameDef nd2 = pnf2.getNameDef(je2);
                    this.log.log(BasicLevel.DEBUG, (Object)("NameDef2: " + nd2));
                    boolean sameTable = true;
                    if (nd1.isFieldName() && nd2.isFieldName()) {
                        sameTable = this.sameColumn(je1, nd1.getFieldName(), je2, nd2.getFieldName(), true);
                    } else if (nd1.isNameRef() && nd2.isNameRef()) {
                        if (!nd1.getNameRef().getCompositeName().getFQName().equals(nd2.getNameRef().getCompositeName().getFQName())) {
                            throw new MedorException("Bad PName equality: two different composite name");
                        }
                        Map proj1 = nd1.getNameRef().getProjection();
                        Map proj2 = nd2.getNameRef().getProjection();
                        if (proj1.size() != proj2.size()) {
                            throw new MedorException("Bad PName equality: bad projection size");
                        }
                        Iterator it = proj1.entrySet().iterator();
                        while (it.hasNext() && sameTable) {
                            Map.Entry me = it.next();
                            String cofn = (String)me.getKey();
                            String clfn1 = (String)me.getValue();
                            String clfn2 = (String)proj2.get(cofn);
                            sameTable = this.sameColumn(je1, clfn1, je2, clfn2, !it.hasNext());
                        }
                    } else {
                        throw new MedorException("Bad PName equality: PName structures unknwon or not same");
                    }
                    if (sameTable) {
                        return null;
                    }
                }
            }
        } else {
            if (e instanceof BinaryLogicalOperator) {
                Operator op = (Operator)e;
                Expression e0 = this.removeUseLessPNameEquality(op.getExpression(0));
                Expression e1 = this.removeUseLessPNameEquality(op.getExpression(1));
                if (e0 == null && e1 != null) {
                    return e1;
                }
                if (e0 != null && e1 == null) {
                    return e0;
                }
                if (e0 == null && e1 == null) {
                    return null;
                }
                if (e0 != null && e0 != op.getExpression(0)) {
                    op.setExpression(0, e0);
                }
                if (e0 != null && e0 != op.getExpression(0)) {
                    op.setExpression(0, e0);
                }
                return op;
            }
            if (e instanceof Operator) {
                Operator op = (Operator)e;
                int size = op.getOperandNumber();
                for (int i = 0; i < size; ++i) {
                    if (this.removeUseLessPNameEquality(op.getExpression(i)) != null) continue;
                    throw new MedorException("Impossible to remove the operand " + i + " of operator " + e);
                }
            }
        }
        return e;
    }

    private boolean sameColumn(JormExtent je1, String fieldname1, JormExtent je2, String fieldname2, boolean replacetable) throws MedorException {
        boolean res;
        RdbPrimitiveElementMapping pem1 = (RdbPrimitiveElementMapping)this.getPEM(je1, fieldname1);
        RdbTable t1 = (RdbTable)pem1.getParent();
        RdbPrimitiveElementMapping pem2 = (RdbPrimitiveElementMapping)this.getPEM(je2, fieldname2);
        RdbTable t2 = (RdbTable)pem2.getParent();
        boolean bl = res = t1.getName().equals(t2.getName()) && t1.isColocated() && t2.isColocated() && pem1.getName().equals(pem2.getName());
        if (this.debug) {
            this.log.log(BasicLevel.DEBUG, (Object)("Comparing field " + fieldname1 + " to " + fieldname2 + ": result " + res));
        }
        if (res && replacetable) {
            RdbJormExtentMapping rjem1 = this.getMapping(je1);
            int idx1 = this.getTableIndex(rjem1, pem1, this.unQualifiedName(fieldname1, je1));
            RdbJormExtentMapping rjem2 = this.getMapping(je2);
            int idx2 = this.getTableIndex(rjem2, pem2, this.unQualifiedName(fieldname2, je2));
            if (t1 instanceof RdbExternalTable) {
                this.replaceTable(rjem2, idx2, rjem1, idx1);
            } else {
                this.replaceTable(rjem1, idx1, rjem2, idx2);
            }
        }
        return res;
    }

    private void replaceTable(RdbJormExtentMapping rjem1, int idx1, RdbJormExtentMapping rjem2, int idx2) {
        if (this.debug) {
            this.log.log(BasicLevel.DEBUG, (Object)("Replacing table " + idx1 + " of extent " + this.mappings.indexOf(rjem1) + " by table " + idx2 + " of extent " + this.mappings.indexOf(rjem2)));
        }
        QualifiedTable old = (QualifiedTable)rjem1.tables.get(idx1);
        QualifiedTable neo = (QualifiedTable)rjem2.tables.get(idx2);
        for (int i = 0; i < this.mappings.size(); ++i) {
            RdbJormExtentMapping r = (RdbJormExtentMapping)this.mappings.get(i);
            for (int j = 0; j < r.tables.size(); ++j) {
                if (r.tables.get(j) != old) continue;
                r.tables.set(j, neo);
            }
        }
    }

    private int getTableIndex(RdbJormExtentMapping rjem, RdbPrimitiveElementMapping pem, String fieldname) throws MedorException {
        if (rjem.tables.size() == 1 && rjem.joins.get(0) == null) {
            return 0;
        }
        Iterator it = pem.getPrimitiveElementByRdbJoin().entrySet().iterator();
        if (!it.hasNext()) {
            return 0;
        }
        RdbJoin j = null;
        while (it.hasNext()) {
            Map.Entry me = it.next();
            if (!((PrimitiveElement)me.getValue()).getName().equals(fieldname)) continue;
            j = (RdbJoin)me.getKey();
            break;
        }
        if (j == null) {
            throw new MedorException("No join found for the mapping of the column '" + pem.getName() + "'");
        }
        return rjem.getJoinIndex(j.getName());
    }

    public Expression updateFieldOfExpression(Expression e, BasicRdbExpQueryLeaf leaf, boolean add) throws MedorException, ExpressionException {
        this.log.log(BasicLevel.DEBUG, (Object)("Entering updateFieldOfExpression for " + ExpressionPrinter.e2str(e)));
        if (e == null) {
            return null;
        }
        if (e instanceof Equal || e instanceof NotEqual || e instanceof MemberOf) {
            FieldOperand fo;
            QueryTreeField qtf;
            Operator eq = (Operator)e;
            Expression left = eq.getExpression(0);
            Expression right = eq.getExpression(1);
            if (left instanceof FieldOperand && right instanceof FieldOperand) {
                FieldOperand fo1 = (FieldOperand)left;
                FieldOperand fo2 = (FieldOperand)right;
                QueryTreeField qtf1 = (QueryTreeField)fo1.getField();
                QueryTreeField qtf2 = (QueryTreeField)fo2.getField();
                if (qtf1 instanceof PNameField && qtf2 instanceof PNameField) {
                    PNameField pnf1 = (PNameField)qtf1;
                    JormExtent je1 = (JormExtent)pnf1.getQueryTree();
                    NameDef nd1 = pnf1.getNameDef(je1);
                    PNameField pnf2 = (PNameField)qtf2;
                    JormExtent je2 = (JormExtent)pnf2.getQueryTree();
                    NameDef nd2 = pnf2.getNameDef(je2);
                    if (nd1.isFieldName() && nd2.isFieldName()) {
                        if (this.debug) {
                            this.log.log(BasicLevel.DEBUG, (Object)("Replace the PName comparison: " + ExpressionPrinter.e2str(e)));
                        }
                        fo1.setField(this.getField(nd1.getFieldName(), je1, leaf, add));
                        fo2.setField(this.getField(nd2.getFieldName(), je2, leaf, add));
                        if (this.debug) {
                            this.log.log(BasicLevel.DEBUG, (Object)("by the field comparison: " + ExpressionPrinter.e2str(e)));
                        }
                        if (e instanceof MemberOf) {
                            this.mofs.add(e);
                            this.extents.add(je2);
                        }
                        return e;
                    }
                    if (nd1.isNameRef() && nd2.isNameRef()) {
                        if (!nd1.getNameRef().getCompositeName().getFQName().equals(nd2.getNameRef().getCompositeName().getFQName())) {
                            throw new MalformedExpressionException("Bad PName equality: two different composite name");
                        }
                        Map proj1 = nd1.getNameRef().getProjection();
                        Map proj2 = nd2.getNameRef().getProjection();
                        if (proj1.size() != proj2.size()) {
                            throw new MalformedExpressionException("Bad PName equality: bad projection size");
                        }
                        if (this.debug) {
                            this.log.log(BasicLevel.DEBUG, (Object)("Replace the PName comparison: " + ExpressionPrinter.e2str(e)));
                        }
                        BasicOperator res = null;
                        Iterator it = proj1.entrySet().iterator();
                        ArrayList<BasicFieldOperand> al1 = null;
                        ArrayList<BasicFieldOperand> al2 = null;
                        if (e instanceof MemberOf) {
                            al1 = new ArrayList<BasicFieldOperand>(1);
                            al2 = new ArrayList<BasicFieldOperand>(1);
                        }
                        while (it.hasNext()) {
                            Map.Entry me = it.next();
                            String cofn = (String)me.getKey();
                            String clfn1 = (String)me.getValue();
                            String clfn2 = (String)proj2.get(cofn);
                            QueryTreeField f1 = this.getField(clfn1, je1, leaf, add);
                            QueryTreeField f2 = this.getField(clfn2, je2, leaf, add);
                            if (e instanceof Equal) {
                                Equal equal = new Equal(new BasicFieldOperand(f1), new BasicFieldOperand(f2));
                                if (this.debug) {
                                    this.log.log(BasicLevel.DEBUG, (Object)("equality: " + ExpressionPrinter.e2str(equal)));
                                }
                                if (res == null) {
                                    res = equal;
                                    continue;
                                }
                                res = new And(res, equal);
                                continue;
                            }
                            if (e instanceof NotEqual) {
                                NotEqual notequal = new NotEqual(new BasicFieldOperand(f1), new BasicFieldOperand(f2));
                                if (this.debug) {
                                    this.log.log(BasicLevel.DEBUG, (Object)("not-equality: " + ExpressionPrinter.e2str(notequal)));
                                }
                                if (res == null) {
                                    res = notequal;
                                    continue;
                                }
                                res = new And(res, notequal);
                                continue;
                            }
                            if (!(e instanceof MemberOf)) continue;
                            al1.add(new BasicFieldOperand(f1));
                            al2.add(new BasicFieldOperand(f2));
                        }
                        if (e instanceof MemberOf) {
                            MemberOf memberof = new MemberOf(al1, al2);
                            if (this.debug) {
                                this.log.log(BasicLevel.DEBUG, (Object)("memberof: " + ExpressionPrinter.e2str(memberof)));
                            }
                            res = res == null ? memberof : new And(res, memberof);
                            if (e instanceof MemberOf) {
                                this.mofs.add(memberof);
                                this.mofExtents.add(je2);
                            }
                        }
                        if (this.debug) {
                            this.log.log(BasicLevel.DEBUG, (Object)("by the fields comparison: " + ExpressionPrinter.e2str(res)));
                        }
                        return res;
                    }
                    throw new MalformedExpressionException("Bad PName equality: PName structures unknwon or not same");
                }
                if (e instanceof MemberOf) {
                    if (this.debug) {
                        this.log.log(BasicLevel.DEBUG, (Object)"MemberOf on normal fields");
                    }
                    JormExtent je1 = (JormExtent)qtf1.getQueryTree();
                    JormExtent je2 = (JormExtent)qtf2.getQueryTree();
                    if (this.debug) {
                        this.log.log(BasicLevel.DEBUG, (Object)("Replace the MemberOf: " + ExpressionPrinter.e2str(e)));
                    }
                    ArrayList<BasicFieldOperand> al1 = new ArrayList<BasicFieldOperand>(1);
                    ArrayList<BasicFieldOperand> al2 = new ArrayList<BasicFieldOperand>(1);
                    QueryTreeField f1 = this.getField(qtf1.getName().substring(je1.getName().length() + 1), je1, leaf, add);
                    QueryTreeField f2 = this.getField(qtf2.getName().substring(je2.getName().length() + 1), je2, leaf, add);
                    al1.add(new BasicFieldOperand(f1));
                    al2.add(new BasicFieldOperand(f2));
                    MemberOf memberof = new MemberOf(al1, al2);
                    if (this.debug) {
                        this.log.log(BasicLevel.DEBUG, (Object)("by the field comparison: " + ExpressionPrinter.e2str(memberof)));
                    }
                    this.mofs.add(memberof);
                    this.extents.add(je2);
                    return memberof;
                }
            } else if (left instanceof FieldOperand && right instanceof Operand ? (qtf = (QueryTreeField)(fo = (FieldOperand)left).getField()) instanceof PNameField : left instanceof Operand && right instanceof FieldOperand && (qtf = (QueryTreeField)(fo = (FieldOperand)right).getField()) instanceof PNameField) {
                return this.replacePNameOperandEquality(eq, leaf, add);
            }
        }
        if (e instanceof IsEmpty) {
            PNameField pnf;
            NameDef ndef;
            IsEmpty ie = (IsEmpty)e;
            FieldOperand fo = (FieldOperand)ie.getExpression(0);
            QueryTreeField qtf = (QueryTreeField)fo.getField();
            JormExtent je = (JormExtent)qtf.getQueryTree();
            String fname = qtf instanceof PNameField ? ((ndef = (pnf = (PNameField)qtf).getNameDef(je)).isFieldName() ? ndef.getFieldName() : (String)ndef.getNameRef().getProjection().values().iterator().next()) : qtf.getName().substring(je.getName().length() + 1);
            fo.setField(this.getField(fname, je, leaf, add));
            this.empties.add(ie);
        } else if (e instanceof Operator) {
            Operator op = (Operator)e;
            if (this.debug) {
                this.log.log(BasicLevel.DEBUG, (Object)("update the operator: " + op.getOperatorString()));
            }
            int size = op.getOperandNumber();
            for (int i = 0; i < size; ++i) {
                op.setExpression(i, this.updateFieldOfExpression(op.getExpression(i), leaf, add));
            }
        } else if (e instanceof FieldOperand) {
            Field f = ((FieldOperand)e).getField();
            if (f instanceof PNameField) {
                Expression res = this.getDecode((PNameField)f, leaf, add);
                if (this.debug) {
                    this.log.log(BasicLevel.DEBUG, (Object)("Replace the FieldOperand " + f.getName() + " by a decode: " + ExpressionPrinter.e2str(res)));
                }
                return res;
            }
            if (this.debug) {
                this.log.log(BasicLevel.DEBUG, (Object)("Update the FieldOperand " + f.getName()));
            }
            ((FieldOperand)e).setField(this.getField(f, leaf, add));
            return e;
        }
        return e;
    }

    public Expression getDecode(PNameField pnf, BasicRdbExpQueryLeaf leaf, boolean add) throws MedorException {
        if (this.debug) {
            this.log.log(BasicLevel.DEBUG, (Object)("(getDecode) Handling PNameField " + pnf.getName()));
        }
        JormExtent extent = (JormExtent)pnf.getQueryTree();
        if (this.debug) {
            this.log.log(BasicLevel.DEBUG, (Object)("in extent " + extent.getJormName()));
        }
        Operand o = this.getPNCOperand(extent, pnf);
        PType type = pnf.getType();
        this.log.log(BasicLevel.DEBUG, (Object)("Looking for NameDef of  " + pnf));
        NameDef nd = pnf.getNameDef(extent);
        if (nd.isFieldName()) {
            return new SinglePName(new BasicFieldOperand(this.getField(nd.getFieldName(), extent, leaf, add)), o, type);
        }
        if (nd.isNameRef()) {
            Map proj = nd.getNameRef().getProjection();
            FieldOperand[] fos = new BasicFieldOperand[proj.size()];
            String[] cofns = new String[proj.size()];
            int counter = 0;
            QueryTreeField qtf = null;
            Iterator it = proj.entrySet().iterator();
            while (it.hasNext()) {
                Map.Entry me = it.next();
                cofns[counter] = (String)me.getKey();
                String clafn = (String)me.getValue();
                qtf = this.getField(clafn, extent, leaf, add);
                fos[counter] = new BasicFieldOperand(qtf);
                ++counter;
            }
            return new CompositePName(fos, cofns, o, type);
        }
        throw new MedorException("Unsupport namedef: " + nd);
    }

    private Expression replacePNameOperandEquality(Operator e, BasicRdbExpQueryLeaf leaf, boolean add) throws ExpressionException, MedorException {
        NameDef nd;
        if (this.debug) {
            this.log.log(BasicLevel.DEBUG, (Object)"Equality between PName and a parameter");
        }
        Expression left = e.getExpression(0);
        Expression right = e.getExpression(1);
        FieldOperand fo = null;
        BasicQueryTreeField pnf = null;
        Operand o = null;
        boolean isLeft = true;
        if (left instanceof FieldOperand && right instanceof Operand) {
            fo = (FieldOperand)left;
            pnf = (PNameField)fo.getField();
            o = (Operand)right;
            isLeft = false;
        } else if (left instanceof Operand && right instanceof FieldOperand) {
            fo = (FieldOperand)right;
            pnf = (PNameField)fo.getField();
            o = (Operand)left;
        }
        JormExtent je = (JormExtent)pnf.getQueryTree();
        if (e instanceof MemberOf) {
            this.mofs.add(e);
            this.extents.add(je);
        }
        if ((nd = ((PNameField)pnf).getNameDef(je)).isFieldName()) {
            QueryTreeField f = this.getField(nd.getFieldName(), je, leaf, add);
            fo.setField(f);
            if (o instanceof ParameterOperand) {
                EncodePName newo = new EncodePName(f.getType(), ((ParameterOperand)o).getName());
                e.setExpression(isLeft ? 0 : 1, newo);
            } else {
                BasicVariableOperand newo = new BasicVariableOperand(f.getType());
                try {
                    EncodePName.assignEncodedValue((PName)o.getObject(), newo, null);
                }
                catch (PException ex) {
                    throw new MedorException("Impossible to encode PName", ex);
                }
                if (newo.getObject() == null) {
                    return new IsNull(fo, e instanceof NotEqual);
                }
                e.setExpression(isLeft ? 0 : 1, newo);
            }
            if (this.debug) {
                this.log.log(BasicLevel.DEBUG, (Object)("Equality between PName and a parameter: " + ExpressionPrinter.e2str(e)));
            }
            return e;
        }
        if (nd.isNameRef()) {
            BasicOperator res = null;
            Map proj1 = nd.getNameRef().getProjection();
            Iterator it = proj1.entrySet().iterator();
            while (it.hasNext()) {
                NotEqual notequal;
                BasicVariableOperand newo;
                Map.Entry me = it.next();
                String cofn = (String)me.getKey();
                String clfn = (String)me.getValue();
                QueryTreeField f = this.getField(clfn, je, leaf, add);
                if (o instanceof ParameterOperand) {
                    newo = new EncodePName(f.getType(), ((ParameterOperand)o).getName(), cofn);
                } else {
                    newo = new BasicVariableOperand(f.getType());
                    try {
                        EncodePName.assignEncodedValue((PName)o.getObject(), newo, cofn);
                    }
                    catch (PException ex) {
                        throw new MedorException("Impossible to encode PName", ex);
                    }
                }
                if (e instanceof Equal) {
                    BasicOperator test = !(o instanceof ParameterOperand) && newo.getObject() == null ? new IsNull((Expression)new BasicFieldOperand(f)) : (isLeft ? new Equal(newo, new BasicFieldOperand(f)) : new Equal(new BasicFieldOperand(f), newo));
                    res = res == null ? test : new And(res, test);
                }
                if (e instanceof MemberOf) {
                    ArrayList<BasicVariableOperand> al1 = new ArrayList<BasicVariableOperand>(1);
                    al1.add(newo);
                    ArrayList<BasicFieldOperand> al2 = new ArrayList<BasicFieldOperand>(1);
                    al2.add(new BasicFieldOperand(f));
                    MemberOf memberof = new MemberOf(al1, al2);
                    if (res == null) {
                        res = memberof;
                        continue;
                    }
                    res = new And(res, memberof);
                    continue;
                }
                if (!(e instanceof NotEqual)) continue;
                NotEqual notEqual = notequal = isLeft ? new NotEqual(newo, new BasicFieldOperand(f)) : new NotEqual(new BasicFieldOperand(f), newo);
                if (res == null) {
                    res = notequal;
                    continue;
                }
                res = new Or(res, notequal);
            }
            if (this.debug) {
                this.log.log(BasicLevel.DEBUG, (Object)("Equality between PName and a parameter: " + ExpressionPrinter.e2str(res)));
            }
            return res;
        }
        throw new MalformedExpressionException("Bad PName equality: PName structures unknwon or not same");
    }

    public QueryTreeField getField(Field old, BasicRdbExpQueryLeaf leaf, boolean add) throws MedorException {
        QueryTree qt;
        Field f = old;
        if (f instanceof PropagatedField) {
            f = ((PropagatedField)f).getPreviousFields()[0];
        }
        if ((qt = ((QueryTreeField)f).getQueryTree()) == leaf) {
            return (QueryTreeField)f;
        }
        if (qt instanceof JormExtent) {
            return this.getField(f.getName(), f.getType(), (JormExtent)qt, leaf, add);
        }
        throw new MedorException("Impossible to fetch the new field corresponding to the old field: " + f.getName() + " : the query tree is not a JormExtent: " + qt);
    }

    public QueryTreeField getField(String fieldname, JormExtent extent, BasicRdbExpQueryLeaf leaf, boolean add) throws MedorException {
        if (this.debug) {
            this.log.log(BasicLevel.DEBUG, (Object)("(getField-4) Handling field " + fieldname));
        }
        return this.getField(fieldname, this.getPrimitiveElement(extent, fieldname).getType(), extent, leaf, add);
    }

    public QueryTreeField getField(String fieldname, PType type, JormExtent extent, BasicRdbExpQueryLeaf leaf, boolean add) throws MedorException {
        String fqfn = this.qualifiedName(fieldname, extent);
        if (this.debug) {
            this.log.log(BasicLevel.DEBUG, (Object)("(getField-5) Handling field " + fieldname + " (full name: " + fqfn + ")"));
            Field[] leafFields = leaf.getTupleStructure().getFields();
            if (leafFields.length == 0) {
                this.log.log(BasicLevel.DEBUG, (Object)"Leaf has no fields");
            }
            for (int jj = 0; jj < leafFields.length; ++jj) {
                this.log.log(BasicLevel.DEBUG, (Object)("Leaf has field " + leafFields[jj].getName()));
            }
        }
        if (leaf.contains(fqfn)) {
            if (this.debug) {
                this.log.log(BasicLevel.DEBUG, (Object)("getField: / field: " + fqfn + " / type: " + type.getJormName() + " already exists"));
            }
            return (QueryTreeField)leaf.getField(fqfn);
        }
        RdbPrimitiveElementMapping pem = (RdbPrimitiveElementMapping)this.getPEM(extent, fieldname);
        RdbJormExtentMapping rjem = this.getMapping(extent);
        int idx = this.getTableIndex(rjem, pem, this.unQualifiedName(fieldname, extent));
        if (this.debug) {
            this.log.log(BasicLevel.DEBUG, (Object)("getField: / field: " + fqfn + " / type: " + type.getJormName() + " / pem: " + pem.getName() + " / rjem: " + rjem.extent.getJormName() + " / table: " + ((QualifiedTable)rjem.tables.get(idx)).getAliasName()));
        }
        this.getTable(rjem, idx, leaf, false);
        String colName = pem.getName();
        if (((QualifiedTable)rjem.tables.get(idx)).isPolymorphic()) {
            colName = this.getJORMFieldName(fieldname, extent);
            if (((QualifiedTable)rjem.tables.get(idx)).withSubclasses()) {
                colName = ColumnAliasing.getAliasFromColumn(colName);
            }
        }
        RdbExpField res = leaf.addRdbField(fqfn, type, colName, (QualifiedTable)rjem.tables.get(idx));
        if (!add) {
            leaf.removeRdbField(res);
        }
        return res;
    }

    private void getTable(RdbJormExtentMapping rjem, int idx, BasicRdbExpQueryLeaf leaf, boolean add) throws MedorException {
        QualifiedTable qt = (QualifiedTable)rjem.tables.get(idx);
        if (this.debug) {
            this.log.log(BasicLevel.DEBUG, (Object)("Looking for the table " + qt.getAliasName()));
        }
        if (leaf.containsQualifiedTable(qt)) {
            return;
        }
        if (idx != 0) {
            this.getTable(rjem, 0, leaf, add);
            if (this.debug) {
                this.log.log(BasicLevel.DEBUG, (Object)("Add the external table " + qt.getAliasName()));
            }
            leaf.addQualifiedTable(qt);
            this.addJoin(rjem, idx, leaf, add);
        } else {
            if (this.debug) {
                this.log.log(BasicLevel.DEBUG, (Object)("Add the main table " + qt.getAliasName()));
            }
            leaf.addQualifiedTable(qt);
            boolean unused = true;
            for (int i = 0; i < this.mappings.size(); ++i) {
                int jdx;
                RdbJormExtentMapping m = (RdbJormExtentMapping)this.mappings.get(i);
                int size = m.tables.size();
                for (jdx = 1; jdx < size && m.tables.get(jdx) != qt; ++jdx) {
                }
                if (jdx >= size) continue;
                unused = false;
                this.getTable(m, 0, leaf, add);
                this.addJoin(m, jdx, leaf, add);
            }
            if (unused && !this.joinedTables.contains(qt)) {
                this.joinedTables.add(qt);
            }
        }
    }

    private void addJoin(RdbJormExtentMapping rjem, int idx, BasicRdbExpQueryLeaf leaf, boolean add) throws MedorException {
        BasicQualifiedTable qt = (BasicQualifiedTable)rjem.tables.get(idx);
        JoinedTable.Join jtj = ((JoinedTable)rjem.tables.get(0)).createChildren(qt, rjem.outer);
        Join j = (Join)rjem.joins.get(idx);
        for (int i = 0; i < j.columns.length; ++i) {
            JoinColumn jc = j.columns[i];
            RdbExpField f2 = jc.field2 == null ? leaf.addRdbField(jc.column2, jc.type, jc.column2, qt) : (RdbExpField)this.getField(jc.field2, rjem.extent, leaf, add);
            RdbField f1 = (RdbField)this.getField(jc.field1, rjem.extent, leaf, add);
            jtj.addJoinColumn(f1.getColumnName(), f2.getColumnName());
            if (add) continue;
            leaf.removeRdbField(f2);
        }
    }

    private String qualifiedName(String fieldname, JormExtent extent) {
        if (fieldname.indexOf(extent.getName() + ".") == -1) {
            return extent.getName() + "." + fieldname;
        }
        return fieldname;
    }

    private String unQualifiedName(String fieldname, JormExtent extent) {
        int idx = fieldname.indexOf(extent.getName() + ".");
        if (idx == -1) {
            if (this.debug) {
                this.log.log(BasicLevel.DEBUG, (Object)("Field name " + fieldname + " is already unqualified."));
            }
            return fieldname;
        }
        if (idx == 0) {
            if (this.debug) {
                this.log.log(BasicLevel.DEBUG, (Object)("Unqualified name of field named " + fieldname + " is " + extent.getName().length() + 1));
            }
            return fieldname.substring(extent.getName().length() + 1);
        }
        if (this.debug) {
            this.log.log(BasicLevel.WARN, (Object)("Problem to unqualify field named " + fieldname));
        }
        return null;
    }

    private void splitLeaf(RdbExpQueryLeaf leaf) throws MedorException {
        int i;
        HashMap qtgroup2tables = new HashMap();
        for (i = 0; i < this.mofs.size(); ++i) {
            MemberOf mo = (MemberOf)this.mofs.get(i);
            int moSize = mo.getOperandNumber() / 2;
            Object qtGroup = null;
            RdbExpQueryLeaf newLeaf = null;
            HashSet<QualifiedTable> qts = new HashSet<QualifiedTable>();
            for (int f = 0; f < moSize; ++f) {
                RdbExpField rdbField = (RdbExpField)((FieldOperand)mo.getExpression(f + moSize)).getField();
                QualifiedTable qt = rdbField.getTable();
                qts.add(qt);
                if (qtGroup == null) {
                    qtGroup = qt.getAnnotations().get(JormExtent.ANNOTATION_QUERYTREE_GROUP);
                    qtgroup2tables.put(qtGroup, qts);
                    this.findTableWithSameGroup(leaf, qtGroup, qts);
                    newLeaf = this.createSubLeaf(leaf, qtGroup);
                }
                this.migrateField(rdbField, leaf, newLeaf);
            }
            this.migrateTables(leaf, newLeaf, qtGroup, qts);
        }
        for (i = 0; i < this.empties.size(); ++i) {
            RdbExpField rdbField = (RdbExpField)((FieldOperand)((IsEmpty)this.empties.get(i)).getExpression(0)).getField();
            HashSet<QualifiedTable> qts = new HashSet<QualifiedTable>();
            QualifiedTable qt = rdbField.getTable();
            qts.add(qt);
            Object qtGroup = qt.getAnnotations().get(JormExtent.ANNOTATION_QUERYTREE_GROUP);
            qtgroup2tables.put(qtGroup, qts);
            this.findTableWithSameGroup(leaf, qtGroup, qts);
            RdbExpQueryLeaf newLeaf = this.createSubLeaf(leaf, qtGroup);
            this.migrateTables(leaf, newLeaf, qtGroup, qts);
            this.migrateField(rdbField, leaf, newLeaf);
        }
    }

    private void findTableWithSameGroup(RdbExpQueryLeaf leaf, Object group, Set result) {
        if (group == null) {
            return;
        }
        QualifiedTable[] qts = leaf.getQualifiedTables();
        for (int i = 0; i < qts.length; ++i) {
            Object currentGroup = qts[i].getAnnotations().get(JormExtent.ANNOTATION_QUERYTREE_GROUP);
            if (!group.equals(currentGroup)) continue;
            result.add(qts[i]);
        }
    }

    private RdbExpQueryLeaf createSubLeaf(RdbExpQueryLeaf oldLeaf, Object qtGroup) {
        BasicRdbExpQueryLeaf newLeaf = new BasicRdbExpQueryLeaf(oldLeaf.getDataStore(), "");
        newLeaf.getAnnotations().put(JormExtent.ANNOTATION_QUERYTREE_GROUP, qtGroup);
        this.subLeaves.add(newLeaf);
        return newLeaf;
    }

    private void migrateTables(RdbExpQueryLeaf oldLeaf, RdbExpQueryLeaf newLeaf, Object qtGroup, Set qualifiedTables) throws MedorException {
        Iterator it = qualifiedTables.iterator();
        while (it.hasNext()) {
            QualifiedTable qt = (QualifiedTable)it.next();
            oldLeaf.removeQualifiedTable(qt);
            newLeaf.addQualifiedTable(qt);
        }
        this.joinedTables.removeAll(qualifiedTables);
        Field[] leafFields = oldLeaf.getTupleStructure().getFields();
        for (int i = 0; i < leafFields.length; ++i) {
            RdbExpField rdbField = (RdbExpField)leafFields[i];
            if (!qualifiedTables.contains(rdbField.getTable())) continue;
            this.migrateField(rdbField, oldLeaf, newLeaf);
        }
    }

    private void migrateField(RdbExpField rdbField, RdbExpQueryLeaf oldLeaf, RdbExpQueryLeaf newLeaf) throws MedorException {
        newLeaf.addRdbField(rdbField);
        rdbField.setQueryLeaf(newLeaf);
    }

    private List tablesToMove(RdbExpQueryLeaf leaf, Object group) {
        if (group == null) {
            return Collections.EMPTY_LIST;
        }
        QualifiedTable[] qts = leaf.getQualifiedTables();
        ArrayList<QualifiedTable> result = new ArrayList<QualifiedTable>(qts.length);
        for (int i = 0; i < qts.length; ++i) {
            if (!group.equals(qts[i].getAnnotations().get(JormExtent.ANNOTATION_QUERYTREE_GROUP))) continue;
            result.add(qts[i]);
        }
        return result;
    }

    private Expression updateFilterWithNewLeaves(Expression filter, RdbExpQueryLeaf leaf) {
        if (this.debug) {
            this.log.log(BasicLevel.DEBUG, (Object)("Moving part of the filter " + ExpressionPrinter.e2str(filter)));
        }
        ToBeMovedToLeaf tbm = this.tagFilterForMove(filter, leaf);
        if (this.debug) {
            this.log.log(BasicLevel.DEBUG, (Object)("Final filter for leaf: " + ExpressionPrinter.e2str(tbm.e)));
        }
        if (tbm.hasToBeMoved()) {
            tbm.leaf.setQueryFilter(tbm.e);
            return null;
        }
        return tbm.e;
    }

    private ToBeMovedToLeaf tagFilterForMove(Expression filter, RdbExpQueryLeaf leaf) {
        if (filter instanceof Not) {
            ToBeMovedToLeaf me = this.tagFilterForMove(((Not)filter).getExpression(0), leaf);
            if (me.isModified) {
                BasicOperator newFilter = new Not(me.e);
                if (leaf.getQueryFilter() != null) {
                    newFilter = new And(leaf.getQueryFilter(), newFilter);
                }
                me.leaf.setQueryFilter(newFilter);
                me.isModified = false;
                me.e = null;
                return me;
            }
        } else {
            if (filter instanceof And || filter instanceof ConditionalAnd) {
                if (this.debug) {
                    this.log.log(BasicLevel.DEBUG, (Object)("Found AND " + ExpressionPrinter.e2str(filter)));
                }
                Expression e = ((Operator)filter).getExpression(0);
                ToBeMovedToLeaf mleft = this.tagFilterForMove(e, leaf);
                boolean leftMoved = false;
                if (mleft.hasToBeMoved()) {
                    if (this.debug) {
                        this.log.log(BasicLevel.DEBUG, (Object)("Moving left side to leaf " + ExpressionPrinter.e2str(mleft.e)));
                    }
                    leftMoved = true;
                    e = mleft.e;
                    if (mleft.leaf.getQueryFilter() != null) {
                        e = new And(mleft.leaf.getQueryFilter(), e);
                    }
                    mleft.leaf.setQueryFilter(e);
                    if (this.debug) {
                        this.log.log(BasicLevel.DEBUG, (Object)("Filter for leaf " + mleft.leaf + " after moving left side is " + ExpressionPrinter.e2str(e)));
                    }
                }
                e = ((Operator)filter).getExpression(1);
                ToBeMovedToLeaf mright = this.tagFilterForMove(e, leaf);
                boolean rightMoved = false;
                if (mright.hasToBeMoved()) {
                    if (this.debug) {
                        this.log.log(BasicLevel.DEBUG, (Object)("Moving right side to leaf " + ExpressionPrinter.e2str(mright.e)));
                    }
                    rightMoved = true;
                    e = mright.e;
                    if (mright.leaf.getQueryFilter() != null) {
                        e = new And(mright.leaf.getQueryFilter(), e);
                    }
                    mright.leaf.setQueryFilter(e);
                    if (this.debug) {
                        this.log.log(BasicLevel.DEBUG, (Object)("Filter for leaf " + mright.leaf + " after moving right side is " + ExpressionPrinter.e2str(mright.leaf.getQueryFilter())));
                    }
                }
                if (leftMoved) {
                    if (rightMoved) {
                        mleft.clear();
                        if (this.debug) {
                            this.log.log(BasicLevel.DEBUG, (Object)("All moved: returning empty " + ExpressionPrinter.e2str(mleft.e)));
                        }
                        return mleft;
                    }
                    if (this.debug) {
                        this.log.log(BasicLevel.DEBUG, (Object)("Left moved: returning right " + ExpressionPrinter.e2str(mright.e)));
                    }
                    mright.isModified = true;
                    return mright;
                }
                if (rightMoved) {
                    if (this.debug) {
                        this.log.log(BasicLevel.DEBUG, (Object)("Right moved: returning left " + ExpressionPrinter.e2str(mleft.e)));
                    }
                    mleft.isModified = true;
                    return mleft;
                }
                Expression modifAnd = null;
                if (mleft.e == null) {
                    if (mright.e != null) {
                        modifAnd = mright.e;
                    }
                } else {
                    modifAnd = mright.e == null ? mleft.e : new And(mleft.e, mright.e);
                }
                if (this.debug) {
                    this.log.log(BasicLevel.DEBUG, (Object)("None moved: returning modified expression " + ExpressionPrinter.e2str(modifAnd)));
                }
                return new ToBeMovedToLeaf(modifAnd, false, null);
            }
            if (filter instanceof Comparator || filter instanceof BinaryArithmeticOperator || filter instanceof UnaryArithmeticOperator) {
                Operator op = (Operator)filter;
                for (int i = op.getOperandNumber() - 1; i >= 0; --i) {
                    RdbExpQueryLeaf subleaf;
                    Expression e = ((Operator)filter).getExpression(i);
                    if (!(e instanceof FieldOperand) || (subleaf = this.subleafOfFieldOperand((FieldOperand)e)) == null) continue;
                    return new ToBeMovedToLeaf(filter, true, subleaf);
                }
            }
        }
        return new ToBeMovedToLeaf(filter, false, null);
    }

    private RdbExpQueryLeaf subleafOfFieldOperand(FieldOperand fo) {
        return this.subleafOfFieldOperand(fo.getField());
    }

    private RdbExpQueryLeaf subleafOfFieldOperand(Field f) {
        QualifiedTable qtab = ((RdbExpField)f).getTable();
        for (int i = 0; i < this.subLeaves.size(); ++i) {
            RdbExpQueryLeaf subleaf = (RdbExpQueryLeaf)this.subLeaves.get(i);
            QualifiedTable[] tables = subleaf.getQualifiedTables();
            if (tables == null) {
                return null;
            }
            for (int j = 0; j < tables.length; ++j) {
                if (qtab != tables[j]) continue;
                if (this.debug) {
                    this.log.log(BasicLevel.DEBUG, (Object)("Found table " + qtab.getTableName() + " in leaf " + subleaf));
                }
                return subleaf;
            }
        }
        return null;
    }

    private Count fieldUsedInCount(QueryTreeField f, QueryNode parent) {
        this.log.log(BasicLevel.DEBUG, (Object)("Entering fieldUsedInCount for " + f + "( " + f.getName() + ")"));
        if (parent instanceof Nest) {
            this.log.log(BasicLevel.DEBUG, (Object)"Parent node is a Nest");
            Field[] pfs = parent.getTupleStructure().getFields();
            for (int i = 0; i < pfs.length; ++i) {
                Expression fiExp;
                Field fi = pfs[i];
                this.log.log(BasicLevel.DEBUG, (Object)("Examining field " + fi + " (" + fi.getName() + ")"));
                if (!(fi instanceof CalculatedField) || !((fiExp = ((CalculatedField)fi).getExpression()) instanceof Count)) continue;
                Field countedField = ((PropagatedField)((FieldOperand)((Count)fiExp).getExpression()).getField()).getPreviousFields()[0];
                this.log.log(BasicLevel.DEBUG, (Object)("Counted field " + countedField));
                if (!countedField.equals(f)) continue;
                this.log.log(BasicLevel.DEBUG, (Object)("Field " + f.getName() + " used in Count"));
                return (Count)fiExp;
            }
        }
        return null;
    }

    private BasicRdbExpQueryLeaf createQueryLeaf(JormExtent jext) throws MedorException {
        DataStore ds = jext.getDataStore();
        String databasename = jext.getPMapper().getMapperName();
        int idx = databasename.indexOf(46);
        databasename = idx != -1 ? databasename.substring(idx + 1) : "jdbc";
        if (ds == null) {
            Object cf = jext.getPMapper().getConnectionFactory();
            ds = new ConnectionFactoryDataStore(1, cf.toString(), new short[0], cf);
        }
        BasicRdbExpQueryLeaf leaf = new BasicRdbExpQueryLeaf(ds, "");
        try {
            leaf.setRdbAdapter(RdbAdapterFactory.getTypeConverter(databasename));
        }
        catch (RdbAdapterException e) {
            throw new MedorException("Impossible to assign the rdb adapter to the leaf", e);
        }
        return leaf;
    }

    private boolean migrateFieldsFromExtentToLeaf(QueryNode qn, QueryNode parent, BasicRdbExpQueryLeaf leaf, Map localyReplaced) throws MedorException {
        boolean distinctLeafForCountAll = false;
        Field[] fs = qn.getTupleStructure().getFields();
        for (int i = 0; i < fs.length; ++i) {
            if (fs[i] instanceof PropagatedField) {
                QueryTreeField qtf = (QueryTreeField)((PropagatedField)fs[i]).getPreviousFields()[0];
                if (qtf instanceof PNameField) {
                    Count countexp = this.fieldUsedInCount(qtf, parent);
                    if (countexp == null) {
                        if (this.debug) {
                            this.log.log(BasicLevel.DEBUG, (Object)"Regularly used PName");
                        }
                        BasicCalculatedField cf = new BasicCalculatedField(qtf.getName(), qtf.getType(), qtf.getQueryTree(), this.getDecode((PNameField)qtf, leaf, true));
                        if (this.debug) {
                            this.log.log(BasicLevel.DEBUG, (Object)("Replacing PName with calculated field (old " + fs[i] + ", new " + cf + ")"));
                        }
                        qn.replace((QueryTreeField)fs[i], cf);
                        if (parent == null) continue;
                        localyReplaced.put(fs[i], cf);
                        continue;
                    }
                    if (this.debug) {
                        this.log.log(BasicLevel.DEBUG, (Object)"Found a count");
                    }
                    JormExtent extent = (JormExtent)qtf.getQueryTree();
                    if (this.debug) {
                        this.log.log(BasicLevel.DEBUG, (Object)("in extent " + extent.getJormName()));
                    }
                    this.log.log(BasicLevel.DEBUG, (Object)("Looking for NameDef of " + qtf));
                    NameDef nd = ((PNameField)qtf).getNameDef(extent);
                    if (nd.isFieldName()) {
                        QueryTreeField newf = this.getField(nd.getFieldName(), extent, leaf, true);
                        qn.updatePropagatedField(fs[i].getName(), new QueryTreeField[]{newf});
                        this.log.log(BasicLevel.DEBUG, (Object)("New field for single PName " + newf));
                        continue;
                    }
                    if (!nd.isNameRef()) continue;
                    Map proj = nd.getNameRef().getProjection();
                    QueryTreeField newqtf = null;
                    QueryTreeField[] newqtfT = new QueryTreeField[proj.entrySet().size()];
                    int j = 0;
                    Iterator it = proj.entrySet().iterator();
                    while (it.hasNext()) {
                        Map.Entry me = it.next();
                        String clafn = (String)me.getValue();
                        newqtfT[j] = newqtf = this.getField(clafn, extent, leaf, true);
                        ++j;
                    }
                    this.log.log(BasicLevel.DEBUG, (Object)("New field for composite PName " + newqtf));
                    qn.updatePropagatedField(fs[i].getName(), newqtfT);
                    if (proj.size() <= 1) continue;
                    this.log.log(BasicLevel.INFO, (Object)"Count on multiple fields: no other aggregate functions should be allowed");
                    countexp.setCountAll();
                    distinctLeafForCountAll = true;
                    continue;
                }
                QueryTreeField f = this.getField(qtf, leaf, true);
                qn.updatePropagatedField(fs[i].getName(), new QueryTreeField[]{f});
                continue;
            }
            if (fs[i] instanceof CalculatedField) {
                Expression e = ((CalculatedField)fs[i]).getExpression();
                try {
                    e = this.updateFieldOfExpression(e, leaf, true);
                }
                catch (ExpressionException e1) {
                    throw new MedorException(e1);
                }
                qn.updateCalculatedField(fs[i].getName(), e);
                continue;
            }
            throw new MedorException("Unmanaged field (" + fs[i].getName() + "): " + fs[i]);
        }
        this.replaceUsage(parent, localyReplaced);
        return distinctLeafForCountAll;
    }

    private void logInitialStructure() {
        this.log.log(BasicLevel.DEBUG, (Object)"The initial structure values");
        for (int i = 0; i < this.mappings.size(); ++i) {
            this.log.log(BasicLevel.DEBUG, (Object)("Extent " + ((RdbJormExtentMapping)this.mappings.get(i)).extent.getName()));
            this.log.log(BasicLevel.DEBUG, (Object)("Extent tables size " + ((RdbJormExtentMapping)this.mappings.get(i)).tables.size()));
            QualifiedTable quali = (QualifiedTable)((RdbJormExtentMapping)this.mappings.get(i)).tables.get(0);
            this.log.log(BasicLevel.DEBUG, (Object)("Extent table 0 " + quali.getTableName()));
            this.log.log(BasicLevel.DEBUG, (Object)("Extent table alias 0 " + quali.getAliasName()));
            this.log.log(BasicLevel.DEBUG, (Object)("Join size " + ((RdbJormExtentMapping)this.mappings.get(i)).joins.size()));
            this.log.log(BasicLevel.DEBUG, this.mappings.get(i));
        }
    }

    private class ToBeMovedToLeaf
    extends BasicRule.ModifiedExpression {
        RdbExpQueryLeaf leaf;

        ToBeMovedToLeaf(Expression exp, boolean ism, RdbExpQueryLeaf leaf) {
            super(JormFlatten2Rdb.this, exp, ism);
            this.leaf = leaf;
        }

        public void clear() {
            this.e = null;
            this.leaf = null;
            this.isModified = false;
        }

        public boolean hasToBeMoved() {
            return this.leaf != null;
        }
    }

    public class JoinColumn {
        public PType type = null;
        public String field1 = null;
        public String column1 = null;
        public String field2 = null;
        public String column2 = null;

        public String toString() {
            return "(" + this.column1 + " = " + this.column2 + ")";
        }
    }

    public class Join {
        public String name = "";
        public JoinColumn[] columns = null;

        public Join(RdbJoin j, RdbTable maintable, RdbTable externaltable) {
            this.name = j.getName();
            List mcols = j.getPTJoinColumnNames();
            List ecols = j.getETJoinColumnNames();
            this.columns = new JoinColumn[ecols.size()];
            for (int i = 0; i < ecols.size(); ++i) {
                JoinColumn jc = new JoinColumn();
                jc.column1 = (String)mcols.get(i);
                jc.column2 = (String)ecols.get(i);
                RdbPrimitiveElementMapping pem = (RdbPrimitiveElementMapping)maintable.getPrimitiveElementMappingByCol(jc.column1);
                PrimitiveElement pe = (PrimitiveElement)pem.getLinkedMO();
                jc.type = pe.getType();
                jc.field1 = pe.getName();
                pem = (RdbPrimitiveElementMapping)externaltable.getPrimitiveElementMappingByCol(jc.column2);
                if (pem != null) {
                    pe = pem.lookupPrimitiveElement(j);
                    jc.field2 = pe.getName();
                }
                this.columns[i] = jc;
            }
        }

        public String toString() {
            StringBuffer sb = new StringBuffer();
            sb.append(this.name);
            String sep = "{";
            for (int i = 0; i < this.columns.length; ++i) {
                sb.append(sep);
                sb.append(this.columns[i]);
                sep = " && ";
            }
            sb.append('}');
            return sb.toString();
        }
    }

    public class RdbJormExtentMapping {
        private JormExtent extent = null;
        private boolean outer = true;
        private List tables = new ArrayList(5);
        private List joins = new ArrayList(5);

        public RdbJormExtentMapping(JormExtent je) throws MedorException {
            this.setJormExtent(je);
        }

        public void setJormExtent(JormExtent je) throws MedorException {
            this.extent = je;
            if (this.extent.getMetaObject() instanceof Class) {
                RdbClassMultiMapping cm = (RdbClassMultiMapping)JormFlatten2Rdb.this.getClassMapping(this.extent);
                RdbTable maintable = cm.getMainRdbTable();
                Class cl = (Class)cm.getLinkedMO();
                boolean isPolymorphic = cl.isPolymorphic();
                String tableName = maintable.getName();
                String alias = "";
                String query = "( ";
                if (isPolymorphic) {
                    PMapper mapper = this.extent.getPMapper();
                    PClassMapping pcm = mapper.lookup(cl.getFQName());
                    String primaryKey = ((RdbPPolymorphicClass)((Object)pcm)).getPNameFields();
                    if (je.withSubClasses()) {
                        query = query + cm.getRdbInheritanceQuery().getExtentQuery(mapper, ((ClassExtent)this.extent).isPrefetch(), false, primaryKey, pcm);
                    } else {
                        RdbPPolymorphicClass polymorphicPCM = (RdbPPolymorphicClass)((Object)pcm);
                        try {
                            query = query + polymorphicPCM.getExtentQuery(true);
                        }
                        catch (PException e) {
                            throw new MedorException(e);
                        }
                    }
                    query = query + ")";
                    alias = JormFlatten2Rdb.this.getQueryAlias(tableName);
                } else {
                    alias = JormFlatten2Rdb.this.getTableAlias(maintable, null);
                }
                BasicQualifiedTable mainqtable = new BasicQualifiedTable(isPolymorphic ? query : tableName, alias, isPolymorphic, je.withSubClasses());
                mainqtable.getAnnotations().put(JormExtent.ANNOTATION_QUERYTREE_GROUP, je.getAnnotations().get(JormExtent.ANNOTATION_QUERYTREE_GROUP));
                this.tables.add(mainqtable);
                this.joins.add(null);
                if (isPolymorphic) {
                    return;
                }
                Collection etables = cm.getRdbExternalTables();
                Iterator tableit = etables.iterator();
                while (tableit.hasNext()) {
                    RdbExternalTable etable = (RdbExternalTable)tableit.next();
                    Collection rdbJjoins = etable.getRdbJoins();
                    Iterator joinit = rdbJjoins.iterator();
                    if (!joinit.hasNext()) {
                        throw new MedorException("No join defined for the external table " + etable.getName() + " in the extent " + je.getJormName());
                    }
                    while (joinit.hasNext()) {
                        RdbJoin j = (RdbJoin)joinit.next();
                        Join join = new Join(j, maintable, etable);
                        this.joins.add(join);
                        BasicQualifiedTable qtable = new BasicQualifiedTable(etable.getName(), JormFlatten2Rdb.this.getTableAlias(etable, j));
                        qtable.getAnnotations().put(JormExtent.ANNOTATION_QUERYTREE_GROUP, je.getAnnotations().get(JormExtent.ANNOTATION_QUERYTREE_GROUP));
                        this.tables.add(qtable);
                    }
                }
            } else if (this.extent.getMetaObject() instanceof GenClassRef) {
                RdbGenClassMapping gcm = (RdbGenClassMapping)JormFlatten2Rdb.this.getGenClassMapping(this.extent);
                RdbTable maintable = gcm.getRdbTable();
                BasicQualifiedTable mainqtable = new BasicQualifiedTable(maintable.getName(), JormFlatten2Rdb.this.getTableAlias(maintable, null));
                mainqtable.getAnnotations().put(JormExtent.ANNOTATION_QUERYTREE_GROUP, je.getAnnotations().get(JormExtent.ANNOTATION_QUERYTREE_GROUP));
                this.tables.add(mainqtable);
                this.joins.add(null);
            }
        }

        public int getJoinIndex(String joinname) throws MedorException {
            for (int i = 1; i < this.joins.size(); ++i) {
                if (!joinname.equals(((Join)this.joins.get((int)i)).name)) continue;
                return i;
            }
            throw new MedorException("Join " + joinname + " not found in the extent of the class " + this.extent.getJormName());
        }

        public String toString() {
            StringBuffer sb = new StringBuffer();
            sb.append("* ExtentMapping: ");
            sb.append(this.extent.getJormName());
            sb.append("\n");
            sb.append("Tables:\n");
            for (int i = 0; i < this.tables.size(); ++i) {
                QualifiedTable qt = (QualifiedTable)this.tables.get(i);
                sb.append(qt.getAliasName());
                sb.append(" join: ");
                if (this.joins.get(i) != null) {
                    sb.append(this.joins.get(i));
                }
                sb.append("\n");
            }
            return sb.toString();
        }
    }
}

