/*
 * Decompiled with CFR 0.152.
 */
package org.objectweb.medor.optim.jorm;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import org.objectweb.medor.api.Field;
import org.objectweb.medor.api.MedorException;
import org.objectweb.medor.expression.api.Expression;
import org.objectweb.medor.expression.api.ExpressionException;
import org.objectweb.medor.expression.api.MalformedExpressionException;
import org.objectweb.medor.expression.api.Operator;
import org.objectweb.medor.expression.api.ParameterOperand;
import org.objectweb.medor.expression.lib.And;
import org.objectweb.medor.expression.lib.Equal;
import org.objectweb.medor.expression.lib.NotEqual;
import org.objectweb.medor.filter.api.FieldOperand;
import org.objectweb.medor.filter.jorm.lib.CompositePName;
import org.objectweb.medor.filter.jorm.lib.EncodePName;
import org.objectweb.medor.filter.jorm.lib.SinglePName;
import org.objectweb.medor.filter.lib.BasicFieldOperand;
import org.objectweb.medor.filter.lib.MemberOf;
import org.objectweb.medor.optim.lib.BasicRule;
import org.objectweb.medor.query.api.CalculatedField;
import org.objectweb.medor.query.api.PropagFromNestedField;
import org.objectweb.medor.query.api.PropagatedField;
import org.objectweb.medor.query.api.QueryNode;
import org.objectweb.medor.query.api.QueryTree;
import org.objectweb.medor.query.api.QueryTreeField;
import org.objectweb.medor.query.lib.Project;
import org.objectweb.util.monolog.api.BasicLevel;

public class JormGoUpDecodeRule
extends BasicRule {
    public JormGoUpDecodeRule() {
        super("JormGoUpDecodeRule");
    }

    public QueryTree rewrite(QueryTree qt, QueryNode _parent) throws MedorException {
        this.debug = this.log != null && this.log.isLoggable(BasicLevel.DEBUG);
        Field[] fields = qt.getTupleStructure().getFields();
        if (!(qt instanceof QueryNode)) {
            return qt;
        }
        Map map = this.goUpDecode((QueryNode)qt, true);
        if (map.size() == 0) {
            return qt;
        }
        Project result = new Project("");
        Iterator it = map.entrySet().iterator();
        while (it.hasNext()) {
            Map.Entry me = it.next();
            Field decodefield = (Field)me.getKey();
            Object neos = me.getValue();
            Expression e = this.getCalculatedField(decodefield).getExpression();
            if (e instanceof CompositePName) {
                FieldOperand[] fos = ((CompositePName)e).getFields();
                String[] cofns = ((CompositePName)e).getCompositeFieldName();
                for (int i = 0; i < fos.length; ++i) {
                    fos[i].setField((Field)((Map)neos).get(cofns[i]));
                }
            } else if (e instanceof SinglePName) {
                ((SinglePName)e).getField().setField((Field)neos);
            } else {
                throw new MedorException("Umanaged case: PName field decoder in complex expression");
            }
            ((QueryNode)result).addCalculatedField(decodefield.getName(), decodefield.getType(), e);
        }
        for (int i = 0; i < fields.length; ++i) {
            String fn = fields[i].getName();
            if (!qt.getTupleStructure().contains(fn) || result.getTupleStructure().contains(fn)) continue;
            QueryTreeField prev = (QueryTreeField)qt.getTupleStructure().getField(fn);
            this.debug("root: propag=" + prev.getName());
            ((QueryNode)result).addPropagatedField(prev.getName(), prev.getType(), new QueryTreeField[]{prev});
        }
        return result;
    }

    public Map goUpDecode(QueryNode qn, boolean isRoot) throws MedorException {
        HashMap childMap = new HashMap();
        HashMap<Field, Cloneable> map = new HashMap<Field, Cloneable>();
        QueryTree[] qts = qn.getChildren();
        for (int i = 0; i < qts.length; ++i) {
            if (!(qts[i] instanceof QueryNode)) continue;
            childMap.putAll(this.goUpDecode((QueryNode)qts[i], false));
        }
        Expression filter = qn.getQueryFilter();
        if (filter != null) {
            this.debug("replaceFieldOperand in filter");
            try {
                qn.setQueryFilter(this.replaceFieldOperand((Expression)filter, childMap).e);
            }
            catch (ExpressionException e) {
                throw new MedorException(e);
            }
        }
        Field[] fields = qn.getTupleStructure().getFields();
        for (int i = 0; i < fields.length; ++i) {
            this.debug("Field " + fields[i].getName() + " " + fields[i].getType());
            if (!isRoot && fields[i] instanceof CalculatedField) {
                Expression e = ((CalculatedField)fields[i]).getExpression();
                if (e instanceof CompositePName) {
                    this.debug("CalculatedField(CompositePName): begin");
                    qn.removeField(fields[i].getName());
                    FieldOperand[] fops = ((CompositePName)e).getFields();
                    String[] cofns = ((CompositePName)e).getCompositeFieldName();
                    HashMap<String, Field> al = new HashMap<String, Field>(fops.length);
                    this.debug("CompositePName: " + fops.length);
                    for (int j = 0; j < fops.length; ++j) {
                        Field prev = fops[j].getField();
                        Field neo = null;
                        if (!qn.getTupleStructure().contains(prev.getName())) {
                            this.debug("Field " + prev.getName() + " of CompositePName of not already projected.");
                            neo = qn.addPropagatedField(prev.getName(), prev.getType(), new QueryTreeField[]{(QueryTreeField)prev});
                        } else {
                            this.debug("Field " + prev.getName() + " of CompositePName was already propagated.");
                            neo = qn.getTupleStructure().getField(prev.getName());
                        }
                        this.debug("put(" + cofns[j] + "," + neo + ")");
                        al.put(cofns[j], neo);
                    }
                    map.put(fields[i], al);
                    this.debug("CalculatedField(CompositePName): end");
                    continue;
                }
                if (!(e instanceof SinglePName)) continue;
                this.debug("CalculatedField(SinglePName): begin");
                qn.removeField(fields[i].getName());
                Field prev = ((SinglePName)e).getField().getField();
                Field neo = null;
                neo = !qn.getTupleStructure().contains(prev.getName()) ? qn.addPropagatedField(prev.getName(), prev.getType(), new QueryTreeField[]{(QueryTreeField)prev}) : qn.getTupleStructure().getField(prev.getName());
                map.put(fields[i], neo);
                this.debug("CalculatedField(SinglePName): end");
                continue;
            }
            if (!(fields[i] instanceof PropagatedField)) continue;
            this.debug("PropagatedField: begin");
            Field[] prev = ((PropagatedField)fields[i]).getPreviousFields();
            for (int j = 0; j < prev.length; ++j) {
                Object o = childMap.get(prev[j]);
                if (o == null) continue;
                qn.removeField(fields[i].getName());
                if (o instanceof Map) {
                    HashMap neos = new HashMap();
                    Iterator it = ((Map)o).entrySet().iterator();
                    while (it.hasNext()) {
                        Map.Entry me = it.next();
                        Field p = (Field)me.getValue();
                        Field neo = null;
                        neo = !qn.getTupleStructure().contains(p.getName()) ? qn.addPropagatedField(p.getName(), p.getType(), new QueryTreeField[]{(QueryTreeField)p}) : qn.getTupleStructure().getField(p.getName());
                        neos.put(me.getKey(), neo);
                    }
                    map.put(fields[i], neos);
                    continue;
                }
                if (!(o instanceof Field)) continue;
                Field p = (Field)o;
                Field neo = null;
                neo = !qn.getTupleStructure().contains(p.getName()) ? qn.addPropagatedField(p.getName(), p.getType(), new QueryTreeField[]{(QueryTreeField)p}) : qn.getTupleStructure().getField(p.getName());
                map.put(fields[i], neo);
            }
            this.debug("PropagatedField: end");
        }
        return map;
    }

    private BasicRule.ModifiedExpression replaceFieldOperand(Expression e, Map map) throws MedorException, ExpressionException {
        BasicRule.ModifiedExpression me = new BasicRule.ModifiedExpression(this);
        if (e instanceof Equal || e instanceof NotEqual || e instanceof MemberOf) {
            Operator bo = (Operator)e;
            Expression le = bo.getExpression(0);
            Expression re = bo.getExpression(1);
            Object lf = null;
            if (le instanceof FieldOperand) {
                lf = map.get(((FieldOperand)le).getField());
            }
            Object rf = null;
            if (re instanceof FieldOperand) {
                rf = map.get(((FieldOperand)re).getField());
            }
            if (lf != null && rf != null) {
                if (!lf.getClass().equals(rf.getClass())) {
                    throw new MedorException("incompatible PNames (single versus composite)");
                }
                Expression expr = null;
                if (lf instanceof Map) {
                    this.debug("lf=" + lf);
                    if (e instanceof MemberOf) {
                        ArrayList l1 = new ArrayList(((Map)lf).entrySet().size());
                        ArrayList l2 = new ArrayList(((Map)lf).entrySet().size());
                        Iterator it = ((Map)lf).entrySet().iterator();
                        while (it.hasNext()) {
                            Map.Entry mape = it.next();
                            l1.add(mape.getValue());
                            l2.add(((Map)rf).get(mape.getKey()));
                        }
                        me.e = me.e == null ? new MemberOf(l1, l2) : new And(new MemberOf(l1, l2), me.e);
                    } else {
                        Iterator it = ((Map)lf).entrySet().iterator();
                        while (it.hasNext()) {
                            Map.Entry mape = it.next();
                            expr = this.getExpr(e, new BasicFieldOperand((Field)mape.getValue()), new BasicFieldOperand((Field)((Map)rf).get(mape.getKey())));
                            if (me.e == null) {
                                me.e = expr;
                                continue;
                            }
                            me.e = new And(expr, me.e);
                        }
                    }
                } else {
                    expr = this.getExpr(e, new BasicFieldOperand((Field)lf), new BasicFieldOperand((Field)rf));
                    me.e = me.e == null ? expr : new And(expr, me.e);
                }
                me.isModified = true;
                return me;
            }
            if (le instanceof ParameterOperand && rf != null) {
                Expression expr = null;
                if (rf instanceof Map) {
                    Iterator it = ((Map)rf).entrySet().iterator();
                    while (it.hasNext()) {
                        Map.Entry mape = it.next();
                        Field f = (Field)mape.getValue();
                        expr = this.getExpr(e, new EncodePName(f.getType(), ((ParameterOperand)le).getName(), (String)mape.getKey()), new BasicFieldOperand(f));
                        if (me.e == null) {
                            me.e = expr;
                            continue;
                        }
                        me.e = new And(expr, me.e);
                    }
                } else {
                    Field f = (Field)rf;
                    expr = this.getExpr(e, new EncodePName(f.getType(), ((ParameterOperand)le).getName()), new BasicFieldOperand(f));
                    me.e = me.e == null ? expr : new And(expr, me.e);
                }
                me.isModified = true;
                return me;
            }
            if (re instanceof ParameterOperand && lf != null) {
                Expression expr = null;
                if (lf instanceof Map) {
                    Iterator it = ((Map)lf).entrySet().iterator();
                    while (it.hasNext()) {
                        Map.Entry mape = it.next();
                        Field f = (Field)mape.getValue();
                        expr = this.getExpr(e, new BasicFieldOperand(f), new EncodePName(f.getType(), ((ParameterOperand)re).getName(), (String)mape.getKey()));
                        if (me.e == null) {
                            me.e = expr;
                            continue;
                        }
                        me.e = new And(expr, me.e);
                    }
                } else {
                    Field f = (Field)lf;
                    expr = this.getExpr(e, new BasicFieldOperand(f), new EncodePName(f.getType(), ((ParameterOperand)re).getName()));
                    me.e = me.e == null ? expr : new And(expr, me.e);
                }
                me.isModified = true;
                return me;
            }
        }
        if (e instanceof Operator) {
            Operator op = (Operator)e;
            me = new BasicRule.ModifiedExpression(this, e, false);
            BasicRule.ModifiedExpression _me = null;
            for (int i = 0; i < op.getOperandNumber(); ++i) {
                _me = this.replaceFieldOperand(op.getExpression(i), map);
                if (!_me.isModified) continue;
                me.isModified = true;
                op.setExpression(i, _me.e);
            }
        } else {
            me.isModified = false;
        }
        me.e = e;
        return me;
    }

    private Expression getExpr(Expression operator, Expression loperand, Expression roperand) throws MalformedExpressionException {
        if (operator instanceof Equal) {
            return new Equal(loperand, roperand);
        }
        if (operator instanceof NotEqual) {
            return new NotEqual(loperand, roperand);
        }
        ArrayList<Expression> l1 = new ArrayList<Expression>(1);
        l1.add(loperand);
        ArrayList<Expression> l2 = new ArrayList<Expression>(1);
        l2.add(roperand);
        return new MemberOf(l1, l2);
    }

    private CalculatedField getCalculatedField(Field f) throws MedorException {
        if (f == null) {
            return null;
        }
        if (f instanceof PropagatedField) {
            return this.getCalculatedField(((PropagatedField)f).getPreviousFields()[0]);
        }
        if (f instanceof CalculatedField) {
            return (CalculatedField)f;
        }
        if (f instanceof PropagFromNestedField) {
            return this.getCalculatedField(((PropagFromNestedField)f).getPreviousFlatField()[0]);
        }
        throw new MedorException("Medor Internal error: Unknown field");
    }

    private void debug(String msg) {
    }
}

