/*
 * Decompiled with CFR 0.152.
 */
package org.objectweb.medor.optim.lib;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import java.util.List;
import org.objectweb.medor.api.MedorException;
import org.objectweb.medor.lib.Log;
import org.objectweb.medor.optim.api.QueryRewriter;
import org.objectweb.medor.optim.api.RewriteRule;
import org.objectweb.medor.optim.api.RuleConfiguration;
import org.objectweb.medor.optim.lib.BasicRule;
import org.objectweb.medor.optim.lib.DropUnusedProjFieldsRule;
import org.objectweb.medor.optim.lib.DropUselessNodeRule;
import org.objectweb.medor.optim.lib.PushNotInExpressionRule;
import org.objectweb.medor.optim.lib.PushSelectionRule;
import org.objectweb.medor.optim.rdb.GroupSameDBRule;
import org.objectweb.medor.query.api.QueryTree;
import org.objectweb.medor.query.lib.QueryTreePrinter;
import org.objectweb.util.monolog.api.BasicLevel;
import org.objectweb.util.monolog.api.Logger;

public class BasicQueryRewriter
implements QueryRewriter,
RuleConfiguration {
    protected List rules = null;
    protected Logger log = null;
    protected boolean debug = false;

    public BasicQueryRewriter() {
        this(new ArrayList());
    }

    public BasicQueryRewriter(ArrayList rules) {
        this.rules = rules;
        this.log = Log.loggerFactory.getLogger("org.objectweb.medor.optim.rewriter.BasicQueryRewriter");
        boolean bl = this.debug = this.log != null && this.log.isLoggable(BasicLevel.DEBUG);
        if (this.debug) {
            this.log.log(BasicLevel.DEBUG, (Object)"Creating Query Rewriter");
        }
    }

    public BasicQueryRewriter(Collection rules) {
        this.rules = new ArrayList(rules);
    }

    public List getDefaultRules() {
        ArrayList<BasicRule> al = new ArrayList<BasicRule>();
        al.add(new PushNotInExpressionRule());
        al.add(new PushSelectionRule());
        al.add(new DropUnusedProjFieldsRule());
        al.add(new DropUselessNodeRule());
        al.add(new GroupSameDBRule());
        al.add(new DropUnusedProjFieldsRule());
        return al;
    }

    public void setRuleConfiguration(RuleConfiguration config) {
        this.rules = config.getRules();
    }

    public QueryTree transform(QueryTree qt) throws MedorException {
        if (this.debug) {
            this.log.log(BasicLevel.DEBUG, (Object)"Entering transformation");
        }
        QueryTree root = qt;
        Iterator it = this.rules.iterator();
        while (it.hasNext()) {
            RewriteRule rule = (RewriteRule)it.next();
            if (this.debug) {
                QueryTreePrinter.printQueryTree(root, this.log);
                this.log.log(BasicLevel.DEBUG, (Object)("Run the rule: " + rule.getClass().getName()));
            }
            root = rule.rewrite(root, null);
        }
        if (this.debug) {
            QueryTreePrinter.printQueryTree(root, this.log);
        }
        return root;
    }

    public void addRule(RewriteRule rule) {
        this.rules.add(rule);
    }

    public void removeRule(RewriteRule rule) {
        this.rules.remove(rule);
    }

    public List getRules() {
        return this.rules;
    }
}

