/*
 * Decompiled with CFR 0.152.
 */
package org.objectweb.medor.optim.lib;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import org.objectweb.medor.api.Field;
import org.objectweb.medor.api.MedorException;
import org.objectweb.medor.expression.api.Expression;
import org.objectweb.medor.expression.api.Operator;
import org.objectweb.medor.filter.api.FieldOperand;
import org.objectweb.medor.optim.lib.BasicRule;
import org.objectweb.medor.query.api.CalculatedField;
import org.objectweb.medor.query.api.FilteredQueryTree;
import org.objectweb.medor.query.api.NestQueryNode;
import org.objectweb.medor.query.api.NestedField;
import org.objectweb.medor.query.api.PropagatedField;
import org.objectweb.medor.query.api.QueryLeaf;
import org.objectweb.medor.query.api.QueryNode;
import org.objectweb.medor.query.api.QueryTree;
import org.objectweb.medor.query.api.QueryTreeField;
import org.objectweb.medor.query.lib.QueryTreePrinter;
import org.objectweb.medor.query.rdb.api.RdbExpField;
import org.objectweb.medor.query.rdb.api.RdbExpQueryLeaf;
import org.objectweb.util.monolog.api.BasicLevel;

public class DropUnusedProjFieldsRule
extends BasicRule {
    public DropUnusedProjFieldsRule() {
        super("DropUnusedProjFieldsRule");
    }

    public QueryTree rewrite(QueryTree qt, QueryNode _parent) throws MedorException {
        boolean bl = this.debug = this.log != null && this.log.isLoggable(BasicLevel.DEBUG);
        if (qt instanceof QueryNode) {
            Object[] myFields = qt.getTupleStructure().getFields();
            this.dropUnusedProjFields(qt, this.array2arrayList(myFields));
        }
        return qt;
    }

    private void dropUnusedProjFields(QueryTree qt, ArrayList wanted) throws MedorException {
        int i;
        if (this.debug) {
            this.log.log(BasicLevel.DEBUG, (Object)("-Current node is " + qt));
        }
        if (this.debug) {
            this.log.log(BasicLevel.DEBUG, (Object)"Query tree before dropping fields:");
        }
        if (this.debug) {
            QueryTreePrinter.printQueryTree(qt, this.log);
        }
        HashMap qt2ReqFields = new HashMap();
        if (this.debug) {
            this.log.log(BasicLevel.DEBUG, (Object)" Drop unused fields from projected fields in according to usage");
        }
        Field[] myFields = qt.getTupleStructure().getFields();
        for (i = 0; i < myFields.length; ++i) {
            if (this.debug) {
                this.log.log(BasicLevel.DEBUG, (Object)("\tfield=" + myFields[i].getName()));
            }
            if (wanted.contains(myFields[i])) continue;
            if (this.debug) {
                this.log.log(BasicLevel.DEBUG, (Object)("\tDropping field " + myFields[i].getName() + " (" + myFields[i] + ") " + " qt=" + qt));
            }
            if (qt instanceof QueryNode) {
                ((QueryNode)qt).removeField(myFields[i].getName());
                continue;
            }
            if (!(qt instanceof RdbExpQueryLeaf)) continue;
            ((RdbExpQueryLeaf)qt).removeRdbField((RdbExpField)myFields[i]);
        }
        if (this.debug) {
            this.log.log(BasicLevel.DEBUG, (Object)"Query tree after dropping fields:");
        }
        if (this.debug) {
            QueryTreePrinter.printQueryTree(qt, this.log);
        }
        if (qt instanceof QueryLeaf) {
            return;
        }
        if (this.debug) {
            this.log.log(BasicLevel.DEBUG, (Object)" calculate the Map (qt child => { field }");
        }
        myFields = qt.getTupleStructure().getFields();
        for (i = 0; i < myFields.length; ++i) {
            if (this.debug) {
                this.log.log(BasicLevel.DEBUG, (Object)("\tfield " + myFields[i].getName() + " is " + myFields[i]));
            }
            if (myFields[i] instanceof CalculatedField) {
                this.addFieldFromExpression(qt2ReqFields, ((CalculatedField)myFields[i]).getExpression());
                continue;
            }
            this.addFieldInMap(qt2ReqFields, (QueryTreeField)myFields[i]);
        }
        if (qt instanceof NestQueryNode) {
            if (this.debug) {
                this.log.log(BasicLevel.DEBUG, (Object)" adding grouping fields");
            }
            myFields = ((NestQueryNode)qt).getNestingFields();
            for (i = 0; i < myFields.length; ++i) {
                this.addAncestorsToMap(qt2ReqFields, new Field[]{(QueryTreeField)myFields[i]});
            }
        }
        if (this.debug) {
            this.log.log(BasicLevel.DEBUG, (Object)"Add field from the query filter");
        }
        this.addFieldFromExpression(qt2ReqFields, ((FilteredQueryTree)qt).getQueryFilter());
        if (this.debug) {
            this.log.log(BasicLevel.DEBUG, (Object)"Recall on children");
        }
        Iterator it = qt2ReqFields.entrySet().iterator();
        while (it.hasNext()) {
            Map.Entry e = it.next();
            this.dropUnusedProjFields((QueryTree)e.getKey(), (ArrayList)e.getValue());
        }
    }

    private void addFieldFromExpression(Map qt2ReqFields, Expression exp) {
        block7: {
            block5: {
                block8: {
                    ArrayList<QueryTreeField> fields;
                    QueryTreeField f;
                    block6: {
                        if (!(exp instanceof FieldOperand)) break block5;
                        f = (QueryTreeField)((FieldOperand)exp).getField();
                        QueryTree qt = f.getQueryTree();
                        fields = (ArrayList<QueryTreeField>)qt2ReqFields.get(qt);
                        if (fields != null) break block6;
                        if (this.debug) {
                            this.log.log(BasicLevel.DEBUG, (Object)"addFieldFromExpression: FieldOperand, new Qt in map");
                        }
                        fields = new ArrayList<QueryTreeField>(1);
                        fields.add(f);
                        qt2ReqFields.put(qt, fields);
                        break block7;
                    }
                    if (fields.contains(f)) break block8;
                    if (this.debug) {
                        this.log.log(BasicLevel.DEBUG, (Object)"addFieldFromExpression: FieldOperand, Qt exists in map");
                    }
                    fields.add(f);
                    break block7;
                }
                if (!this.debug) break block7;
                this.log.log(BasicLevel.DEBUG, (Object)"addFieldFromExpression: FieldOperand already referenced");
                break block7;
            }
            if (exp instanceof Operator) {
                if (this.debug) {
                    this.log.log(BasicLevel.DEBUG, (Object)"addFieldFromExpression: Operator");
                }
                for (int i = 0; i < ((Operator)exp).getOperandNumber(); ++i) {
                    this.addFieldFromExpression(qt2ReqFields, ((Operator)exp).getExpression(i));
                }
            }
        }
    }

    private void addFieldInMap(Map qt2ReqFields, QueryTreeField field) {
        if (this.debug) {
            this.log.log(BasicLevel.DEBUG, (Object)("addFieldInMap: field " + field));
        }
        Field[] anc = null;
        if (field instanceof PropagatedField) {
            anc = ((PropagatedField)field).getPreviousFields();
            if (this.debug) {
                this.log.log(BasicLevel.DEBUG, (Object)("addFieldInMap: PropagatedField " + field.getName()));
            }
        } else if (field instanceof NestedField) {
            anc = ((NestedField)field).getFields();
            if (this.debug) {
                this.log.log(BasicLevel.DEBUG, (Object)("addFieldInMap: NestedField " + field.getName()));
            }
        } else {
            anc = new Field[]{};
        }
        this.addAncestorsToMap(qt2ReqFields, anc);
    }

    private void addAncestorsToMap(Map qt2ReqFields, Field[] anc) {
        if (this.debug) {
            this.log.log(BasicLevel.DEBUG, (Object)("addFieldInMap: registered previous, nb=" + anc.length));
        }
        for (int i = 0; i < anc.length; ++i) {
            ArrayList<Field> fields;
            QueryTree qt = ((QueryTreeField)anc[i]).getQueryTree();
            if (this.debug) {
                this.log.log(BasicLevel.DEBUG, (Object)("addFieldInMap: treating field " + anc[i] + " of node " + qt));
            }
            if ((fields = (ArrayList<Field>)qt2ReqFields.get(qt)) == null) {
                if (this.debug) {
                    this.log.log(BasicLevel.DEBUG, (Object)"addFieldInMap: Field, new Qt exists map");
                }
                fields = new ArrayList<Field>(1);
                fields.add(anc[i]);
                qt2ReqFields.put(qt, fields);
                continue;
            }
            if (!fields.contains(anc[i])) {
                if (this.debug) {
                    this.log.log(BasicLevel.DEBUG, (Object)"addFieldInMap: Field, Qt exists in map");
                }
                fields.add(anc[i]);
                continue;
            }
            if (!this.debug) continue;
            this.log.log(BasicLevel.DEBUG, (Object)"addFieldInMap: Field already referenced");
        }
    }

    private ArrayList array2arrayList(Object[] array) {
        ArrayList<Object> alist = new ArrayList<Object>(array.length);
        for (int i = 0; i < array.length; ++i) {
            alist.add(array[i]);
        }
        return alist;
    }
}

