/*
 * Decompiled with CFR 0.152.
 */
package org.objectweb.medor.optim.lib;

import java.util.HashMap;
import java.util.HashSet;
import java.util.Set;
import org.objectweb.medor.api.Field;
import org.objectweb.medor.api.MedorException;
import org.objectweb.medor.expression.api.Expression;
import org.objectweb.medor.expression.api.Operator;
import org.objectweb.medor.expression.lib.And;
import org.objectweb.medor.filter.api.FieldOperand;
import org.objectweb.medor.filter.lib.ExpressionPrinter;
import org.objectweb.medor.optim.lib.BasicRule;
import org.objectweb.medor.query.api.CalculatedField;
import org.objectweb.medor.query.api.FilteredQueryTree;
import org.objectweb.medor.query.api.OrderField;
import org.objectweb.medor.query.api.PropagatedField;
import org.objectweb.medor.query.api.QueryLeaf;
import org.objectweb.medor.query.api.QueryNode;
import org.objectweb.medor.query.api.QueryTree;
import org.objectweb.medor.query.api.QueryTreeField;
import org.objectweb.medor.query.lib.Nest;
import org.objectweb.util.monolog.api.BasicLevel;

public class FlattenQueryTreeRule
extends BasicRule {
    public FlattenQueryTreeRule() {
        super("FlattenQueryTreeRule");
    }

    public QueryTree rewrite(QueryTree qt, QueryNode parent) throws MedorException {
        return this.flatten(parent, qt);
    }

    public QueryTree flatten(QueryNode parent, QueryTree qt) throws MedorException {
        if (qt instanceof QueryLeaf) {
            return qt;
        }
        if (qt instanceof Nest) {
            this.flatten((Nest)qt, ((QueryNode)qt).getChildren()[0]);
            return qt;
        }
        QueryNode qn = (QueryNode)qt;
        QueryTree[] children = qn.getChildren();
        HashMap<Field, QueryTreeField> localyReplaced = parent == null ? null : new HashMap<Field, QueryTreeField>();
        Set inner = this.findInner(qn);
        while (this.containsQueryNode(children)) {
            this.log.log(BasicLevel.DEBUG, (Object)"node");
            if (this.useParent(qn.getQueryFilter())) {
                qn.setQueryFilter(qn.getQueryFilter());
            }
            Field[] fs = qt.getTupleStructure().getFields();
            for (int i = 0; i < fs.length; ++i) {
                if (fs[i] instanceof PropagatedField) {
                    QueryTreeField childF = (QueryTreeField)((PropagatedField)fs[i]).getPreviousFields()[0];
                    if (childF.getQueryTree() instanceof QueryLeaf) continue;
                    if (childF instanceof PropagatedField) {
                        qn.updatePropagatedField(fs[i].getName(), new QueryTreeField[]{(QueryTreeField)((PropagatedField)childF).getPreviousFields()[0]});
                        continue;
                    }
                    if (childF instanceof CalculatedField) {
                        qn.replace((QueryTreeField)fs[i], childF);
                        if (parent == null) continue;
                        localyReplaced.put(fs[i], childF);
                        continue;
                    }
                    throw new MedorException("Unmanaged child field: " + childF);
                }
                if (fs[i] instanceof CalculatedField) {
                    CalculatedField cf = (CalculatedField)fs[i];
                    if (!this.useParent(cf.getExpression())) continue;
                    qn.updateCalculatedField(cf.getName(), cf.getExpression());
                    continue;
                }
                throw new MedorException("Unmanaged Field: " + fs[i]);
            }
            this.replaceUsage(parent, localyReplaced);
            OrderField[] orderFields = qt.getOrderBy();
            if (orderFields != null) {
                for (int i = 0; i < orderFields.length; ++i) {
                    QueryTreeField orderField = orderFields[i].getField();
                    if (this.debug) {
                        this.log.log(BasicLevel.DEBUG, (Object)("managing orderField " + orderField));
                    }
                    if (orderField.getQueryTree() instanceof QueryLeaf) {
                        if (!this.debug) continue;
                        this.log.log(BasicLevel.DEBUG, (Object)("nothing to do for this field (already on a leaf) " + orderField));
                        continue;
                    }
                    if (orderField instanceof PropagatedField) {
                        QueryTreeField childF = (QueryTreeField)((PropagatedField)orderField).getPreviousFields()[0];
                        if (childF.getQueryTree() instanceof QueryLeaf) continue;
                        if (childF instanceof PropagatedField) {
                            orderFields[i].setField((QueryTreeField)((PropagatedField)childF).getPreviousFields()[0]);
                            continue;
                        }
                        if (childF instanceof CalculatedField) {
                            orderFields[i].setField(childF);
                            continue;
                        }
                        throw new MedorException("Unmanaged child field: " + childF);
                    }
                    if (orderField instanceof CalculatedField) {
                        CalculatedField cf = (CalculatedField)orderField;
                        if (!this.useParent(cf.getExpression())) continue;
                        ((CalculatedField)orderField).setExpression(cf.getExpression());
                        continue;
                    }
                    throw new MedorException("Unmanaged Field: " + orderField);
                }
                qt.setOrderBy(orderFields);
            }
            boolean modified = false;
            Expression e = qn.getQueryFilter();
            for (int i = 0; i < children.length; ++i) {
                Expression filter;
                if (!(children[i] instanceof FilteredQueryTree) || (filter = ((FilteredQueryTree)children[i]).getQueryFilter()) == null) continue;
                e = e == null ? filter : new And(e, filter);
                modified = true;
            }
            if (modified) {
                this.log.log(BasicLevel.DEBUG, (Object)("Filter modified: " + ExpressionPrinter.e2str(e)));
                qn.setQueryFilter(e);
            }
            children = qn.getChildren();
        }
        for (int i = 0; i < children.length; ++i) {
            qn.setOuter(children[i], !inner.contains(children[i]));
        }
        return qt;
    }

    private Set findInner(QueryTree qt) {
        HashSet result = new HashSet();
        this.findInner(qt, false, result);
        return result;
    }

    private void findInner(QueryTree qt, boolean inner, Set result) {
        if (inner) {
            result.add(qt);
        }
        if (qt instanceof QueryNode) {
            QueryNode qn = (QueryNode)qt;
            QueryTree[] children = qn.getChildren();
            for (int i = 0; i < children.length; ++i) {
                this.findInner(children[i], inner || !qn.isOuter(children[i]), result);
            }
        }
    }

    private boolean containsQueryNode(QueryTree[] qts) {
        this.log.log(BasicLevel.DEBUG, (Object)("Entering containsQueryNode for " + qts.length + " QueryTrees."));
        for (int i = 0; i < qts.length; ++i) {
            if (qts[i] instanceof QueryNode) {
                this.log.log(BasicLevel.DEBUG, (Object)("Found QueryNode " + qts[i]));
                return true;
            }
            this.log.log(BasicLevel.DEBUG, (Object)("Found other QueryTree " + qts[i]));
        }
        this.log.log(BasicLevel.DEBUG, (Object)"containsQueryNode: no QueryNode found. Exiting");
        return false;
    }

    private boolean useParent(Expression e) {
        if (e instanceof Operator) {
            int size = ((Operator)e).getOperandNumber();
            boolean res = false;
            for (int i = 0; i < size; ++i) {
                res |= this.useParent(((Operator)e).getExpression(i));
            }
            return res;
        }
        if (e instanceof FieldOperand) {
            FieldOperand fo = (FieldOperand)e;
            QueryTreeField f = (QueryTreeField)fo.getField();
            if (f.getQueryTree() instanceof QueryLeaf) {
                return false;
            }
            if (f instanceof PropagatedField) {
                fo.setField(((PropagatedField)f).getPreviousFields()[0]);
                return true;
            }
            this.log.log(BasicLevel.ERROR, (Object)("Unmanaged FieldOperand: " + f));
        }
        return false;
    }
}

