/*
 * Decompiled with CFR 0.152.
 */
package org.objectweb.medor.optim.lib;

import org.objectweb.medor.api.Field;
import org.objectweb.medor.api.MedorException;
import org.objectweb.medor.api.QueryNodeException;
import org.objectweb.medor.api.TupleStructure;
import org.objectweb.medor.expression.api.Expression;
import org.objectweb.medor.expression.api.ExpressionException;
import org.objectweb.medor.expression.api.Operator;
import org.objectweb.medor.filter.api.FieldOperand;
import org.objectweb.medor.optim.api.ExecPlanGenerator;
import org.objectweb.medor.query.api.CalculatedField;
import org.objectweb.medor.query.api.PropagatedField;
import org.objectweb.medor.query.api.QueryNode;
import org.objectweb.medor.query.api.QueryTree;
import org.objectweb.medor.query.api.TCQueryLeaf;
import org.objectweb.medor.query.rdb.lib.AggregateRdbQueryNode;
import org.objectweb.medor.tuple.lib.GeneralTupleLoader;

public class IndexesGenerator
implements ExecPlanGenerator {
    public QueryTree transform(QueryTree query) throws MedorException {
        try {
            this.generateIndexes(query);
        }
        catch (MedorException e) {
            throw e;
        }
        catch (ExpressionException e) {
            throw new MedorException(e);
        }
        return query;
    }

    private void generateIndexes(QueryTree query) throws MedorException, ExpressionException {
        if (query instanceof QueryNode) {
            QueryNode qn = (QueryNode)query;
            if (!(query instanceof AggregateRdbQueryNode)) {
                this.setFilterIndexes(qn.getQueryFilter(), qn.getChildren());
            }
            qn.setTupleLoader(new GeneralTupleLoader(this.computesFieldIndexes(qn.getTupleStructure(), qn.getChildren()), query.getTupleStructure()));
            QueryTree[] children = qn.getChildren();
            for (int cpt = 0; cpt < children.length; ++cpt) {
                this.generateIndexes(children[cpt]);
            }
        } else if (query instanceof TCQueryLeaf) {
            TCQueryLeaf tcLeaf = (TCQueryLeaf)query;
            TupleStructure ts = tcLeaf.getTupleStructure();
            boolean stop = false;
            int[] indexes = new int[ts.getSize()];
            for (int cpt = 0; cpt < ts.getSize() && !stop; ++cpt) {
                indexes[cpt] = tcLeaf.getTupleCollection().getMetaData().getFieldRank(tcLeaf.getTupleCollection().getMetaData().getField(ts.getField(cpt + 1).getName()));
            }
            tcLeaf.setTupleLoader(new GeneralTupleLoader(indexes, query.getTupleStructure()));
            this.setTCQLFilterIndexes(tcLeaf.getQueryFilter(), tcLeaf);
        }
    }

    public int[] computesFieldIndexes(TupleStructure ts, QueryTree[] nodes) throws MedorException, ExpressionException {
        Field[] ancestor = null;
        Field current = null;
        int[] indexes = new int[ts.getSize()];
        for (int i = 1; i <= ts.getSize(); ++i) {
            try {
                current = ts.getField(i);
            }
            catch (MedorException me) {
                // empty catch block
            }
            if (current instanceof PropagatedField) {
                ancestor = ((PropagatedField)current).getPreviousFields();
                for (int j = 0; j < ancestor.length; ++j) {
                    int rank = 0;
                    int cpt = 0;
                    for (cpt = 0; cpt < nodes.length && !this.containsField(nodes[cpt], ancestor[j]); ++cpt) {
                        rank += nodes[cpt].getTupleStructure().getSize();
                    }
                    if (cpt >= nodes.length) {
                        throw new QueryNodeException("The previous field " + ancestor[j].getName() + " must have a QueryTree which matches with one of children");
                    }
                    indexes[i - 1] = rank + nodes[cpt].getTupleStructure().getFieldRank(nodes[cpt].getTupleStructure().getField(ancestor[j].getName()));
                }
                continue;
            }
            if (current instanceof CalculatedField) {
                this.setFilterIndexes(((CalculatedField)current).getExpression(), nodes);
                indexes[i - 1] = -1;
                continue;
            }
            throw new QueryNodeException("QueryNode fields error for field " + current.getName());
        }
        return indexes;
    }

    public void setFilterIndexes(Expression e, QueryTree[] qts) throws MedorException, ExpressionException {
        if (e == null) {
            return;
        }
        e.compileExpression();
        if (e instanceof Operator) {
            for (int i = 0; i < ((Operator)e).getOperandNumber(); ++i) {
                this.setFilterIndexes(((Operator)e).getExpression(i), qts);
            }
        } else if (e instanceof FieldOperand) {
            int i;
            int rank = 0;
            for (i = 0; i < qts.length && !this.containsField(qts[i], ((FieldOperand)e).getField()); ++i) {
                rank += qts[i].getTupleStructure().getSize();
            }
            if (i != qts.length) {
                ((FieldOperand)e).setIndex(rank + qts[i].getTupleStructure().getFieldRank(qts[i].getTupleStructure().getField(((FieldOperand)e).getField().getName())));
            } else {
                throw new ExpressionException("Field not found in the subQueryTree: " + ((FieldOperand)e).getField().getName());
            }
        }
    }

    private void setTCQLFilterIndexes(Expression e, TCQueryLeaf tcLeaf) throws MedorException, ExpressionException {
        if (e == null) {
            return;
        }
        e.compileExpression();
        if (e instanceof Operator) {
            for (int i = 0; i < ((Operator)e).getOperandNumber(); ++i) {
                this.setTCQLFilterIndexes(((Operator)e).getExpression(i), tcLeaf);
            }
        } else if (e instanceof FieldOperand) {
            ((FieldOperand)e).setIndex(tcLeaf.getTupleStructure().getFieldRank(tcLeaf.getTupleStructure().getField(((FieldOperand)e).getField().getName())));
        }
    }

    private boolean containsField(QueryTree qt, Field field) {
        return qt.getTupleStructure().contains(field);
    }
}

