/*
 * Decompiled with CFR 0.152.
 */
package org.objectweb.medor.query.jorm.lib;

import java.util.Iterator;
import java.util.Map;
import org.objectweb.jorm.metainfo.api.Class;
import org.objectweb.jorm.metainfo.api.MetaObject;
import org.objectweb.jorm.metainfo.api.Reference;
import org.objectweb.jorm.metainfo.api.TypedElement;
import org.objectweb.medor.api.MedorException;
import org.objectweb.medor.query.api.QueryTree;
import org.objectweb.medor.query.api.QueryTreeField;
import org.objectweb.medor.query.jorm.lib.BasicJormExtent;
import org.objectweb.medor.query.jorm.lib.BasicJormField;
import org.objectweb.medor.query.jorm.lib.PNameField;

public class ClassExtent
extends BasicJormExtent {
    private Class myClass;
    private boolean prefetch = false;

    public ClassExtent() {
    }

    public ClassExtent(String _name, String pnFieldName) {
        super(_name, pnFieldName);
    }

    public ClassExtent(Class jormClass, String _name, String pnameFieldName, boolean classPNameOnly) throws MedorException {
        super(_name, pnameFieldName);
        this.myClass = jormClass;
        this.identifier = new PNameField(this.getFieldName(this.name, pnameFieldName), this.myClass, (QueryTree)this);
        this.fields.add(this.identifier);
        this.name2field.put(this.identifier.getName(), this.identifier);
        if (!classPNameOnly) {
            Iterator it = jormClass.getAllFields().iterator();
            while (it.hasNext()) {
                this.addField((TypedElement)it.next());
            }
        }
    }

    public ClassExtent(Class jormClass, String _name, String[] fieldNames, boolean addPName, String pnameFieldName) throws MedorException {
        super(_name, pnameFieldName);
        this.myClass = jormClass;
        if (addPName) {
            PNameField nameField = new PNameField(this.getFieldName(this.name, pnameFieldName), this.myClass, (QueryTree)this);
            this.fields.add(nameField);
            this.name2field.put(nameField.getName(), nameField);
        }
        for (int i = 0; i < fieldNames.length; ++i) {
            TypedElement te = jormClass.getTypedElement(fieldNames[i]);
            if (te == null) {
                throw new MedorException("No field named " + fieldNames[i] + " in JORM class " + jormClass.getName());
            }
            this.addField(te);
        }
    }

    public Object clone(Object clone, Map obj2clone) throws CloneNotSupportedException {
        clone = super.clone(clone, obj2clone);
        ((ClassExtent)clone).myClass = this.myClass;
        return clone;
    }

    public QueryTreeField addField(String fieldName) throws MedorException {
        if (fieldName == null) {
            throw new IllegalArgumentException("Null field name");
        }
        TypedElement te = this.myClass.getTypedElement(fieldName);
        if (te == null) {
            throw new MedorException("No field '" + fieldName + "' found on the class '" + this.myClass.getName() + "'.");
        }
        return this.addField(te);
    }

    public QueryTreeField addField(TypedElement te) throws MedorException {
        QueryTreeField basicF = null;
        String fn = this.getFieldName(this.name, te.getName());
        basicF = (QueryTreeField)this.name2field.get(fn);
        if (basicF != null) {
            throw new MedorException("the field " + te.getName() + " is already defined (" + fn + ")");
        }
        basicF = te instanceof Reference ? new PNameField(fn, this.myClass, (QueryTree)this) : new BasicJormField(fn, this, te);
        this.fields.add(basicF);
        this.name2field.put(basicF.getName(), basicF);
        return basicF;
    }

    public MetaObject getMetaObject() {
        return this.myClass;
    }

    public String getJormName() {
        return this.myClass.getFQName();
    }

    public boolean isPrefetch() {
        return this.prefetch;
    }

    public void setPrefetch(boolean prefetch) {
        this.prefetch = prefetch;
    }
}

