/*
 * Decompiled with CFR 0.152.
 */
package org.objectweb.medor.query.jorm.lib;

import java.util.ArrayList;
import java.util.Collections;
import org.objectweb.jorm.metainfo.api.Class;
import org.objectweb.jorm.metainfo.api.ClassRef;
import org.objectweb.jorm.metainfo.api.GenClassRef;
import org.objectweb.jorm.metainfo.api.Reference;
import org.objectweb.jorm.metainfo.api.TypedElement;
import org.objectweb.medor.api.Field;
import org.objectweb.medor.api.MedorException;
import org.objectweb.medor.api.TupleStructure;
import org.objectweb.medor.expression.api.Expression;
import org.objectweb.medor.expression.api.MalformedExpressionException;
import org.objectweb.medor.expression.api.Operand;
import org.objectweb.medor.expression.api.TypingException;
import org.objectweb.medor.expression.lib.And;
import org.objectweb.medor.expression.lib.Equal;
import org.objectweb.medor.expression.lib.Not;
import org.objectweb.medor.filter.api.FieldOperand;
import org.objectweb.medor.filter.jorm.lib.NavigatorOperator;
import org.objectweb.medor.filter.lib.BasicFieldOperand;
import org.objectweb.medor.filter.lib.ExpressionPrinter;
import org.objectweb.medor.filter.lib.MemberOf;
import org.objectweb.medor.lib.Log;
import org.objectweb.medor.query.api.PropagatedField;
import org.objectweb.medor.query.api.QueryNode;
import org.objectweb.medor.query.api.QueryTree;
import org.objectweb.medor.query.api.QueryTreeField;
import org.objectweb.medor.query.jorm.api.JormExtent;
import org.objectweb.medor.query.jorm.lib.ClassExtent;
import org.objectweb.medor.query.jorm.lib.GenClassExtent;
import org.objectweb.medor.query.jorm.lib.PNameField;
import org.objectweb.medor.query.lib.JoinProject;
import org.objectweb.medor.query.lib.QueryTreePrinter;
import org.objectweb.util.monolog.api.BasicLevel;
import org.objectweb.util.monolog.api.Logger;

public class NavigatorNodeFactory {
    public static final String PNAME_FIELD_NAME = "object";
    private static int pnameFieldNameIndex = 0;
    public static final String GENCLASS_ELEMENT_NAME = "element";
    public static final byte NAVIGATION = 1;
    public static final byte NAVIGATION_INTO_LAST = 2;
    public static final byte IS_EMPTY = 4;
    public static final byte IS_NOT_EMPTY = 8;
    public static Logger logger = Log.getLoggerFactory().getLogger("org.objectweb.medor.query.jorm.NavigatorNodeFactory");

    public static QueryTreeField navigate(NavigatorOperator nav, String aliasName, byte operation) throws MedorException {
        QueryTreeField qtf = null;
        PNameField pnf = null;
        byte op = 1;
        boolean joinAlreadyConstructed = false;
        String fieldName = null;
        try {
            fieldName = ((Operand)nav.getExpression(1)).getString();
        }
        catch (TypingException te) {
            throw new MedorException(te);
        }
        logger.log(BasicLevel.DEBUG, (Object)("navigate(" + aliasName + ", " + ExpressionPrinter.e2str(nav.getExpression(0)) + ", " + fieldName + ", op:" + op + ")"));
        ArrayList path = new ArrayList();
        path.add(nav.getFieldOperand());
        path = nav.getPath(path);
        for (int j = 0; j < path.size() - 1; ++j) {
            boolean propagQtf;
            Object element;
            if (j == path.size() - 2) {
                op = operation;
            }
            if ((element = path.get(j)) instanceof FieldOperand) {
                qtf = (QueryTreeField)((FieldOperand)element).getField();
                pnf = NavigatorNodeFactory.getPNameField(qtf);
                logger.log(BasicLevel.DEBUG, (Object)("Navigation from FieldOperand " + qtf.getName()));
                propagQtf = true;
            } else {
                propagQtf = true;
                logger.log(BasicLevel.DEBUG, (Object)("Further navigation for " + element));
            }
            fieldName = (String)path.get(j + 1);
            logger.log(BasicLevel.DEBUG, (Object)("Navigate to " + fieldName));
            logger.log(BasicLevel.DEBUG, (Object)("propagQtf=" + propagQtf));
            logger.log(BasicLevel.DEBUG, (Object)("qtf=" + qtf.getName() + " of node " + qtf.getQueryTree()));
            if (pnf == null) {
                throw new MedorException("Impossible to find a PNameField");
            }
            QueryTree qt = qtf.getQueryTree();
            if (!pnf.isClassPName()) {
                int i;
                JoinProject join;
                String nodeName;
                logger.log(BasicLevel.DEBUG, (Object)"Reference from a Class to a Class");
                Reference ref = pnf.getReference();
                Class jormClass = null;
                if (!(ref instanceof ClassRef)) {
                    throw new MedorException("Impossible to navigate with PName:" + ref.getName() + " " + ref.getParent());
                }
                jormClass = ((ClassRef)ref).getMOClass();
                ClassExtent extent = null;
                if (j == path.size() - 2) {
                    logger.log(BasicLevel.DEBUG, (Object)"Extent at the end of the navigation");
                    nodeName = op != 2 ? aliasName : jormClass.getFQName();
                    extent = new ClassExtent(jormClass, nodeName, PNAME_FIELD_NAME + ++pnameFieldNameIndex, false);
                } else {
                    logger.log(BasicLevel.DEBUG, (Object)"Extent in the middle of the navigation");
                    nodeName = jormClass.getFQName();
                    extent = new ClassExtent(jormClass, nodeName, new String[]{fieldName}, true, PNAME_FIELD_NAME + ++pnameFieldNameIndex);
                }
                pnf = (PNameField)extent.getField(extent.getPNameFieldName());
                if (!joinAlreadyConstructed) {
                    logger.log(BasicLevel.DEBUG, (Object)"Constructing new JoinProject");
                    join = new JoinProject("", op != 1);
                    joinAlreadyConstructed = true;
                    join.setQueryFilter(new Equal(new BasicFieldOperand(qtf), new BasicFieldOperand(pnf)));
                } else {
                    join = (JoinProject)qtf.getQueryTree();
                    logger.log(BasicLevel.DEBUG, (Object)("Re-using JoinProject " + join));
                    propagQtf = false;
                    join.setQueryFilter(new And(new Equal(new BasicFieldOperand(((PropagatedField)qtf).getPreviousFields()[0]), new BasicFieldOperand(pnf)), join.getQueryFilter()));
                }
                logger.log(BasicLevel.DEBUG, (Object)"Current qt is:");
                QueryTreePrinter.printQueryTree(qt, logger);
                logger.log(BasicLevel.DEBUG, (Object)"Current join is:");
                QueryTreePrinter.printQueryTree(join, logger);
                Field[] fToAdd = qt.getTupleStructure().getFields();
                logger.log(BasicLevel.DEBUG, (Object)"Adding fields:");
                logger.log(BasicLevel.DEBUG, (Object)("qtf is:" + qtf));
                for (i = 0; i < fToAdd.length; ++i) {
                    if (!propagQtf && qtf == fToAdd[i]) continue;
                    logger.log(BasicLevel.DEBUG, (Object)("\t-" + fToAdd[i].getName()));
                    try {
                        join.getField(fToAdd[i].getName());
                        logger.log(BasicLevel.DEBUG, (Object)"Field already present: not adding.");
                        continue;
                    }
                    catch (MedorException e) {
                        logger.log(BasicLevel.DEBUG, (Object)"Field not present: adding.");
                        join.addPropagatedField(fToAdd[i].getName(), fToAdd[i].getType(), new QueryTreeField[]{(QueryTreeField)fToAdd[i]});
                    }
                }
                fToAdd = extent.getTupleStructure().getFields();
                for (i = 0; i < fToAdd.length; ++i) {
                    logger.log(BasicLevel.DEBUG, (Object)("Adding propagated field " + fToAdd[i].getName()));
                    join.addPropagatedField(fToAdd[i].getName(), fToAdd[i].getType(), new QueryTreeField[]{(QueryTreeField)fToAdd[i]});
                }
                qtf = (QueryTreeField)join.getField(extent.getFieldName(nodeName, fieldName));
                qt = join;
            } else {
                logger.log(BasicLevel.DEBUG, (Object)"Adding the field if not already present");
                if (pnf.isInGenClass()) {
                    throw new MedorException("Impossible to navigate with a multi valued reference");
                }
                logger.log(BasicLevel.DEBUG, (Object)("Checking that " + fieldName + " appears in " + qt));
                String fn = NavigatorNodeFactory.contains(qt.getTupleStructure(), pnf.getQueryTree().getName() + "." + fieldName);
                if (fn != null) {
                    qtf = (QueryTreeField)qt.getTupleStructure().getField(fn);
                } else if (qt instanceof ClassExtent) {
                    ClassExtent extent = (ClassExtent)qt;
                    TypedElement te = ((Class)extent.getMetaObject()).getTypedElement(fieldName);
                    if (te == null) {
                        throw new MedorException("The jorm class " + ((Class)extent.getMetaObject()).getName() + " does not provide a field " + fieldName);
                    }
                    qtf = extent.addField(te);
                } else {
                    throw new MedorException("No field " + fieldName + " found on the query tree " + qt);
                }
            }
            logger.log(BasicLevel.DEBUG, (Object)"Query tree before the end of treatment:");
            QueryTreePrinter.printQueryTree(qt, logger);
            qtf = NavigatorNodeFactory.endOfNavigation(op, qtf, qt, aliasName);
            pnf = NavigatorNodeFactory.getPNameField(qtf);
        }
        return qtf;
    }

    private static QueryTreeField endOfNavigation(byte op, QueryTreeField qtf, QueryTree qt, String aliasName) throws MedorException {
        PNameField pnf = NavigatorNodeFactory.getPNameField(qtf);
        logger.log(BasicLevel.DEBUG, (Object)("Computing the end of navigation with pnf=" + pnf + " for operation " + op));
        if (op != 1 && pnf != null) {
            logger.log(BasicLevel.DEBUG, (Object)("pnf.ref=" + pnf.getReference()));
            if (pnf.getReference() instanceof GenClassRef) {
                JoinProject join;
                GenClassRef gcr = (GenClassRef)pnf.getReference();
                String nodeName = ((Class)gcr.getParent()).getFQName() + "." + gcr.getName();
                GenClassExtent extent = new GenClassExtent(gcr, nodeName, PNAME_FIELD_NAME + ++pnameFieldNameIndex, GENCLASS_ELEMENT_NAME);
                pnf = (PNameField)extent.getField(extent.getPNameFieldName());
                boolean newjoin = false;
                if (qt instanceof JoinProject) {
                    logger.log(BasicLevel.DEBUG, (Object)"Already a join. Propagating right fields only");
                    join = (JoinProject)qt;
                    NavigatorNodeFactory.propagateFieldsRight(extent, join, op, aliasName);
                } else {
                    logger.log(BasicLevel.DEBUG, (Object)"Creating a join. Propagating left and right fields");
                    join = new JoinProject("", op != 1);
                    NavigatorNodeFactory.propagateFieldsLeft(qt, join);
                    NavigatorNodeFactory.propagateFieldsRight(extent, join, op, aliasName);
                    newjoin = true;
                }
                try {
                    switch (op) {
                        case 2: {
                            if (newjoin) {
                                join.setQueryFilter(new Equal(new BasicFieldOperand(qtf), new BasicFieldOperand(pnf)));
                            } else {
                                join.setQueryFilter(new And(join.getQueryFilter(), new Equal(new BasicFieldOperand(((PropagatedField)qtf).getPreviousFields()[0]), new BasicFieldOperand(pnf))));
                            }
                            return (QueryTreeField)join.getField(aliasName == null ? extent.getElementFieldName() : aliasName);
                        }
                        case 8: {
                            if (newjoin) {
                                join.setQueryFilter(new MemberOf(Collections.singletonList(new BasicFieldOperand(qtf)), Collections.singletonList(new BasicFieldOperand(pnf))));
                            } else {
                                join.setQueryFilter(new And(join.getQueryFilter(), new MemberOf(Collections.singletonList(new BasicFieldOperand(((PropagatedField)qtf).getPreviousFields()[0])), Collections.singletonList(new BasicFieldOperand(pnf)))));
                            }
                            return (QueryTreeField)join.getField(qtf.getName());
                        }
                        case 4: {
                            if (newjoin) {
                                join.setQueryFilter(new Not((Expression)new MemberOf(Collections.singletonList(new BasicFieldOperand(qtf)), Collections.singletonList(new BasicFieldOperand(pnf)))));
                            } else {
                                join.setQueryFilter(new And(join.getQueryFilter(), new Not((Expression)new MemberOf(Collections.singletonList(new BasicFieldOperand(((PropagatedField)qtf).getPreviousFields()[0])), Collections.singletonList(new BasicFieldOperand(pnf))))));
                            }
                            return (QueryTreeField)join.getField(qtf.getName());
                        }
                    }
                    throw new MedorException("Operation type not supported: " + op);
                }
                catch (MalformedExpressionException e1) {
                    throw new MedorException(e1);
                }
            }
            if (op == 2 && pnf.getReference() instanceof ClassRef) {
                ClassRef cr = (ClassRef)pnf.getReference();
                String nodeName = (aliasName == null ? cr.getMOClass().getFQName() : aliasName) + "." + cr.getName();
                ClassExtent extent = new ClassExtent(cr.getMOClass(), nodeName, PNAME_FIELD_NAME + ++pnameFieldNameIndex, false);
                pnf = (PNameField)extent.getField(extent.getPNameFieldName());
                JoinProject join = new JoinProject("", op != 1);
                NavigatorNodeFactory.propagateFieldsLeft(qt, join);
                NavigatorNodeFactory.propagateFieldsRight(extent, join, op, null);
                join.setQueryFilter(new Equal(new BasicFieldOperand(qtf), new BasicFieldOperand(pnf)));
                qtf = pnf;
            } else {
                throw new MedorException("Operation type (" + op + ") not supported on the field: " + pnf);
            }
        }
        logger.log(BasicLevel.DEBUG, (Object)"End of navigation");
        return qtf;
    }

    private static void propagateFieldsLeft(QueryTree qt, QueryNode qn) throws MedorException {
        Field[] fToAdd = qt.getTupleStructure().getFields();
        for (int i = 0; i < fToAdd.length; ++i) {
            logger.log(BasicLevel.DEBUG, (Object)("Propagate from left: " + fToAdd[i].getName()));
            qn.addPropagatedField(fToAdd[i].getName(), fToAdd[i].getType(), new QueryTreeField[]{(QueryTreeField)fToAdd[i]});
        }
    }

    private static void propagateFieldsRight(JormExtent extent, QueryNode qn, byte op, String gcElemAlias) throws MedorException {
        if (op == 2) {
            Field[] fToAdd = extent.getTupleStructure().getFields();
            String pnfn = extent.getPNameFieldName();
            String gcElemName = null;
            if (gcElemAlias != null) {
                gcElemName = ((GenClassExtent)extent).getElementFieldName();
            }
            for (int i = 0; i < fToAdd.length; ++i) {
                if (fToAdd[i].getName().equals(pnfn)) continue;
                String fn = fToAdd[i].getName().equals(gcElemName) ? gcElemAlias : fToAdd[i].getName();
                logger.log(BasicLevel.DEBUG, (Object)("Propagate from right: " + fToAdd[i].getName() + " to " + fn));
                qn.addPropagatedField(fn, fToAdd[i].getType(), new QueryTreeField[]{(QueryTreeField)fToAdd[i]});
            }
        }
    }

    private static PNameField getPNameField(Field field) throws MedorException {
        if (field instanceof PNameField) {
            return (PNameField)field;
        }
        if (field instanceof PropagatedField) {
            return NavigatorNodeFactory.getPNameField(((PropagatedField)field).getPreviousFields()[0]);
        }
        return null;
    }

    private static String contains(TupleStructure ts, String fn) {
        String res = ts.contains(fn) ? fn : null;
        int idx = fn.lastIndexOf(".", fn.length());
        while (res == null && idx != -1) {
            res = fn.substring(idx + 1, fn.length());
            res = ts.contains(res) ? res : null;
            idx = fn.lastIndexOf(".", idx - 1);
        }
        return res;
    }

    public static void resetNameIndexes() {
        pnameFieldNameIndex = 0;
    }

    /*
     * WARNING - void declaration
     */
    public static QueryTreeField navigate_old(NavigatorOperator nav, String aliasName, byte op) throws MedorException {
        void var3_7;
        void var8_9;
        boolean propagQtf;
        PNameField pnf;
        QueryTreeField qtf;
        boolean joinAlreadyConstructed = false;
        String fieldName = null;
        try {
            fieldName = ((Operand)nav.getExpression(1)).getString();
        }
        catch (TypingException e) {
            throw new MedorException(e);
        }
        Expression e = nav.getExpression(0);
        logger.log(BasicLevel.DEBUG, (Object)("navigate(" + aliasName + ", " + ExpressionPrinter.e2str(e) + ", " + fieldName + ", op:" + op + ")"));
        if (e instanceof FieldOperand) {
            qtf = (QueryTreeField)((FieldOperand)e).getField();
            pnf = NavigatorNodeFactory.getPNameField(qtf);
            logger.log(BasicLevel.DEBUG, (Object)("Navigation from FieldOperand " + qtf.getName()));
            propagQtf = true;
        } else if (e instanceof NavigatorOperator) {
            logger.log(BasicLevel.DEBUG, (Object)"Navigation from NavigatorOperator");
            Expression el = ((NavigatorOperator)e).getExpression(0);
            propagQtf = el instanceof FieldOperand && NavigatorNodeFactory.getPNameField(((FieldOperand)el).getField()).isClassPName();
            qtf = NavigatorNodeFactory.navigate((NavigatorOperator)e, null, (byte)1);
            pnf = NavigatorNodeFactory.getPNameField(qtf);
            if (qtf.getQueryTree() instanceof JoinProject) {
                joinAlreadyConstructed = true;
            }
            logger.log(BasicLevel.DEBUG, (Object)("Recursive call constructed join ? " + joinAlreadyConstructed));
        } else {
            throw new MedorException("Unknown left operand of the specified NavigatorOperand: " + e);
        }
        logger.log(BasicLevel.DEBUG, (Object)("propagQtf=" + (boolean)var8_9));
        logger.log(BasicLevel.DEBUG, (Object)("qtf=" + qtf.getName() + " of node " + qtf.getQueryTree()));
        if (pnf == null) {
            throw new MedorException("Impossible to find a PNameField");
        }
        QueryTree qt = qtf.getQueryTree();
        if (!pnf.isClassPName()) {
            int i;
            String nodeName;
            logger.log(BasicLevel.DEBUG, (Object)"Reference from a Class to a Class");
            Reference ref = pnf.getReference();
            Class jormClass = null;
            if (!(ref instanceof ClassRef)) {
                throw new MedorException("Impossible to navigate with PName:" + ref.getName() + " " + ref.getParent());
            }
            jormClass = ((ClassRef)ref).getMOClass();
            ClassExtent extent = null;
            if (aliasName != null) {
                nodeName = op != 2 ? aliasName : jormClass.getFQName();
                extent = new ClassExtent(jormClass, nodeName, PNAME_FIELD_NAME + ++pnameFieldNameIndex, false);
            } else {
                nodeName = jormClass.getFQName();
                extent = new ClassExtent(jormClass, nodeName, new String[]{fieldName}, true, PNAME_FIELD_NAME + ++pnameFieldNameIndex);
            }
            pnf = (PNameField)extent.getField(extent.getPNameFieldName());
            JoinProject join = new JoinProject("", op != 1);
            join.setQueryFilter(new Equal(new BasicFieldOperand(qtf), new BasicFieldOperand(pnf)));
            Field[] fToAdd = qt.getTupleStructure().getFields();
            logger.log(BasicLevel.DEBUG, (Object)"Adding fields:");
            for (i = 0; i < fToAdd.length; ++i) {
                if (var8_9 == false && qtf == fToAdd[i]) continue;
                logger.log(BasicLevel.DEBUG, (Object)("\t-" + fToAdd[i].getName()));
                join.addPropagatedField(fToAdd[i].getName(), fToAdd[i].getType(), new QueryTreeField[]{(QueryTreeField)fToAdd[i]});
            }
            fToAdd = extent.getTupleStructure().getFields();
            for (i = 0; i < fToAdd.length; ++i) {
                logger.log(BasicLevel.DEBUG, (Object)("Adding propagated field " + fToAdd[i].getName()));
                join.addPropagatedField(fToAdd[i].getName(), fToAdd[i].getType(), new QueryTreeField[]{(QueryTreeField)fToAdd[i]});
            }
            qtf = (QueryTreeField)join.getField(extent.getFieldName(nodeName, fieldName));
            qt = join;
        } else {
            void var4_8;
            logger.log(BasicLevel.DEBUG, (Object)"Adding the field if not already present");
            if (var4_8.isInGenClass()) {
                throw new MedorException("Impossible to navigate with a multi valued reference");
            }
            logger.log(BasicLevel.DEBUG, (Object)("Checking that " + fieldName + " appears in " + qt));
            String fn = NavigatorNodeFactory.contains(qt.getTupleStructure(), var4_8.getQueryTree().getName() + "." + fieldName);
            if (fn != null) {
                qtf = (QueryTreeField)qt.getTupleStructure().getField(fn);
            } else if (qt instanceof ClassExtent) {
                ClassExtent extent = (ClassExtent)qt;
                TypedElement te = ((Class)extent.getMetaObject()).getTypedElement(fieldName);
                if (te == null) {
                    throw new MedorException("The jorm class " + ((Class)extent.getMetaObject()).getName() + " does not provide a field " + fieldName);
                }
                qtf = extent.addField(te);
            } else {
                throw new MedorException("No field " + fieldName + " found on the query tree " + qt);
            }
        }
        return NavigatorNodeFactory.endOfNavigation(op, (QueryTreeField)var3_7, qt, aliasName);
    }
}

