/*
 * Decompiled with CFR 0.152.
 */
package org.objectweb.medor.query.lib;

import org.objectweb.medor.api.Field;
import org.objectweb.medor.api.MedorException;
import org.objectweb.medor.expression.api.Expression;
import org.objectweb.medor.query.api.QueryTree;
import org.objectweb.medor.query.api.QueryTreeField;
import org.objectweb.medor.query.lib.BasicQueryNode;

public class Union
extends BasicQueryNode {
    public Union() {
    }

    public Union(QueryTree leftQT, QueryTree rightQT, String nodeName) throws MedorException {
        super(nodeName);
        Field[] lfs = leftQT.getTupleStructure().getFields();
        Field[] rfs = rightQT.getTupleStructure().getFields();
        if (lfs.length != rfs.length) {
            throw new MedorException("The union must be with the same Tuple Collection");
        }
        this.indexes = new int[lfs.length];
        for (int i = 0; i < lfs.length; ++i) {
            if (!lfs[i].getName().equalsIgnoreCase(rfs[i].getName())) {
                throw new MedorException("The union must be with the same Tuple Collection: field " + lfs[i].getName() + " of node " + leftQT.getName() + " and field " + rfs[i].getName() + " of node " + rightQT.getName() + " have different name");
            }
            if (!lfs[i].getType().isa(rfs[i].getType()) && !rfs[i].getType().isa(lfs[i].getType())) {
                throw new MedorException("The union must be with the same Tuple Collection: field " + lfs[i].getName() + " of node " + leftQT.getName() + " and field " + rfs[i].getName() + " of node " + rightQT.getName() + " have different type");
            }
            this.addPropagatedField(lfs[i].getName(), lfs[i].getType(), new QueryTreeField[]{(QueryTreeField)lfs[i], (QueryTreeField)rfs[i]});
        }
    }

    public short getType() {
        return 7;
    }

    public void setQueryFilter(Expression e) {
        throw new UnsupportedOperationException("Unions cannot be assigned a filter.");
    }
}

