/*
 * Decompiled with CFR 0.152.
 */
package org.objectweb.perseus.concurrency.optimistic;

import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import org.objectweb.fractal.api.NoSuchInterfaceException;
import org.objectweb.fractal.api.control.BindingController;
import org.objectweb.fractal.api.control.IllegalBindingException;
import org.objectweb.perseus.concurrency.api.ConcurrencyException;
import org.objectweb.perseus.concurrency.api.ConcurrencyManager;
import org.objectweb.perseus.concurrency.lib.Semaphore;
import org.objectweb.perseus.concurrency.lib.TimeStamp;
import org.objectweb.perseus.dependency.api.DependencyGraph;
import org.objectweb.util.monolog.api.Logger;

public class OptimisticConcurrencyManager
implements ConcurrencyManager,
BindingController {
    public static final String DEPENDENCY_GRAPH_BINDING = "dependency-graph";
    private Semaphore sem = new Semaphore();
    protected Logger logger = null;
    private DependencyGraph dg = null;
    protected Map timeStamps = new HashMap();

    public String[] listFc() {
        return new String[]{DEPENDENCY_GRAPH_BINDING};
    }

    public Object lookupFc(String s) {
        if (DEPENDENCY_GRAPH_BINDING.equals(s)) {
            return this.dg;
        }
        return null;
    }

    public void bindFc(String s, Object o) throws IllegalBindingException, NoSuchInterfaceException {
        if ("logger".equals(s)) {
            this.logger = (Logger)o;
        } else if (DEPENDENCY_GRAPH_BINDING.equals(s)) {
            this.dg = (DependencyGraph)o;
        } else {
            throw new NoSuchInterfaceException(s);
        }
    }

    public void unbindFc(String s) {
        if (DEPENDENCY_GRAPH_BINDING.equals(s)) {
            this.dg = null;
        }
    }

    public void begin(Object ctx) {
    }

    public boolean validate(Object ctx) {
        TimeStamp timeStamp;
        this.sem.P();
        Iterator tss = this.timeStamps.values().iterator();
        while (tss.hasNext()) {
            timeStamp = (TimeStamp)tss.next();
            if (timeStamp.validate(ctx)) continue;
            return false;
        }
        tss = this.timeStamps.values().iterator();
        while (tss.hasNext()) {
            timeStamp = (TimeStamp)tss.next();
            timeStamp.finalize(ctx);
        }
        return true;
    }

    public void finalize(Object ctx) {
        this.freeLocks(ctx);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void freeLocks(Object ctx) {
        if (this.sem.getUser() != Thread.currentThread()) {
            throw new RuntimeException("Bad use of the concurrency manager: the validate must be call before the finalize method");
        }
        try {
            Iterator tsIt = this.timeStamps.values().iterator();
            while (tsIt.hasNext()) {
                TimeStamp timeStamp = null;
                timeStamp = (TimeStamp)tsIt.next();
                if (!timeStamp.close(ctx)) continue;
                this.closeTimeStamp(timeStamp, ctx);
                tsIt.remove();
            }
        }
        finally {
            this.sem.V();
        }
    }

    public void closeTimeStamp(TimeStamp timeStamp, Object ctx) {
    }

    public void abort(Object ctx) {
        this.freeLocks(ctx);
    }

    protected Object getResourceId(Object object) {
        return object;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Object readIntention(Object ctx, Object resourceId, Object thinLock, ConcurrencyManager.ResourceProvider resProv, Object resourceHints) throws ConcurrencyException {
        TimeStamp timeStamp;
        this.sem.P();
        TimeStamp timeStamp2 = timeStamp = this.getTimeStamp(resourceId, null);
        synchronized (timeStamp2) {
            this.sem.V();
            timeStamp.readIntention(ctx);
        }
        try {
            if (resProv == null) {
                return null;
            }
            return resProv.getResource(ctx, resourceId, resourceHints, thinLock, false, null, timeStamp);
        }
        catch (ConcurrencyException e) {
            this.removeUnavailableResource(ctx, resourceId, thinLock, timeStamp);
            throw e;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Object writeIntention(Object ctx, Object resource, Object thinLock, ConcurrencyManager.ResourceProvider resProv, Object resourceHints) throws ConcurrencyException {
        Object resourceId = this.getResourceId(resource);
        this.sem.P();
        TimeStamp timeStamp = this.getTimeStamp(resourceId, thinLock);
        boolean isDirtyBefore = timeStamp.isDirty(ctx);
        TimeStamp timeStamp2 = timeStamp;
        synchronized (timeStamp2) {
            this.sem.V();
            timeStamp.writeIntention(ctx);
        }
        try {
            if (resProv == null) {
                return null;
            }
            return resProv.getResource(ctx, resourceId, resourceHints, thinLock, !isDirtyBefore, null, timeStamp.oid);
        }
        catch (ConcurrencyException e) {
            this.removeUnavailableResource(ctx, resourceId, thinLock, timeStamp);
            throw e;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void removeUnavailableResource(Object ctx, Object resourceId, Object thinLock, TimeStamp timeStamp) {
        this.sem.P();
        TimeStamp timeStamp2 = timeStamp;
        synchronized (timeStamp2) {
            if (timeStamp.close(ctx)) {
                this.timeStamps.remove(resourceId);
            }
        }
        this.sem.V();
    }

    private TimeStamp getTimeStamp(Object oid, Object lockHints) {
        TimeStamp timeStamp = (TimeStamp)this.timeStamps.get(oid);
        if (timeStamp == null) {
            timeStamp = new TimeStamp(oid);
            this.timeStamps.put(oid, timeStamp);
        }
        timeStamp.reserve();
        return timeStamp;
    }
}

