/*
 * Decompiled with CFR 0.152.
 */
package org.objectweb.perseus.concurrency.pessimistic;

import org.objectweb.perseus.concurrency.api.ConcurrencyException;
import org.objectweb.perseus.concurrency.pessimistic.Lock;
import org.objectweb.perseus.dependency.api.DependencyGraph;

public final class MutexLock
extends Lock {
    protected Object writer = null;
    int waiter = 0;

    public MutexLock() {
    }

    public MutexLock(Object hints, DependencyGraph dg) {
        super(hints, dg);
    }

    public void readIntention(Object ctxt) throws ConcurrencyException {
        this.writeIntention(ctxt);
    }

    public synchronized void writeIntention(Object ctxt) throws ConcurrencyException {
        boolean ok;
        do {
            boolean bl = ok = this.writer == null || this.writer.equals(ctxt);
            if (ok) continue;
            ++this.waiter;
            try {
                this.wait();
            }
            catch (InterruptedException e) {
                throw new ConcurrencyException("Waiting of a read intention has been interupted: ", e);
            }
            finally {
                --this.waiter;
            }
        } while (!ok);
        --this.reservations;
        this.writer = ctxt;
    }

    public synchronized boolean close(Object ctxt) {
        boolean res;
        if (this.writer != null && this.writer.equals(ctxt)) {
            this.writer = null;
        }
        boolean bl = res = this.reservations == 0 && this.writer == null && this.waiter == 0;
        if (!res) {
            this.notifyAll();
        }
        return res;
    }

    public synchronized byte getMax() {
        if (this.writer != null) {
            return 3;
        }
        return 0;
    }
}

