/*
 * Decompiled with CFR 0.152.
 */
package org.ow2.jonas.generators.genbase.archive;

import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.net.URL;
import java.util.Hashtable;
import java.util.List;
import java.util.Map;
import java.util.Vector;
import javax.xml.parsers.ParserConfigurationException;
import org.objectweb.util.monolog.api.BasicLevel;
import org.ow2.jonas.deployment.common.DeploymentDescException;
import org.ow2.jonas.deployment.ejb.BeanDesc;
import org.ow2.jonas.deployment.ejb.DeploymentDesc;
import org.ow2.jonas.deployment.ejb.lib.EjbDeploymentDescManager;
import org.ow2.jonas.deployment.ws.WSDeploymentDesc;
import org.ow2.jonas.deployment.ws.lib.WSDeploymentDescManager;
import org.ow2.jonas.generators.genbase.GenBaseException;
import org.ow2.jonas.generators.genbase.archive.Application;
import org.ow2.jonas.generators.genbase.archive.Archive;
import org.ow2.jonas.generators.genbase.archive.Ejb;
import org.ow2.jonas.generators.genbase.archive.J2EEArchive;
import org.ow2.jonas.generators.genbase.archive.WsEndpoint;
import org.ow2.jonas.generators.genbase.utils.XMLUtils;
import org.ow2.jonas.lib.loader.EjbJarClassLoader;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.xml.sax.SAXException;

public class EjbJar
extends J2EEArchive
implements WsEndpoint {
    private Application app;
    private WSDeploymentDesc wsDD = null;
    private DeploymentDesc ejbDD = null;
    private List ejbs;
    private Map<String, Document> descriptors;
    private Document jEjbJar;
    private Document jWebservices = null;

    public EjbJar(Archive archive) throws GenBaseException {
        super(archive);
        if (EjbJar.getLogger().isLoggable(BasicLevel.DEBUG)) {
            EjbJar.getLogger().log(BasicLevel.DEBUG, (Object)("Wrapping '" + archive.getName() + "' in EjbJar"));
        }
        this.init();
    }

    public EjbJar(Archive archive, Application app) throws GenBaseException {
        super(archive);
        this.setApplication(app);
        if (EjbJar.getLogger().isLoggable(BasicLevel.DEBUG)) {
            EjbJar.getLogger().log(BasicLevel.DEBUG, (Object)("Wrapping '" + archive.getName() + "' in EjbJar"));
        }
        this.init();
    }

    private void init() throws GenBaseException {
        this.loadDescriptors();
    }

    public void initialize() throws GenBaseException {
        try {
            if (this.app == null) {
                this.setModuleClassloader((ClassLoader)new EjbJarClassLoader(new URL[]{this.getArchive().getRootFile().toURL()}, Thread.currentThread().getContextClassLoader()));
            } else {
                this.setModuleClassloader(this.app.getEJBClassLoader());
            }
        }
        catch (IOException ioe) {
            String err = EjbJar.getI18n().getMessage("EjbJar.init.loader", (Object)this.getArchive().getRootFile());
            throw new GenBaseException(err, ioe);
        }
        try {
            this.ejbDD = EjbDeploymentDescManager.getDeploymentDesc((String)this.getRootFile().getAbsolutePath(), (ClassLoader)this.getModuleClassloader());
        }
        catch (DeploymentDescException dde) {
            throw new GenBaseException((Exception)((Object)dde));
        }
        try {
            this.wsDD = WSDeploymentDescManager.getDeploymentDesc((String)this.getRootFile().getAbsolutePath(), (ClassLoader)this.getModuleClassloader());
        }
        catch (DeploymentDescException dde) {
            throw new GenBaseException((Exception)((Object)dde));
        }
        this.ejbs = new Vector();
        BeanDesc[] bd = this.ejbDD.getBeanDesc();
        for (int i = 0; i < bd.length; ++i) {
            Element jElement = null;
            if (this.jEjbJar != null) {
                jElement = XMLUtils.getBeanElement(this.jEjbJar.getDocumentElement(), bd[i].getEjbName());
            }
            this.ejbs.add(new Ejb(bd[i], jElement));
        }
    }

    private void loadDescriptors() throws GenBaseException {
        InputStream jonasEJBXMLIS = null;
        InputStream isJws = null;
        try {
            jonasEJBXMLIS = this.getJonasEjbJarInputStream();
            if (jonasEJBXMLIS != null) {
                this.jEjbJar = XMLUtils.newDocument(jonasEJBXMLIS, "META-INF/jonas-ejb-jar.xml", this.isDTDsAllowed());
            }
            if ((isJws = this.getJonasWebservicesInputStream()) != null) {
                this.jWebservices = XMLUtils.newDocument(isJws, "META-INF/jonas-webservices.xml", this.isDTDsAllowed());
            }
        }
        catch (SAXException saxe) {
            String err = EjbJar.getI18n().getMessage("EjbJar.loadDescriptors.parseError");
            throw new GenBaseException(err, saxe);
        }
        catch (ParserConfigurationException pce) {
            String err = EjbJar.getI18n().getMessage("EjbJar.loadDescriptors.prepare");
            throw new GenBaseException(err, pce);
        }
        catch (IOException ioe) {
            String err = EjbJar.getI18n().getMessage("EjbJar.loadDescriptors.parseError");
            throw new GenBaseException(err, ioe);
        }
        this.descriptors = new Hashtable<String, Document>();
        if (this.jEjbJar != null) {
            this.descriptors.put("META-INF/jonas-ejb-jar.xml", this.jEjbJar);
        }
    }

    public List getEjbs() {
        return this.ejbs;
    }

    public List getServiceDescs() {
        if (this.wsDD != null) {
            return this.wsDD.getServiceDescs();
        }
        return new Vector();
    }

    public void addClasses(File classes) {
        this.addDirectory(classes);
    }

    public String getWarName() {
        if (this.wsDD != null) {
            return this.wsDD.getWarFile();
        }
        return null;
    }

    public String getContextRoot() {
        String croot;
        String archiveName = this.getArchive().getName();
        String root = null;
        root = archiveName.toLowerCase().endsWith(".jar") ? archiveName.toLowerCase().substring(0, archiveName.length() - ".jar".length()) : archiveName;
        if (this.wsDD != null && (croot = this.wsDD.getContextRoot()) != null) {
            root = croot;
        }
        if (EjbJar.getLogger().isLoggable(BasicLevel.DEBUG)) {
            EjbJar.getLogger().log(BasicLevel.DEBUG, (Object)("Computed context root : " + root));
        }
        return root;
    }

    public void setApplication(Application app) {
        this.app = app;
    }

    public Application getApplication() {
        return this.app;
    }

    public Map getDescriptors() {
        return this.descriptors;
    }

    public boolean omit(String name) {
        return name.equals("META-INF/jonas-ejb-jar.xml") || name.equals("META-INF\\jonas-ejb-jar.xml");
    }

    public Document getJonasEjbJarDoc() {
        return this.jEjbJar;
    }

    public Document getJonasWebservicesDoc() {
        return this.jWebservices;
    }

    public InputStream getJonasEjbJarInputStream() throws IOException {
        InputStream is = null;
        is = this.isPacked() ? this.getInputStream("META-INF/jonas-ejb-jar.xml") : this.getInputStream("META-INF" + File.separator + "jonas-ejb-jar.xml");
        return is;
    }

    public InputStream getJonasWebservicesInputStream() throws IOException {
        InputStream is = null;
        is = this.isPacked() ? this.getInputStream("META-INF/jonas-webservices.xml") : this.getInputStream("META-INF" + File.separator + "jonas-webservices.xml");
        return is;
    }
}

