/*
 * Decompiled with CFR 0.152.
 */
package org.ow2.jonas.jmx.internal;

import java.lang.reflect.Method;
import java.net.URI;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.Properties;
import javax.management.ObjectName;
import javax.management.remote.JMXConnectorFactory;
import javax.management.remote.JMXConnectorServer;
import javax.management.remote.JMXConnectorServerFactory;
import javax.management.remote.JMXServiceURL;
import javax.management.remote.MBeanServerForwarder;
import javax.naming.NameAlreadyBoundException;
import org.objectweb.util.monolog.api.BasicLevel;
import org.objectweb.util.monolog.api.Logger;
import org.ow2.jonas.jmx.internal.BaseJMXService;
import org.ow2.jonas.lib.bootstrap.JProp;
import org.ow2.jonas.lib.execution.ExecutionResult;
import org.ow2.jonas.lib.execution.IExecution;
import org.ow2.jonas.lib.execution.RunnableHelper;
import org.ow2.jonas.lib.util.JonasObjectName;
import org.ow2.jonas.lib.util.Log;
import org.ow2.jonas.naming.JNamingManager;
import org.ow2.jonas.registry.RegistryService;
import org.ow2.jonas.security.auth.spi.RoleBasedAuthorizationModule;
import org.ow2.jonas.service.JonasAlreadyStartedException;
import org.ow2.jonas.service.ServiceException;

public class JOnASJMXService
extends BaseJMXService {
    private static Logger logger = Log.getLogger((String)"org.ow2.jonas.jmx");
    private static final String MX4J_COMMONS_LOGGER_CLASSNAME = "mx4j.log.CommonsLogger";
    private static final String MX4J_LOG_CLASSNAME = "mx4j.log.Log";
    private static final String MX4J_LOGGER_CLASS = "mx4j.log.Logger";
    private JMXConnectorServer[] connectorServers = null;
    private JMXServiceURL[] connectorServerURLs = null;
    private RegistryService registryService = null;
    private List<ObjectName> connectorObjectNames = null;
    private JNamingManager namingManager = null;
    private boolean jmxSecured = false;
    private String authenticationMethod = null;
    private String authenticationParameter = null;
    private String authorizationMethod = null;
    private String authorizationParameter = null;

    private void initializeMX4JLoggingSystem() {
        block6: {
            Class<?> mx4jCommonsLoggerClass = null;
            try {
                ClassLoader loader = Thread.currentThread().getContextClassLoader();
                mx4jCommonsLoggerClass = loader.loadClass(MX4J_COMMONS_LOGGER_CLASSNAME);
                if (logger.isLoggable(BasicLevel.DEBUG)) {
                    logger.log(BasicLevel.DEBUG, (Object)"Class mx4j.log.CommonsLogger founded");
                }
                Object o = mx4jCommonsLoggerClass.newInstance();
                Class<?> clazz = loader.loadClass(MX4J_LOG_CLASSNAME);
                Class<?> mx4jLoggerClass = loader.loadClass(MX4J_LOGGER_CLASS);
                Method m = clazz.getMethod("redirectTo", mx4jLoggerClass);
                m.invoke(clazz, o);
                if (logger.isLoggable(BasicLevel.DEBUG)) {
                    logger.log(BasicLevel.DEBUG, (Object)"MX4J logging redirected to the Jakarta commons logger");
                }
            }
            catch (ClassNotFoundException cnfe) {
                if (logger.isLoggable(BasicLevel.DEBUG)) {
                    logger.log(BasicLevel.DEBUG, (Object)("Class mx4j.log.CommonsLogger not found: " + cnfe));
                }
            }
            catch (Exception e) {
                if (!logger.isLoggable(BasicLevel.WARN)) break block6;
                logger.log(BasicLevel.WARN, (Object)("Problem with mx4j.log.CommonsLogger instance creation " + e));
            }
        }
    }

    public void doStart() throws ServiceException {
        logger.log(BasicLevel.DEBUG, (Object)"Starting JMX Service");
        this.initializeMX4JLoggingSystem();
        super.doStart();
        String serverName = this.getJonasServerName();
        if (serverName == null) {
            throw new ServiceException("Cannot start JMX service. No serverName.");
        }
        String defaultProtocolName = this.registryService.getDefaultProtocolName();
        try {
            List protocols = this.registryService.getActiveProtocolNames();
            int nbProtocols = protocols.size();
            this.connectorServerURLs = new JMXServiceURL[nbProtocols];
            this.connectorServers = new JMXConnectorServer[nbProtocols];
            this.connectorObjectNames = new ArrayList<ObjectName>();
            int index = 0;
            for (String name : protocols) {
                String connectorName = null;
                this.registryService.setDefaultProtocol(name);
                String protocol = "rmi";
                URI carolURL = this.registryService.getProviderURL(name);
                String scheme = carolURL.getScheme();
                String host = carolURL.getHost();
                int port = this.registryService.getExportedObjectPort(name);
                String ictxFactory = this.registryService.getInitialContextFactoryName(name);
                Properties props = new Properties();
                props.put("jmx.remote.jndi.rebind", "true");
                props.put("java.naming.factory.initial", ictxFactory);
                props.put("java.naming.provider.url", carolURL.toString());
                JMXServiceURL serviceURL = null;
                if (name.equals("jrmp")) {
                    connectorName = "jrmpconnector_" + serverName;
                } else if (name.equals("irmi")) {
                    connectorName = "irmiconnector_" + serverName;
                    if (port != 0) {
                        ++port;
                    }
                } else {
                    if (!name.equals("iiop")) continue;
                    connectorName = "iiopconnector_" + serverName;
                    protocol = "iiop";
                    Object orb = null;
                    IExecution<Object> exec = new IExecution<Object>(){

                        public Object execute() throws Exception {
                            return JOnASJMXService.this.getNamingManager().getInitialContext().lookup("java:comp/ORB");
                        }
                    };
                    ExecutionResult res = RunnableHelper.execute((ClassLoader)((Object)((Object)this)).getClass().getClassLoader(), (IExecution)exec);
                    if (res.hasException()) {
                        throw res.getException();
                    }
                    orb = res.getResult();
                    props.put("java.naming.corba.orb", orb);
                }
                MBeanServerForwarder forwarder = null;
                if (this.jmxSecured) {
                    String fileSeparator = System.getProperty("file.separator");
                    if (this.authenticationMethod != null && this.authenticationParameter != null) {
                        if ("jmx.remote.x.password.file".equals(this.authenticationMethod)) {
                            props.put(this.authenticationMethod, JProp.getJonasBase() + fileSeparator + this.authenticationParameter);
                        } else {
                            props.put(this.authenticationMethod, this.authenticationParameter);
                        }
                    }
                    if (this.authorizationMethod != null && this.authorizationParameter != null) {
                        if (this.authorizationMethod.startsWith("jmx.remote.x.access.rolebased")) {
                            long timeout = System.currentTimeMillis() + 10000L;
                            NoClassDefFoundError lastCause = null;
                            while (System.currentTimeMillis() < timeout) {
                                try {
                                    forwarder = RoleBasedAuthorizationModule.newProxyInstance((String)this.authorizationMethod.substring("jmx.remote.x.access.rolebased".length() + 1), (String)this.authorizationParameter);
                                    break;
                                }
                                catch (NoClassDefFoundError e) {
                                    lastCause = e;
                                    Thread.sleep(1000L);
                                }
                            }
                            if (forwarder == null) {
                                throw new ServiceException("Role-based JMX security authorization cannot be initialized. Please make sure the JOnAS security service is enabled.", (Throwable)lastCause);
                            }
                        } else if ("jmx.remote.x.access.file".equals(this.authorizationMethod)) {
                            props.put(this.authorizationMethod, JProp.getJonasBase() + fileSeparator + this.authorizationParameter);
                        } else {
                            props.put(this.authorizationMethod, this.authorizationParameter);
                        }
                    }
                }
                serviceURL = new JMXServiceURL(protocol, host, port, "/jndi/" + carolURL.toString() + "/" + connectorName);
                JMXConnectorServer connectorServer = JMXConnectorServerFactory.newJMXConnectorServer(serviceURL, props, null);
                if (forwarder != null) {
                    connectorServer.setMBeanServerForwarder(forwarder);
                    try {
                        if (forwarder.getMBeanServer() == null) {
                            throw new IllegalStateException();
                        }
                    }
                    catch (IllegalStateException e) {
                        logger.log(BasicLevel.DEBUG, (Object)("Setting the forwarder's MBeanServer to " + this.getJmxServer()));
                        forwarder.setMBeanServer(this.getJmxServer());
                    }
                }
                this.connectorServers[index] = connectorServer;
                String connectorObjectName = "connector_" + name;
                ObjectName connectorServerName = JonasObjectName.jmxConnectorServer((String)scheme, (String)connectorObjectName);
                this.connectorObjectNames.add(connectorServerName);
                if (this.getJmxServer().isRegistered(connectorServerName)) {
                    this.getJmxServer().unregisterMBean(connectorServerName);
                }
                this.getJmxServer().registerMBean(connectorServer, connectorServerName);
                final int idx = index++;
                final JMXConnectorServer server = connectorServer;
                IExecution<Void> exec = new IExecution<Void>(){

                    public Void execute() throws Exception {
                        server.start();
                        ((JOnASJMXService)JOnASJMXService.this).connectorServerURLs[idx] = server.getAddress();
                        if (JOnASJMXService.this.jmxSecured) {
                            try {
                                JMXConnectorFactory.connect(JOnASJMXService.this.connectorServerURLs[idx]).close();
                                logger.log(BasicLevel.WARN, (Object)"JMX security is enabled but anonymous logins are still accepted! Please check your JMX security configuration.");
                            }
                            catch (SecurityException e) {
                                logger.log(BasicLevel.INFO, (Object)"JMX security is enabled and active");
                            }
                        } else {
                            logger.log(BasicLevel.INFO, (Object)"JMX security is disabled");
                        }
                        return null;
                    }
                };
                System.setProperty("carol.multipro.protocol", name);
                ExecutionResult res = RunnableHelper.execute((ClassLoader)JOnASJMXService.class.getClassLoader(), (IExecution)exec);
                System.setProperty("carol.multipro.protocol", "any");
                if (!res.hasException()) continue;
                throw res.getException();
            }
        }
        catch (NameAlreadyBoundException ne) {
            logger.log(BasicLevel.DEBUG, (Object)("Cannot start JMX service " + ne));
            throw new JonasAlreadyStartedException();
        }
        catch (Exception e) {
            throw new ServiceException("Cannot start JMX service", (Throwable)e);
        }
        finally {
            this.registryService.setDefaultProtocol(defaultProtocolName);
        }
        String jmxConnectors = null;
        jmxConnectors = this.connectorServerURLs != null && this.connectorServerURLs.length == 1 && this.connectorServerURLs[0] == null ? ". No JMX Connector." : " using connector(s)" + Arrays.asList(this.connectorServerURLs);
        logger.log(BasicLevel.INFO, (Object)("JMX Service started" + jmxConnectors));
    }

    public void doStop() {
        super.doStop();
        logger.log(BasicLevel.DEBUG, (Object)"Stopping JMX Service");
        if (this.connectorObjectNames != null) {
            for (final ObjectName name : this.connectorObjectNames) {
                try {
                    IExecution<Void> exec = new IExecution<Void>(){

                        public Void execute() throws Exception {
                            JOnASJMXService.this.getJmxServer().unregisterMBean(name);
                            return null;
                        }
                    };
                    String protocol = name.getKeyProperty("protocol");
                    System.setProperty("carol.multipro.protocol", protocol);
                    ExecutionResult result = RunnableHelper.execute((ClassLoader)((Object)((Object)this)).getClass().getClassLoader(), (IExecution)exec);
                    System.setProperty("carol.multipro.protocol", "any");
                    if (!result.hasException()) continue;
                    throw result.getException();
                }
                catch (Exception e) {
                    logger.log(BasicLevel.ERROR, (Object)("Cannot unregister Connector MBean for '" + name + "'"), (Throwable)e);
                }
            }
        }
        if (this.connectorServers != null) {
            for (int i = 0; i < this.connectorServers.length; ++i) {
                try {
                    this.connectorServers[i].stop();
                    continue;
                }
                catch (Exception e) {
                    logger.log(BasicLevel.INFO, (Object)"Cannot Stop JMX Connector", (Throwable)e);
                }
            }
        }
        logger.log(BasicLevel.INFO, (Object)"JMX Service stopped");
    }

    public JMXServiceURL[] getConnectorServerURLs() {
        return this.connectorServerURLs;
    }

    public void setRegistryService(RegistryService registryService) {
        this.registryService = registryService;
    }

    public JNamingManager getNamingManager() {
        return this.namingManager;
    }

    public void setNamingManager(JNamingManager namingManager) {
        this.namingManager = namingManager;
    }

    public void setJmxSecured(boolean jmxSecured) {
        this.jmxSecured = jmxSecured;
    }

    public void setAuthenticationMethod(String authenticationMethod) {
        this.authenticationMethod = authenticationMethod;
    }

    public void setAuthenticationParameter(String authenticationParameter) {
        this.authenticationParameter = authenticationParameter;
    }

    public void setAuthorizationMethod(String authorizationMethod) {
        this.authorizationMethod = authorizationMethod;
    }

    public void setAuthorizationParameter(String authorizationParameter) {
        this.authorizationParameter = authorizationParameter;
    }
}

