/*
 * Decompiled with CFR 0.152.
 */
package org.ow2.jonas.lib.security.jacc;

import java.security.SecurityPermission;
import java.util.HashMap;
import java.util.Map;
import javax.security.jacc.PolicyConfiguration;
import javax.security.jacc.PolicyConfigurationFactory;
import javax.security.jacc.PolicyContextException;
import org.objectweb.util.monolog.api.BasicLevel;
import org.objectweb.util.monolog.api.Logger;
import org.ow2.jonas.lib.security.jacc.JPolicyConfiguration;
import org.ow2.jonas.lib.util.I18n;
import org.ow2.jonas.lib.util.Log;

public class JPolicyConfigurationFactory
extends PolicyConfigurationFactory {
    private static I18n i18n = I18n.getInstance(JPolicyConfigurationFactory.class);
    private Map policyConfigurations = new HashMap();
    private static Logger logger = Log.getLogger((String)"org.ow2.jonas.security");

    public PolicyConfiguration getPolicyConfiguration(String contextID, boolean remove) throws PolicyContextException, SecurityException {
        this.checkSetPolicy();
        PolicyConfiguration policyConfiguration = this.getInternalPolicyConfiguration(contextID);
        if (policyConfiguration != null) {
            if (remove) {
                policyConfiguration.delete();
                ((JPolicyConfiguration)policyConfiguration).resetState();
            }
            return policyConfiguration;
        }
        policyConfiguration = new JPolicyConfiguration(contextID);
        this.policyConfigurations.put(contextID, policyConfiguration);
        return policyConfiguration;
    }

    private synchronized PolicyConfiguration getInternalPolicyConfiguration(String contextID) {
        return (PolicyConfiguration)this.policyConfigurations.get(contextID);
    }

    public boolean inService(String contextID) throws PolicyContextException, SecurityException {
        if (logger.isLoggable(BasicLevel.DEBUG)) {
            logger.log(BasicLevel.DEBUG, (Object)"Check setpolicy...");
        }
        this.checkSetPolicy();
        if (logger.isLoggable(BasicLevel.DEBUG)) {
            logger.log(BasicLevel.DEBUG, (Object)"Context exist ?");
        }
        if (this.policyConfigurations.containsKey(contextID)) {
            if (logger.isLoggable(BasicLevel.DEBUG)) {
                logger.log(BasicLevel.DEBUG, (Object)"Look internal config...");
            }
            return this.getInternalPolicyConfiguration(contextID).inService();
        }
        if (logger.isLoggable(BasicLevel.DEBUG)) {
            logger.log(BasicLevel.DEBUG, (Object)"Policy configuration not found, return false");
        }
        return false;
    }

    private void checkSetPolicy() throws SecurityException {
        SecurityManager securityManager = System.getSecurityManager();
        if (securityManager != null) {
            securityManager.checkPermission(new SecurityPermission("setPolicy"));
        }
    }
}

