/*
 * Decompiled with CFR 0.152.
 */
package org.ow2.jonas.security.internal.realm.factory;

import java.security.NoSuchAlgorithmException;
import java.text.MessageFormat;
import java.util.ArrayList;
import java.util.Enumeration;
import java.util.Hashtable;
import java.util.Iterator;
import java.util.Vector;
import javax.naming.AuthenticationException;
import javax.naming.Name;
import javax.naming.NameParser;
import javax.naming.NamingEnumeration;
import javax.naming.NamingException;
import javax.naming.Reference;
import javax.naming.StringRefAddr;
import javax.naming.directory.Attribute;
import javax.naming.directory.Attributes;
import javax.naming.directory.DirContext;
import javax.naming.directory.InitialDirContext;
import javax.naming.directory.SearchControls;
import javax.naming.directory.SearchResult;
import org.objectweb.util.monolog.api.BasicLevel;
import org.ow2.jonas.security.internal.realm.factory.AbstractJResource;
import org.ow2.jonas.security.internal.realm.lib.HashHelper;
import org.ow2.jonas.security.internal.realm.principal.LDAPUser;
import org.ow2.jonas.security.realm.factory.JResourceException;
import org.ow2.jonas.security.realm.principal.JUser;

public class JResourceLDAP
extends AbstractJResource {
    private static final String FACTORY_TYPE = "org.ow2.jonas.security.realm.factory.JResourceLDAP";
    private static final String FACTORY_NAME = "org.ow2.jonas.security.realm.factory.JResourceLDAPFactory";
    private static final String BIND_AUTHENTICATION_MODE = "bind";
    private static final String COMPARE_AUTHENTICATION_MODE = "compare";
    private String initialContextFactory = null;
    private String providerUrl = null;
    private String securityAuthentication = null;
    private String securityPrincipal = null;
    private String securityCredentials = null;
    private String securityProtocol = null;
    private String language = null;
    private String referral = null;
    private String stateFactories = null;
    private String authenticationMode = null;
    private String userPasswordAttribute = null;
    private String userRolesAttribute = null;
    private String roleNameAttribute = null;
    private String baseDN = null;
    private String userDN = null;
    private String userSearchFilter = null;
    private String roleDN = null;
    private String roleSearchFilter = null;
    private static final String ROLEDN_EMPTY = "EMPTY";
    private String algorithm = null;

    public JUser findUser(String username) throws JResourceException {
        if (username == null) {
            return null;
        }
        LDAPUser user = new LDAPUser();
        user.setName(username);
        try {
            Attributes userAttributes;
            NamingEnumeration<SearchResult> answer;
            DirContext dirContext = this.getDirContext();
            SearchControls sctls = new SearchControls();
            String[] attributes = null;
            attributes = this.authenticationMode.equals(COMPARE_AUTHENTICATION_MODE) ? new String[]{this.userPasswordAttribute, this.userRolesAttribute} : new String[]{};
            sctls.setReturningAttributes(attributes);
            sctls.setSearchScope(2);
            if (JResourceLDAP.getLogger().isLoggable(BasicLevel.DEBUG)) {
                JResourceLDAP.getLogger().log(BasicLevel.DEBUG, (Object)("userDN = '" + this.userDN + "'"));
                JResourceLDAP.getLogger().log(BasicLevel.DEBUG, (Object)("baseDN = '" + this.baseDN + "'"));
            }
            String lookupUserDN = null;
            lookupUserDN = this.userDN != null && !this.userDN.equals("") ? this.userDN.concat(",").concat(this.baseDN) : this.baseDN;
            Object[] arguments = new Object[]{username};
            lookupUserDN = MessageFormat.format(lookupUserDN, arguments);
            if (JResourceLDAP.getLogger().isLoggable(BasicLevel.DEBUG)) {
                JResourceLDAP.getLogger().log(BasicLevel.DEBUG, (Object)("lookupUserDN = '" + lookupUserDN + "'"));
            }
            if (JResourceLDAP.getLogger().isLoggable(BasicLevel.DEBUG)) {
                JResourceLDAP.getLogger().log(BasicLevel.DEBUG, (Object)("search : lookupUserDN = '" + lookupUserDN + "', searchFilter = '" + this.userSearchFilter + "', username = '" + username + "'"));
            }
            if ((answer = dirContext.search(lookupUserDN, this.userSearchFilter, new Object[]{username}, sctls)) == null || !answer.hasMore()) {
                if (JResourceLDAP.getLogger().isLoggable(BasicLevel.DEBUG)) {
                    if (answer == null) {
                        JResourceLDAP.getLogger().log(BasicLevel.DEBUG, (Object)"answer is null");
                    } else {
                        JResourceLDAP.getLogger().log(BasicLevel.DEBUG, (Object)"no anwser");
                    }
                }
                return null;
            }
            SearchResult firstAnswer = answer.next();
            if (answer.hasMore()) {
                return null;
            }
            NameParser nameParser = dirContext.getNameParser("");
            Name contextName = nameParser.parse(dirContext.getNameInNamespace());
            Name baseDNName = contextName.addAll(nameParser.parse(lookupUserDN));
            Name userFullDN = baseDNName.addAll(nameParser.parse(firstAnswer.getName()));
            user.setDN(userFullDN.toString());
            if (JResourceLDAP.getLogger().isLoggable(BasicLevel.DEBUG)) {
                JResourceLDAP.getLogger().log(BasicLevel.DEBUG, (Object)("DN found : '" + userFullDN + "'"));
            }
            if ((userAttributes = firstAnswer.getAttributes()) == null) {
                if (JResourceLDAP.getLogger().isLoggable(BasicLevel.DEBUG)) {
                    JResourceLDAP.getLogger().log(BasicLevel.DEBUG, (Object)"No user attributes found");
                }
                return null;
            }
            String password = null;
            if (this.authenticationMode.equals(COMPARE_AUTHENTICATION_MODE) && (password = this.readValueFromAttribute(this.userPasswordAttribute, userAttributes)) != null) {
                user.setPassword(password);
            }
            String roles = this.readValuesFromAttribute(this.userRolesAttribute, userAttributes);
            user.setRoles(roles);
        }
        catch (NamingException ne) {
            throw new JResourceException("Could not find user :" + ne.getMessage());
        }
        return user;
    }

    public boolean isValidUser(JUser user, String credentials) {
        if (credentials == null || user == null) {
            return false;
        }
        if (this.authenticationMode.equals(COMPARE_AUTHENTICATION_MODE)) {
            if (JResourceLDAP.getLogger().isLoggable(BasicLevel.DEBUG)) {
                JResourceLDAP.getLogger().log(BasicLevel.DEBUG, (Object)"Compare mode");
            }
            return this.isValidUserCompare(user, credentials);
        }
        if (this.authenticationMode.equals(BIND_AUTHENTICATION_MODE)) {
            if (JResourceLDAP.getLogger().isLoggable(BasicLevel.DEBUG)) {
                JResourceLDAP.getLogger().log(BasicLevel.DEBUG, (Object)"Bind mode");
            }
            return this.isValidUserBind(user, credentials);
        }
        if (JResourceLDAP.getLogger().isLoggable(BasicLevel.DEBUG)) {
            JResourceLDAP.getLogger().log(BasicLevel.DEBUG, (Object)"No authentication mode found, return false");
        }
        return false;
    }

    public boolean isValidUserBind(JUser user, String credentials) {
        if (!(user instanceof LDAPUser)) {
            if (JResourceLDAP.getLogger().isLoggable(BasicLevel.DEBUG)) {
                JResourceLDAP.getLogger().log(BasicLevel.DEBUG, (Object)"Not instance of LDAPUser");
            }
            return false;
        }
        String dn = ((LDAPUser)user).getDN();
        if (dn == null) {
            if (JResourceLDAP.getLogger().isLoggable(BasicLevel.DEBUG)) {
                JResourceLDAP.getLogger().log(BasicLevel.DEBUG, (Object)"No DN found in User");
            }
            return false;
        }
        Hashtable env = this.getEnvInitialDirContext();
        env.put("java.naming.security.principal", dn);
        env.put("java.naming.security.credentials", credentials);
        boolean validated = false;
        try {
            InitialDirContext dirContext = new InitialDirContext(env);
            validated = true;
            dirContext.close();
        }
        catch (AuthenticationException e) {
            JResourceLDAP.getLogger().log(BasicLevel.ERROR, (Object)("Can't make an initial dir context : " + e.getMessage()));
        }
        catch (NamingException ne) {
            JResourceLDAP.getLogger().log(BasicLevel.ERROR, (Object)("Naming exception " + ne.getMessage()));
        }
        return validated;
    }

    public boolean isValidUserCompare(JUser user, String credentials) {
        boolean validated = false;
        if (user != null && user.getHashPassword() == null) {
            String errMsg = "No password for the user so it cannot perform a check.";
            errMsg = errMsg + " Check that you are using the correct mode ('compare' or 'bind').";
            errMsg = errMsg + " By using compare mode, the anonymous user cannot retrieved password in many cases.";
            JResourceLDAP.getLogger().log(BasicLevel.ERROR, (Object)errMsg);
            return validated;
        }
        String pass = user.getHashPassword().getPassword();
        String algo = user.getHashPassword().getAlgorithm();
        if (algo != null && pass != null) {
            try {
                validated = HashHelper.hashPassword(credentials, algo).equalsIgnoreCase(pass);
            }
            catch (NoSuchAlgorithmException nsae) {
                JResourceLDAP.getLogger().log(BasicLevel.ERROR, (Object)("Can't make a password with the algorithm " + algo + ". " + nsae.getMessage()));
            }
        } else if (this.algorithm != null && !this.algorithm.equals("")) {
            try {
                validated = HashHelper.hashPassword(credentials, this.algorithm).equalsIgnoreCase(pass);
            }
            catch (NoSuchAlgorithmException nsae) {
                JResourceLDAP.getLogger().log(BasicLevel.ERROR, (Object)("Can't make a password with the algorithm " + this.algorithm + ". " + nsae.getMessage()));
            }
        } else {
            validated = credentials.equals(pass);
        }
        return validated;
    }

    public ArrayList getArrayListCombinedRoles(JUser user) throws JResourceException {
        ArrayList<String> allCombinedRoles = new ArrayList<String>();
        if (user == null) {
            if (JResourceLDAP.getLogger().isLoggable(BasicLevel.DEBUG)) {
                JResourceLDAP.getLogger().log(BasicLevel.DEBUG, (Object)"User is empty, return empty array of roles");
            }
            return allCombinedRoles;
        }
        String[] userRoles = user.getArrayRoles();
        for (int r = 0; r < userRoles.length; ++r) {
            String roleName = userRoles[r];
            if (allCombinedRoles.contains(roleName)) continue;
            allCombinedRoles.add(roleName);
        }
        if (!(user instanceof LDAPUser)) {
            return allCombinedRoles;
        }
        String dn = ((LDAPUser)user).getDN();
        if (dn == null) {
            if (JResourceLDAP.getLogger().isLoggable(BasicLevel.DEBUG)) {
                JResourceLDAP.getLogger().log(BasicLevel.DEBUG, (Object)"DN of user is empty, return empty array of roles");
            }
            return allCombinedRoles;
        }
        try {
            NamingEnumeration<SearchResult> answers;
            DirContext dirContext = this.getDirContext();
            SearchControls sctls = new SearchControls();
            String[] attributes = new String[]{this.roleNameAttribute};
            sctls.setReturningAttributes(attributes);
            sctls.setSearchScope(2);
            if (JResourceLDAP.getLogger().isLoggable(BasicLevel.DEBUG)) {
                JResourceLDAP.getLogger().log(BasicLevel.DEBUG, (Object)("roleDN = '" + this.roleDN + "'"));
                JResourceLDAP.getLogger().log(BasicLevel.DEBUG, (Object)("baseDN = '" + this.baseDN + "'"));
            }
            String lookupRoleDN = null;
            lookupRoleDN = this.roleDN != null && !this.roleDN.equals("") ? (ROLEDN_EMPTY.equals(this.roleDN) ? "" : this.roleDN.concat(",").concat(this.baseDN)) : this.baseDN;
            if (JResourceLDAP.getLogger().isLoggable(BasicLevel.DEBUG)) {
                JResourceLDAP.getLogger().log(BasicLevel.DEBUG, (Object)("search with lookupRoleDN = '" + lookupRoleDN + "', rolesearchFilter = '" + this.roleSearchFilter + "', dn = '" + dn + "'"));
            }
            if ((answers = dirContext.search(lookupRoleDN, this.roleSearchFilter, new Object[]{dn}, sctls)) == null) {
                if (JResourceLDAP.getLogger().isLoggable(BasicLevel.DEBUG)) {
                    JResourceLDAP.getLogger().log(BasicLevel.DEBUG, (Object)"answer is null");
                }
                return allCombinedRoles;
            }
            Vector vRoles = new Vector();
            while (answers.hasMore()) {
                SearchResult answer = answers.next();
                Attributes roleAttributes = answer.getAttributes();
                if (roleAttributes == null) continue;
                this.addValueFromAttributeToVector(this.roleNameAttribute, roleAttributes, vRoles);
            }
            Enumeration e = vRoles.elements();
            while (e.hasMoreElements()) {
                String roleName = (String)e.nextElement();
                if (allCombinedRoles.contains(roleName)) continue;
                allCombinedRoles.add(roleName);
            }
        }
        catch (NamingException ne) {
            throw new JResourceException("Could not find roles from the user :" + ne.getMessage());
        }
        user.setCombinedRoles(allCombinedRoles);
        if (JResourceLDAP.getLogger().isLoggable(BasicLevel.DEBUG)) {
            StringBuffer rolesStr = new StringBuffer();
            Iterator it = allCombinedRoles.iterator();
            while (it.hasNext()) {
                rolesStr.append((String)it.next());
                rolesStr.append(",");
            }
            JResourceLDAP.getLogger().log(BasicLevel.DEBUG, (Object)("Roles are : " + rolesStr + " for user '" + user.getName() + "'"));
        }
        return allCombinedRoles;
    }

    public String toXML() {
        StringBuffer xml = new StringBuffer("    <ldaprealm name=\"");
        xml.append(this.getName());
        xml.append("\"\n               baseDN=\"");
        if (this.baseDN != null) {
            xml.append(this.baseDN);
        }
        if (this.initialContextFactory != null && !this.initialContextFactory.equals("")) {
            xml.append("\"\n               initialContextFactory=\"");
            xml.append(this.initialContextFactory);
        }
        if (this.providerUrl != null && !this.providerUrl.equals("")) {
            xml.append("\"\n               providerUrl=\"");
            xml.append(this.providerUrl);
        }
        if (this.securityAuthentication != null && !this.securityAuthentication.equals("")) {
            xml.append("\"\n               securityAuthentication=\"");
            xml.append(this.securityAuthentication);
        }
        if (this.securityPrincipal != null && !this.securityPrincipal.equals("")) {
            xml.append("\"\n               securityPrincipal=\"");
            xml.append(this.securityPrincipal);
        }
        if (this.securityCredentials != null && !this.securityCredentials.equals("")) {
            xml.append("\"\n               securityCredentials=\"");
            xml.append(this.securityCredentials);
        }
        if (this.authenticationMode != null && !this.authenticationMode.equals("")) {
            xml.append("\"\n               authenticationMode=\"");
            xml.append(this.authenticationMode);
        }
        if (this.userPasswordAttribute != null && !this.userPasswordAttribute.equals("")) {
            xml.append("\"\n               userPasswordAttribute=\"");
            xml.append(this.userPasswordAttribute);
        }
        if (this.userRolesAttribute != null && !this.userRolesAttribute.equals("")) {
            xml.append("\"\n               userRolesAttribute=\"");
            xml.append(this.userRolesAttribute);
        }
        if (this.roleNameAttribute != null && !this.roleNameAttribute.equals("")) {
            xml.append("\"\n               roleNameAttribute=\"");
            xml.append(this.roleNameAttribute);
        }
        if (this.userDN != null && !this.userDN.equals("")) {
            xml.append("\"\n               userDN=\"");
            xml.append(this.userDN);
        }
        if (this.userSearchFilter != null && !this.userSearchFilter.equals("")) {
            xml.append("\"\n               userSearchFilter=\"");
            xml.append(this.userSearchFilter);
        }
        if (this.roleDN != null && !this.roleDN.equals("")) {
            xml.append("\"\n               roleDN=\"");
            xml.append(this.roleDN);
        }
        if (this.roleSearchFilter != null && !this.roleSearchFilter.equals("")) {
            xml.append("\"\n               roleSearchFilter=\"");
            xml.append(this.roleSearchFilter);
        }
        if (this.securityProtocol != null && !this.securityProtocol.equals("")) {
            xml.append("\"\n               securityProtocol=\"");
            xml.append(this.securityProtocol);
        }
        if (this.language != null && !this.language.equals("")) {
            xml.append("\"\n               language=\"");
            xml.append(this.language);
        }
        if (this.referral != null && !this.referral.equals("")) {
            xml.append("\"\n               referral=\"");
            xml.append(this.referral);
        }
        if (this.stateFactories != null && !this.stateFactories.equals("")) {
            xml.append("\"\n               stateFactories=\"");
            xml.append(this.stateFactories);
        }
        if (this.algorithm != null && !this.algorithm.equals("")) {
            xml.append("\"\n               algorithm=\"");
            xml.append(this.algorithm);
        }
        xml.append("\" />");
        return xml.toString();
    }

    public String toString() {
        return this.toXML();
    }

    public Reference getReference() throws NamingException {
        Reference reference = new Reference(FACTORY_TYPE, FACTORY_NAME, null);
        reference.add(new StringRefAddr("name", this.getName()));
        reference.add(new StringRefAddr("initialContextFactory", this.getInitialContextFactory()));
        reference.add(new StringRefAddr("providerUrl", this.getProviderUrl()));
        reference.add(new StringRefAddr("securityAuthentication", this.getSecurityAuthentication()));
        reference.add(new StringRefAddr("securityPrincipal", this.getSecurityPrincipal()));
        reference.add(new StringRefAddr("securityCredentials", this.getSecurityCredentials()));
        reference.add(new StringRefAddr("securityProtocol", this.getSecurityProtocol()));
        reference.add(new StringRefAddr("language", this.getLanguage()));
        reference.add(new StringRefAddr("referral", this.getReferral()));
        reference.add(new StringRefAddr("stateFactories", this.getStateFactories()));
        reference.add(new StringRefAddr("authenticationMode", this.getAuthenticationMode()));
        reference.add(new StringRefAddr("userPasswordAttribute", this.getUserPasswordAttribute()));
        reference.add(new StringRefAddr("userRolesAttribute", this.getUserRolesAttribute()));
        reference.add(new StringRefAddr("roleNameAttribute", this.getRoleNameAttribute()));
        reference.add(new StringRefAddr("baseDN", this.getBaseDN()));
        reference.add(new StringRefAddr("userDN", this.getUserDN()));
        reference.add(new StringRefAddr("userSearchFilter", this.getUserSearchFilter()));
        reference.add(new StringRefAddr("roleDN", this.getRoleDN()));
        reference.add(new StringRefAddr("roleSearchFilter", this.getRoleSearchFilter()));
        reference.add(new StringRefAddr("algorithm", this.algorithm));
        return reference;
    }

    public void setInitialContextFactory(String initialContextFactory) {
        this.initialContextFactory = initialContextFactory;
    }

    public void setProviderUrl(String providerUrl) {
        this.providerUrl = providerUrl;
    }

    public void setSecurityAuthentication(String securityAuthentication) {
        this.securityAuthentication = securityAuthentication;
    }

    public void setSecurityPrincipal(String securityPrincipal) {
        this.securityPrincipal = securityPrincipal;
    }

    public void setSecurityCredentials(String securityCredentials) {
        this.securityCredentials = securityCredentials;
    }

    public void setSecurityProtocol(String securityProtocol) {
        this.securityProtocol = securityProtocol;
    }

    public void setLanguage(String language) {
        this.language = language;
    }

    public void setReferral(String referral) {
        this.referral = referral;
    }

    public void setStateFactories(String stateFactories) {
        this.stateFactories = stateFactories;
    }

    public void setAuthenticationMode(String authenticationMode) {
        this.authenticationMode = authenticationMode;
    }

    public void setUserPasswordAttribute(String userPasswordAttribute) {
        this.userPasswordAttribute = userPasswordAttribute;
    }

    public void setUserRolesAttribute(String userRolesAttribute) {
        this.userRolesAttribute = userRolesAttribute;
    }

    public void setRoleNameAttribute(String roleNameAttribute) {
        this.roleNameAttribute = roleNameAttribute;
    }

    public void setBaseDN(String baseDN) {
        if (baseDN != null && !baseDN.equals("")) {
            this.baseDN = baseDN;
        }
    }

    public void setUserDN(String userDN) {
        if (userDN != null && !userDN.equals("")) {
            this.userDN = userDN;
        }
    }

    public void setUserSearchFilter(String userSearchFilter) {
        this.userSearchFilter = userSearchFilter;
    }

    public void setRoleDN(String roleDN) {
        this.roleDN = roleDN;
    }

    public void setRoleSearchFilter(String roleSearchFilter) {
        this.roleSearchFilter = roleSearchFilter;
    }

    public void setAlgorithm(String algorithm) {
        this.algorithm = algorithm;
    }

    public String getInitialContextFactory() {
        return this.initialContextFactory;
    }

    public String getProviderUrl() {
        return this.providerUrl;
    }

    public String getSecurityAuthentication() {
        return this.securityAuthentication;
    }

    public String getSecurityPrincipal() {
        return this.securityPrincipal;
    }

    public String getSecurityCredentials() {
        return this.securityCredentials;
    }

    public String getSecurityProtocol() {
        return this.securityProtocol;
    }

    public String getLanguage() {
        return this.language;
    }

    public String getReferral() {
        return this.referral;
    }

    public String getStateFactories() {
        return this.stateFactories;
    }

    public String getAuthenticationMode() {
        return this.authenticationMode;
    }

    public String getUserPasswordAttribute() {
        return this.userPasswordAttribute;
    }

    public String getUserRolesAttribute() {
        return this.userRolesAttribute;
    }

    public String getRoleNameAttribute() {
        return this.roleNameAttribute;
    }

    public String getBaseDN() {
        return this.baseDN;
    }

    public String getUserDN() {
        return this.userDN;
    }

    public String getUserSearchFilter() {
        return this.userSearchFilter;
    }

    public String getRoleDN() {
        return this.roleDN;
    }

    public String getRoleSearchFilter() {
        return this.roleSearchFilter;
    }

    public String getAlgorithm() {
        return this.algorithm;
    }

    protected DirContext getDirContext() throws NamingException {
        InitialDirContext dirContext = null;
        dirContext = new InitialDirContext(this.getEnvInitialDirContext());
        return dirContext;
    }

    private Hashtable getEnvInitialDirContext() {
        Hashtable<String, String> env = new Hashtable<String, String>();
        env.put("java.naming.factory.initial", this.initialContextFactory);
        env.put("java.naming.provider.url", this.providerUrl);
        env.put("java.naming.security.authentication", this.securityAuthentication);
        if (this.securityPrincipal != null && !this.securityPrincipal.equals("")) {
            env.put("java.naming.security.principal", this.securityPrincipal);
        }
        if (this.securityCredentials != null && !this.securityCredentials.equals("")) {
            env.put("java.naming.security.credentials", this.securityCredentials);
        }
        if (this.language != null && !this.language.equals("")) {
            env.put("java.naming.language", this.language);
        }
        if (this.referral != null && !this.referral.equals("")) {
            env.put("java.naming.referral", this.referral);
        }
        if (this.securityProtocol != null && !this.securityProtocol.equals("")) {
            env.put("java.naming.security.protocol", this.securityProtocol);
        }
        if (this.stateFactories != null && !this.stateFactories.equals("")) {
            env.put("java.naming.factory.state", this.stateFactories);
        }
        return env;
    }

    private String readValueFromAttribute(String attrID, Attributes attributes) throws NamingException {
        if (attributes == null || attrID == null) {
            return null;
        }
        Attribute attribute = attributes.get(attrID);
        if (attribute == null) {
            return null;
        }
        Object o = attribute.get();
        String value = null;
        value = o instanceof byte[] ? new String((byte[])o) : o.toString();
        return value;
    }

    private String readValuesFromAttribute(String attrID, Attributes attributes) throws NamingException {
        if (attributes == null || attrID == null) {
            return null;
        }
        Attribute attribute = attributes.get(attrID);
        if (attribute == null) {
            return null;
        }
        String value = null;
        NamingEnumeration<?> e = attribute.getAll();
        while (e.hasMore()) {
            String s = (String)e.next();
            if (value == null) {
                value = s;
                continue;
            }
            value = value + "," + s;
        }
        return value;
    }

    private void addValueFromAttributeToVector(String attrID, Attributes attributes, Vector v) throws NamingException {
        if (attributes == null || attrID == null) {
            return;
        }
        Attribute attribute = attributes.get(attrID);
        if (attribute == null) {
            return;
        }
        NamingEnumeration<?> e = attribute.getAll();
        while (e.hasMore()) {
            v.add(e.next());
        }
    }

    public void removeMBeans() throws JResourceException {
    }
}

