/*
 * Decompiled with CFR 0.152.
 */
package org.ow2.jonas.ws.axis;

import java.io.IOException;
import java.io.InputStream;
import java.io.StringWriter;
import java.io.Writer;
import java.lang.reflect.Constructor;
import java.lang.reflect.InvocationHandler;
import java.lang.reflect.Method;
import java.lang.reflect.Proxy;
import java.net.URL;
import java.util.Hashtable;
import java.util.List;
import java.util.Map;
import java.util.Properties;
import java.util.StringTokenizer;
import javax.naming.BinaryRefAddr;
import javax.naming.Context;
import javax.naming.InitialContext;
import javax.naming.Name;
import javax.naming.NamingException;
import javax.naming.RefAddr;
import javax.naming.Reference;
import javax.naming.StringRefAddr;
import javax.wsdl.Definition;
import javax.wsdl.Port;
import javax.wsdl.extensions.ExtensibilityElement;
import javax.wsdl.extensions.soap.SOAPAddress;
import javax.wsdl.factory.WSDLFactory;
import javax.wsdl.xml.WSDLReader;
import javax.xml.namespace.QName;
import javax.xml.rpc.Service;
import org.apache.axis.EngineConfiguration;
import org.apache.axis.client.AxisClient;
import org.apache.axis.configuration.XMLStringProvider;
import org.apache.axis.deployment.wsdd.WSDDProvider;
import org.apache.axis.utils.XMLUtils;
import org.apache.axis.wsdl.toJava.Utils;
import org.objectweb.util.monolog.api.BasicLevel;
import org.objectweb.util.monolog.api.Logger;
import org.ow2.jonas.deployment.api.IServiceRefDesc;
import org.ow2.jonas.deployment.ws.MappingFile;
import org.ow2.jonas.deployment.ws.PortComponentDesc;
import org.ow2.jonas.deployment.ws.PortComponentRefDesc;
import org.ow2.jonas.deployment.ws.ServiceRefDesc;
import org.ow2.jonas.lib.util.I18n;
import org.ow2.jonas.lib.util.JNDIUtils;
import org.ow2.jonas.lib.util.Log;
import org.ow2.jonas.lib.util.XMLSerializer;
import org.ow2.jonas.ws.axis.JService;
import org.ow2.jonas.ws.axis.JServiceProxy;
import org.ow2.jonas.ws.axis.WSDDNoopProvider;
import org.ow2.jonas.ws.jaxrpc.WSException;
import org.ow2.jonas.ws.jaxrpc.factory.JServiceFactory;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.NodeList;

public class JAxisServiceFactory
implements JServiceFactory {
    private static Logger logger = Log.getLogger((String)"org.ow2.jonas.ws");
    private static I18n i18n = I18n.getInstance(JAxisServiceFactory.class);
    private static final String AXIS_CLIENT_CONFIG_PARAM = "axis.clientConfigFile";
    private static final String CLIENT_CONFIG_WSDD = "org/ow2/jonas/ws/axis/client-config.wsdd";
    private static final String JONAS_SERVICE_CLASSNAME = "org.ow2.jonas.ws.axis.JService";
    public static final String REF_CLIENT_CONFIG = "client.config.wsdd";
    public static final String REF_SERVICE_WSDL = "service.wsdl.url";
    public static final String REF_SERVICE_QNAME = "service.qname";
    public static final String REF_SERVICE_PORT2WSDL = "port.2.wsdl.map";
    public static final String REF_SERVICE_CALL_PROPS = "service.call.properties";
    public static final String REF_SERVICE_STUB_PROPS = "service.stub.properties";
    public static final String REF_SERVICE_WSDL_PORT_LIST = "service.port.list";
    private static final Class[] SETENDPOINTADDRESS_SIG = new Class[]{String.class, String.class};

    public JAxisServiceFactory() {
        QName javaURI = new QName("http://xml.apache.org/axis/wsdd/providers/java", "Noop");
        WSDDProvider.registerProvider(javaURI, new WSDDNoopProvider());
    }

    public Reference getServiceReference(IServiceRefDesc sr, ClassLoader cl) throws WSException {
        List ports;
        String classname = this.createServiceClassname((ServiceRefDesc)sr);
        logger.log(BasicLevel.DEBUG, (Object)("Service classname: '" + classname + "'"));
        Reference ref = new Reference(classname, this.getClass().getName(), null);
        Document base = this.loadAxisDeployment(CLIENT_CONFIG_WSDD, cl);
        String clientConfig = sr.getParam(AXIS_CLIENT_CONFIG_PARAM);
        if (clientConfig != null) {
            Document doc = this.loadAxisDeployment(clientConfig, cl);
            this.mergeAxisDeployment(base, doc);
        }
        String str = null;
        try {
            str = this.serializeDOM(base);
            if (logger.isLoggable(BasicLevel.DEBUG)) {
                logger.log(BasicLevel.DEBUG, (Object)("Client Descriptor file : \n" + str));
            }
        }
        catch (IOException ioe) {
            throw new WSException("Cannot serialize Document", (Throwable)ioe);
        }
        ref.add(new StringRefAddr(REF_CLIENT_CONFIG, str));
        for (PortComponentRefDesc pcr : sr.getPortComponentRefs()) {
            PortComponentDesc referencedPortComponent = pcr.getPortComponentDesc();
            if (referencedPortComponent == null) continue;
            logger.log(BasicLevel.DEBUG, (Object)("Find a port-component-link in port-component-ref" + pcr.getSEI()));
            URL url = referencedPortComponent.getEndpointURL();
            if (url == null) {
                try {
                    InitialContext ic = new InitialContext();
                    url = (URL)ic.lookup(referencedPortComponent.getName());
                }
                catch (NamingException ne) {
                    throw new WSException("Cannot find updated endpoint for port-component '" + referencedPortComponent.getName() + "'", (Throwable)ne);
                }
            }
            logger.log(BasicLevel.DEBUG, (Object)("Uptodate URL : '" + url + "?JWSDL' "));
            ref.add(new StringRefAddr(REF_SERVICE_WSDL, url.toExternalForm() + "?JWSDL"));
        }
        if (sr.getAlternateWsdlURL() != null) {
            logger.log(BasicLevel.DEBUG, (Object)("Using alternate WSDL URL : '" + sr.getAlternateWsdlURL() + "'"));
            ref.add(new StringRefAddr(REF_SERVICE_WSDL, sr.getAlternateWsdlURL().toString()));
        } else if (sr.getLocalWSDLURL() != null) {
            logger.log(BasicLevel.DEBUG, (Object)("Using WSDL URL : '" + sr.getLocalWSDLURL() + "'"));
            ref.add(new StringRefAddr(REF_SERVICE_WSDL, sr.getLocalWSDLURL().toExternalForm()));
        }
        if (sr.getServiceQName() != null) {
            ref.add(new BinaryRefAddr(REF_SERVICE_QNAME, JNDIUtils.getBytesFromObject((Object)sr.getServiceQName())));
        }
        if (!(ports = sr.getPortComponentRefs()).isEmpty()) {
            Hashtable<String, QName> map = new Hashtable<String, QName>();
            for (PortComponentRefDesc pcrd : ports) {
                QName wsdlPort = pcrd.getWsdlPort();
                if (wsdlPort == null) continue;
                map.put(pcrd.getSEI().getName(), wsdlPort);
            }
            if (!map.isEmpty()) {
                ref.add(new BinaryRefAddr(REF_SERVICE_PORT2WSDL, JNDIUtils.getBytesFromObject(map)));
            }
        }
        String portNames = null;
        for (PortComponentRefDesc pcr : sr.getPortComponentRefs()) {
            Properties cProps = pcr.getCallProperties();
            Properties sProps = pcr.getStubProperties();
            if (pcr.getWsdlPort() == null) continue;
            String name = pcr.getWsdlPort().getLocalPart();
            if (!cProps.isEmpty()) {
                ref.add(new BinaryRefAddr("service.call.properties_" + name, JNDIUtils.getBytesFromObject((Object)cProps)));
            }
            if (!sProps.isEmpty()) {
                ref.add(new BinaryRefAddr("service.stub.properties_" + name, JNDIUtils.getBytesFromObject((Object)sProps)));
            }
            if (sProps.isEmpty() && cProps.isEmpty()) continue;
            if (portNames != null) {
                portNames = portNames + "," + name;
                continue;
            }
            portNames = name;
        }
        if (portNames != null) {
            ref.add(new StringRefAddr(REF_SERVICE_WSDL_PORT_LIST, portNames));
        }
        return ref;
    }

    private String serializeDOM(Document base) throws IOException {
        StringWriter sw = new StringWriter();
        XMLSerializer ser = new XMLSerializer(base);
        ser.serialize((Writer)sw);
        return sw.getBuffer().toString();
    }

    private void mergeAxisDeployment(Document base, Document doc) {
        Element importedDeploymentElement = (Element)base.importNode(doc.getDocumentElement(), true);
        NodeList list = importedDeploymentElement.getChildNodes();
        for (int i = 0; i < list.getLength(); ++i) {
            if (!(list.item(i) instanceof Element)) continue;
            base.getDocumentElement().appendChild(list.item(i));
        }
    }

    private String createServiceClassname(ServiceRefDesc sr) {
        String intfName = sr.getServiceInterface().getName();
        if (intfName.equals("javax.xml.rpc.Service")) {
            return JONAS_SERVICE_CLASSNAME;
        }
        QName qn = sr.getServiceQName();
        MappingFile mf = sr.getMappingFile();
        String p = (String)mf.getMappings().get(qn.getNamespaceURI());
        String classname = "";
        classname = p != null ? p + "." + Utils.xmlNameToJavaClass(qn.getLocalPart()) + "Locator" : Utils.xmlNameToJavaClass(qn.getLocalPart()) + "Locator";
        return classname;
    }

    private Document loadAxisDeployment(String filename, ClassLoader cl) throws WSException {
        InputStream is = cl.getResourceAsStream(filename);
        if (is == null) {
            String err = i18n.getMessage("JAxisServiceFactory.loadAxisDeployment.configNotFound", (Object)filename);
            logger.log(BasicLevel.ERROR, (Object)err);
            throw new WSException(err);
        }
        Document doc = null;
        try {
            doc = XMLUtils.newDocument(is);
        }
        catch (Exception e) {
            String err = i18n.getMessage("JAxisServiceFactory.loadAxisDeployment.docCreation", (Object)filename);
            logger.log(BasicLevel.DEBUG, (Object)err);
            throw new WSException(err, (Throwable)e);
        }
        return doc;
    }

    public Object getObjectInstance(Object refObject, Name name, Context nameCtx, Hashtable env) throws Exception {
        JService instance = null;
        Object proxy = null;
        if (refObject instanceof Reference) {
            Reference ref = (Reference)refObject;
            ClassLoader cl = Thread.currentThread().getContextClassLoader();
            logger.log(BasicLevel.DEBUG, (Object)("Context ClassLoader : " + cl));
            Class<?> serviceClass = cl.loadClass(ref.getClassName());
            BinaryRefAddr bRefQname = (BinaryRefAddr)ref.get(REF_SERVICE_QNAME);
            QName serviceQname = null;
            if (bRefQname != null) {
                serviceQname = (QName)JNDIUtils.getObjectFromBytes((byte[])((byte[])bRefQname.getContent()));
            }
            RefAddr refServiceWSDL = ref.get(REF_SERVICE_WSDL);
            String serviceWsdl = null;
            if (refServiceWSDL != null) {
                serviceWsdl = (String)refServiceWSDL.getContent();
            }
            if (JONAS_SERVICE_CLASSNAME.equals(serviceClass.getName())) {
                logger.log(BasicLevel.DEBUG, (Object)"default service class");
                if (serviceQname == null && serviceWsdl == null) {
                    logger.log(BasicLevel.DEBUG, (Object)"Create a new Service instance without params");
                    instance = new JService();
                } else if (serviceQname != null && serviceWsdl == null) {
                    logger.log(BasicLevel.DEBUG, (Object)("Create a new Service instance with only a QName " + serviceQname));
                    instance = new JService(serviceQname);
                } else if (serviceQname != null && serviceWsdl != null) {
                    logger.log(BasicLevel.DEBUG, (Object)("Create a new Service instance with QName " + serviceQname + "and WSDL " + serviceWsdl));
                    instance = new JService(serviceWsdl, serviceQname);
                } else {
                    logger.log(BasicLevel.DEBUG, (Object)("Create a new Service instance with WSDL " + serviceWsdl));
                    logger.log(BasicLevel.DEBUG, (Object)"Should not occurs !!!");
                    instance = new JService();
                }
            } else {
                logger.log(BasicLevel.DEBUG, (Object)"Create a new Generated Service instance");
                logger.log(BasicLevel.DEBUG, (Object)("serviceWSDL:" + serviceWsdl + " serviceQName:" + serviceQname));
                Constructor<?> ctr = serviceClass.getConstructor(String.class, QName.class);
                instance = (JService)ctr.newInstance(serviceWsdl, serviceQname);
                if (serviceWsdl != null) {
                    WSDLFactory factory = WSDLFactory.newInstance();
                    WSDLReader reader = factory.newWSDLReader();
                    reader.setFeature("javax.wsdl.importDocuments", true);
                    Definition def = reader.readWSDL(serviceWsdl);
                    javax.wsdl.Service service = def.getService(serviceQname);
                    Map ports = service.getPorts();
                    Method m = serviceClass.getMethod("setEndpointAddress", SETENDPOINTADDRESS_SIG);
                    for (String portName : ports.keySet()) {
                        Port port = service.getPort(portName);
                        String endpoint = this.getSOAPLocation(port);
                        m.invoke((Object)instance, port.getName(), endpoint);
                    }
                }
            }
            BinaryRefAddr bRefp2w = (BinaryRefAddr)ref.get(REF_SERVICE_PORT2WSDL);
            if (bRefp2w != null) {
                Map map = (Map)JNDIUtils.getObjectFromBytes((byte[])((byte[])bRefp2w.getContent()));
                instance.assignSEIClassnameToWSDLPort(map);
            }
            RefAddr portsRef = ref.get(REF_SERVICE_WSDL_PORT_LIST);
            String listPorts = null;
            if (portsRef != null && (listPorts = (String)portsRef.getContent()) != null) {
                StringTokenizer strPort = new StringTokenizer(listPorts, ",");
                while (strPort.hasMoreTokens()) {
                    BinaryRefAddr bRefsp;
                    String port = strPort.nextToken();
                    BinaryRefAddr bRefcp = (BinaryRefAddr)ref.get("service.call.properties_" + port);
                    if (bRefcp != null) {
                        Properties callProperties = (Properties)JNDIUtils.getObjectFromBytes((byte[])((byte[])bRefcp.getContent()));
                        instance.assignCallProperties(port, callProperties);
                    }
                    if ((bRefsp = (BinaryRefAddr)ref.get("service.stub.properties_" + port)) == null) continue;
                    Properties stubProperties = (Properties)JNDIUtils.getObjectFromBytes((byte[])((byte[])bRefsp.getContent()));
                    instance.assignStubProperties(port, stubProperties);
                }
            }
            EngineConfiguration ec = this.getConfiguration(ref);
            instance.setEngine(new AxisClient(ec));
            JServiceProxy handler = new JServiceProxy(instance);
            Class<?>[] serviceInterfaces = serviceClass.getInterfaces();
            Class[] interfaces = new Class[serviceInterfaces.length + 1];
            for (int i = 0; i < serviceInterfaces.length; ++i) {
                interfaces[i] = serviceInterfaces[i];
            }
            interfaces[serviceInterfaces.length] = Service.class;
            proxy = Proxy.newProxyInstance(cl, interfaces, (InvocationHandler)handler);
        }
        return proxy;
    }

    private String getSOAPLocation(Port port) {
        String endpoint = null;
        List extensions = port.getExtensibilityElements();
        for (ExtensibilityElement ext : extensions) {
            if (!(ext instanceof SOAPAddress)) continue;
            SOAPAddress addr = (SOAPAddress)ext;
            endpoint = addr.getLocationURI();
        }
        return endpoint;
    }

    private EngineConfiguration getConfiguration(Reference ref) throws Exception {
        String conf = (String)ref.get(REF_CLIENT_CONFIG).getContent();
        logger.log(BasicLevel.DEBUG, (Object)("loaded configuration : " + conf));
        return new XMLStringProvider(conf);
    }
}

