/*
 * Decompiled with CFR 0.152.
 */
package org.seleniumhq.jetty7.io.nio;

import java.io.File;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.RandomAccessFile;
import java.nio.channels.FileChannel;
import java.nio.channels.WritableByteChannel;
import org.seleniumhq.jetty7.io.AbstractBuffer;
import org.seleniumhq.jetty7.io.Buffer;

public class RandomAccessFileBuffer
extends AbstractBuffer
implements Buffer {
    final RandomAccessFile _file;
    final FileChannel _channel;
    final int _capacity;

    public RandomAccessFileBuffer(File file) throws FileNotFoundException {
        super(2, true);
        assert (file.length() <= Integer.MAX_VALUE);
        this._file = new RandomAccessFile(file, "rw");
        this._channel = this._file.getChannel();
        this._capacity = Integer.MAX_VALUE;
        this.setGetIndex(0);
        this.setPutIndex((int)file.length());
    }

    public RandomAccessFileBuffer(File file, int capacity) throws FileNotFoundException {
        super(2, true);
        assert ((long)capacity >= file.length());
        assert (file.length() <= Integer.MAX_VALUE);
        this._capacity = capacity;
        this._file = new RandomAccessFile(file, "rw");
        this._channel = this._file.getChannel();
        this.setGetIndex(0);
        this.setPutIndex((int)file.length());
    }

    public RandomAccessFileBuffer(File file, int capacity, int access) throws FileNotFoundException {
        super(access, true);
        assert ((long)capacity >= file.length());
        assert (file.length() <= Integer.MAX_VALUE);
        this._capacity = capacity;
        this._file = new RandomAccessFile(file, access == 2 ? "rw" : "r");
        this._channel = this._file.getChannel();
        this.setGetIndex(0);
        this.setPutIndex((int)file.length());
    }

    public byte[] array() {
        return null;
    }

    public int capacity() {
        return this._capacity;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void clear() {
        try {
            RandomAccessFile randomAccessFile = this._file;
            synchronized (randomAccessFile) {
                super.clear();
                this._file.setLength(0L);
            }
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
    }

    public byte peek() {
        RandomAccessFile randomAccessFile = this._file;
        synchronized (randomAccessFile) {
            try {
                if ((long)this._get != this._file.getFilePointer()) {
                    this._file.seek(this._get);
                }
                return this._file.readByte();
            }
            catch (Exception e) {
                throw new RuntimeException(e);
            }
        }
    }

    public byte peek(int index) {
        RandomAccessFile randomAccessFile = this._file;
        synchronized (randomAccessFile) {
            try {
                this._file.seek(index);
                return this._file.readByte();
            }
            catch (Exception e) {
                throw new RuntimeException(e);
            }
        }
    }

    public int peek(int index, byte[] b, int offset, int length) {
        RandomAccessFile randomAccessFile = this._file;
        synchronized (randomAccessFile) {
            try {
                this._file.seek(index);
                return this._file.read(b, offset, length);
            }
            catch (Exception e) {
                throw new RuntimeException(e);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void poke(int index, byte b) {
        RandomAccessFile randomAccessFile = this._file;
        synchronized (randomAccessFile) {
            try {
                this._file.seek(index);
                this._file.writeByte(b);
            }
            catch (Exception e) {
                throw new RuntimeException(e);
            }
        }
    }

    public int poke(int index, byte[] b, int offset, int length) {
        RandomAccessFile randomAccessFile = this._file;
        synchronized (randomAccessFile) {
            try {
                this._file.seek(index);
                this._file.write(b, offset, length);
                return length;
            }
            catch (Exception e) {
                throw new RuntimeException(e);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public int writeTo(WritableByteChannel channel, int index, int length) throws IOException {
        RandomAccessFile randomAccessFile = this._file;
        synchronized (randomAccessFile) {
            return (int)this._channel.transferTo(index, length, channel);
        }
    }
}

