/*
 * Decompiled with CFR 0.152.
 */
package org.seleniumhq.jetty9.server;

import javax.servlet.ServletRequestEvent;
import javax.servlet.ServletRequestListener;
import org.seleniumhq.jetty9.server.handler.ContextHandler;
import org.seleniumhq.jetty9.util.MultiException;
import org.seleniumhq.jetty9.util.MultiPartInputStreamParser;

public class MultiPartCleanerListener
implements ServletRequestListener {
    public static final MultiPartCleanerListener INSTANCE = new MultiPartCleanerListener();

    protected MultiPartCleanerListener() {
    }

    public void requestDestroyed(ServletRequestEvent sre) {
        ContextHandler.Context context;
        MultiPartInputStreamParser mpis = (MultiPartInputStreamParser)sre.getServletRequest().getAttribute("org.seleniumhq.jetty9.multiPartInputStream");
        if (mpis != null && (context = (ContextHandler.Context)sre.getServletRequest().getAttribute("org.seleniumhq.jetty9.multiPartContext")) == sre.getServletContext()) {
            try {
                mpis.deleteParts();
            }
            catch (MultiException e) {
                sre.getServletContext().log("Errors deleting multipart tmp files", (Throwable)e);
            }
        }
    }

    public void requestInitialized(ServletRequestEvent sre) {
    }
}

