/*
 * Decompiled with CFR 0.152.
 */
package org.openqa.selenium.server;

import java.io.File;
import java.io.IOException;
import org.openqa.jetty.http.HttpContext;
import org.openqa.jetty.util.Resource;
import org.openqa.selenium.server.FutureFileResource;
import org.openqa.selenium.server.ResourceLocator;

public class FsResourceLocator
implements ResourceLocator {
    private File rootDir;
    private static final String USER_EXTENSIONS_JS_NAME = "user-extensions.js";
    private static final String TEST_DIR = "/tests";

    public FsResourceLocator(File directory) {
        this.rootDir = directory;
    }

    @Override
    public Resource getResource(HttpContext context, String pathInContext) throws IOException {
        File testFile;
        File file = new File(this.rootDir, pathInContext);
        Resource resource = this.createFileResource(file, context);
        if (!resource.exists() && file.getName().equals(USER_EXTENSIONS_JS_NAME) && (resource = this.userExtensionResource(context)).exists()) {
            return resource;
        }
        if (!resource.exists() && pathInContext.startsWith(TEST_DIR) && (resource = this.createFileResource(testFile = new File(this.rootDir, pathInContext.substring(TEST_DIR.length())), context)).exists()) {
            return resource;
        }
        return resource;
    }

    private Resource userExtensionResource(HttpContext context) throws IOException {
        File extensions = new File(this.rootDir, USER_EXTENSIONS_JS_NAME);
        return this.createFileResource(extensions, context);
    }

    private Resource createFileResource(File file, HttpContext context) throws IOException {
        FutureFileResource resource = new FutureFileResource(file.toURI().toURL());
        context.getResourceMetaData(resource);
        return resource;
    }
}

