/*
 * Decompiled with CFR 0.152.
 */
package org.skyscreamer.nevado.jms;

import javax.jms.Destination;
import javax.jms.IllegalStateException;
import javax.jms.JMSException;
import javax.jms.Message;
import javax.jms.MessageProducer;
import javax.jms.Queue;
import javax.jms.QueueSender;
import javax.jms.Topic;
import javax.jms.TopicPublisher;
import org.skyscreamer.nevado.jms.NevadoSession;
import org.skyscreamer.nevado.jms.destination.NevadoDestination;
import org.skyscreamer.nevado.jms.message.NevadoMessage;

public class NevadoMessageProducer
implements MessageProducer,
QueueSender,
TopicPublisher {
    private boolean _closed = false;
    private final NevadoSession _session;
    private final NevadoDestination _destination;
    private boolean _disableMessageID = false;
    private boolean _disableTimestamp = false;
    private int _deliveryMode = 2;
    private int _priority = 4;
    private long _ttl = 0L;

    public NevadoMessageProducer(NevadoSession session, NevadoDestination destination) throws JMSException {
        if (session == null || destination == null) {
            throw new NullPointerException();
        }
        this._session = session;
        this._destination = destination;
    }

    public void setDisableMessageID(boolean disableMessageID) throws JMSException {
        this.checkClosed();
        this._disableMessageID = disableMessageID;
    }

    public boolean getDisableMessageID() throws JMSException {
        return this._disableMessageID;
    }

    public void setDisableMessageTimestamp(boolean disableTimestamp) throws JMSException {
        this.checkClosed();
        this._disableTimestamp = disableTimestamp;
    }

    public boolean getDisableMessageTimestamp() throws JMSException {
        return this._disableTimestamp;
    }

    public void setDeliveryMode(int deliveryMode) throws JMSException {
        this.checkClosed();
        this._deliveryMode = deliveryMode;
    }

    public int getDeliveryMode() {
        return this._deliveryMode;
    }

    public void setPriority(int priority) throws JMSException {
        this.checkClosed();
        this._priority = priority;
    }

    public int getPriority() {
        return this._priority;
    }

    public void setTimeToLive(long ttl) throws JMSException {
        this.checkClosed();
        this._ttl = ttl;
    }

    public long getTimeToLive() {
        return this._ttl;
    }

    public Destination getDestination() throws JMSException {
        return this._destination;
    }

    public Queue getQueue() throws JMSException {
        if (this._destination instanceof Queue) {
            return (Queue)this._destination;
        }
        throw new IllegalStateException("getQueue() can only be called for a QueueSender");
    }

    public synchronized void close() throws JMSException {
        if (!this._closed) {
            this._closed = true;
        }
    }

    public void send(Message message) throws JMSException {
        this.send(this._destination, message);
    }

    public void send(Message message, int deliveryMode, int priority, long ttl) throws JMSException {
        this.send(this._destination, message, deliveryMode, priority, ttl);
    }

    public void send(Queue queue, Message message) throws JMSException {
        this.send(queue, message, this._deliveryMode, this._priority, this._ttl);
    }

    public void send(Destination destination, Message message) throws JMSException {
        this.send(destination, message, this._deliveryMode, this._priority, this._ttl);
    }

    public void send(Queue queue, Message message, int deliveryMode, int priority, long ttl) throws JMSException {
        if (!(this._destination instanceof Queue)) {
            throw new IllegalStateException("Only a QueueSender can send messages to a queue");
        }
        this.send((Destination)queue, message, deliveryMode, priority, ttl);
    }

    public void send(Destination destination, Message message, int deliveryMode, int priority, long ttl) throws JMSException {
        this.checkClosed();
        NevadoDestination nevadoDestination = NevadoDestination.getInstance(destination);
        NevadoMessage nevadoMessage = NevadoMessage.getInstance(message);
        nevadoMessage.setJMSDestination(destination);
        nevadoMessage.setJMSDeliveryMode(deliveryMode);
        nevadoMessage.setJMSPriority(priority);
        nevadoMessage.setJMSExpiration(ttl > 0L ? System.currentTimeMillis() + ttl : 0L);
        nevadoMessage.setDisableMessageID(this._disableMessageID);
        nevadoMessage.setDisableTimestamp(this._disableTimestamp);
        this._session.sendMessage(nevadoDestination, nevadoMessage);
    }

    public boolean isClosed() {
        return this._closed;
    }

    private void checkClosed() throws IllegalStateException {
        if (this._closed) {
            throw new IllegalStateException("This producer has been closed");
        }
    }

    public Topic getTopic() throws JMSException {
        if (this._destination instanceof Topic) {
            return (Topic)this._destination;
        }
        throw new IllegalStateException("getTopic() can only be called for a TopicPublisher");
    }

    public void publish(Message message) throws JMSException {
        this.publish(message, this._deliveryMode, this._priority, this._ttl);
    }

    public void publish(Message message, int deliveryMode, int priority, long ttl) throws JMSException {
        this.send(this._destination, message, deliveryMode, priority, ttl);
    }

    public void publish(Topic topic, Message message) throws JMSException {
        this.publish(topic, message, this._deliveryMode, this._priority, this._ttl);
    }

    public void publish(Topic topic, Message message, int deliveryMode, int priority, long ttl) throws JMSException {
        if (!(this._destination instanceof Topic)) {
            throw new IllegalStateException("Only a TopicPublisher can send messages to a queue");
        }
        this.send((Destination)topic, message, deliveryMode, priority, ttl);
    }
}

