/*
 * Decompiled with CFR 0.152.
 */
package org.skyscreamer.nevado.jms.message;

import java.io.Serializable;
import java.util.Arrays;

class ByteArray
implements Serializable {
    private final byte[] _value;
    private transient int hash = 0;
    private final long _size;

    public ByteArray() {
        this._value = new byte[0];
        this._size = 0L;
    }

    public ByteArray(byte[] value) {
        this._value = Arrays.copyOf(value, value.length);
        this._size = value.length;
    }

    public ByteArray(byte[] value, int offset, int length) {
        if (offset < 0) {
            throw new IndexOutOfBoundsException("Index of of range: " + offset);
        }
        if (length < 0) {
            throw new IndexOutOfBoundsException("Index of of range: " + length);
        }
        if (offset + length > value.length) {
            throw new IndexOutOfBoundsException("Index of of range: " + (offset + length));
        }
        this._value = Arrays.copyOfRange(value, offset, offset + length);
        this._size = length;
    }

    public byte[] toByteArray() {
        return Arrays.copyOf(this._value, this._value.length);
    }

    public long size() {
        return this._size;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        ByteArray byteArray = (ByteArray)o;
        return Arrays.equals(this._value, byteArray._value);
    }

    public int hashCode() {
        if (this.hash == 0) {
            this.hash = Arrays.hashCode(this._value);
        }
        return this.hash;
    }
}

