/*
 * Decompiled with CFR 0.152.
 */
package org.skyscreamer.nevado.jms.message;

import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.DataInputStream;
import java.io.DataOutputStream;
import java.io.EOFException;
import java.io.IOException;
import javax.jms.BytesMessage;
import javax.jms.JMSException;
import javax.jms.Message;
import javax.jms.MessageEOFException;
import javax.jms.MessageFormatException;
import javax.jms.MessageNotReadableException;
import javax.jms.MessageNotWriteableException;
import org.apache.commons.lang.builder.HashCodeBuilder;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.skyscreamer.nevado.jms.message.ByteArray;
import org.skyscreamer.nevado.jms.message.NevadoMessage;

public class NevadoBytesMessage
extends NevadoMessage
implements BytesMessage {
    private transient Log _log = LogFactory.getLog(NevadoBytesMessage.class);
    private ByteArray _body;
    private transient DataOutputStream dataOut;
    private transient ByteArrayOutputStream bytesOut;
    private transient DataInputStream dataIn;

    public NevadoBytesMessage() {
    }

    protected NevadoBytesMessage(BytesMessage message) throws JMSException {
        super((Message)message);
        message.reset();
        int count = 0;
        while ((long)count < message.getBodyLength()) {
            byte[] buffer = new byte[10240];
            int numRead = message.readBytes(buffer);
            this.writeBytes(buffer, 0, numRead);
            count += numRead;
        }
    }

    @Override
    public void internalClearBody() throws JMSException {
        this._body = null;
        this.dataOut = null;
        this.dataIn = null;
        this.bytesOut = null;
    }

    @Override
    public void onSend() {
        super.onSend();
        this.storeContent();
    }

    private void storeContent() {
        if (this.dataOut != null) {
            try {
                this.dataOut.close();
                this._body = new ByteArray(this.bytesOut.toByteArray());
                this.bytesOut = null;
                this.dataOut = null;
            }
            catch (IOException ioe) {
                throw new RuntimeException(ioe);
            }
        }
    }

    public void setBodyAsBytes(byte[] bodyAsBytes, int offset, int length) {
        this._body = new ByteArray(bodyAsBytes, offset, length);
        this.dataOut = null;
        this.dataIn = null;
        this.bytesOut = null;
    }

    public long getBodyLength() throws JMSException {
        this.checkWriteOnlyBody();
        return this._body.size();
    }

    public boolean readBoolean() throws JMSException {
        this.initializeReading();
        try {
            return this.dataIn.readBoolean();
        }
        catch (EOFException eof) {
            MessageEOFException jmsEx = new MessageEOFException(eof.getMessage());
            jmsEx.setLinkedException((Exception)eof);
            throw jmsEx;
        }
        catch (IOException ioe) {
            JMSException jmsEx = new JMSException("Format error occured" + ioe.getMessage());
            jmsEx.setLinkedException((Exception)ioe);
            throw jmsEx;
        }
    }

    public byte readByte() throws JMSException {
        this.initializeReading();
        try {
            return this.dataIn.readByte();
        }
        catch (EOFException eof) {
            MessageEOFException jmsEx = new MessageEOFException(eof.getMessage());
            jmsEx.setLinkedException((Exception)eof);
            throw jmsEx;
        }
        catch (IOException ioe) {
            JMSException jmsEx = new JMSException("Format error occured" + ioe.getMessage());
            jmsEx.setLinkedException((Exception)ioe);
            throw jmsEx;
        }
    }

    public int readUnsignedByte() throws JMSException {
        this.initializeReading();
        try {
            return this.dataIn.readUnsignedByte();
        }
        catch (EOFException eof) {
            MessageEOFException jmsEx = new MessageEOFException(eof.getMessage());
            jmsEx.setLinkedException((Exception)eof);
            throw jmsEx;
        }
        catch (IOException ioe) {
            JMSException jmsEx = new JMSException("Format error occured" + ioe.getMessage());
            jmsEx.setLinkedException((Exception)ioe);
            throw jmsEx;
        }
    }

    public short readShort() throws JMSException {
        this.initializeReading();
        try {
            return this.dataIn.readShort();
        }
        catch (EOFException eof) {
            MessageEOFException jmsEx = new MessageEOFException(eof.getMessage());
            jmsEx.setLinkedException((Exception)eof);
            throw jmsEx;
        }
        catch (IOException ioe) {
            JMSException jmsEx = new JMSException("Format error occured" + ioe.getMessage());
            jmsEx.setLinkedException((Exception)ioe);
            throw jmsEx;
        }
    }

    public int readUnsignedShort() throws JMSException {
        this.initializeReading();
        try {
            return this.dataIn.readUnsignedShort();
        }
        catch (EOFException eof) {
            MessageEOFException jmsEx = new MessageEOFException(eof.getMessage());
            jmsEx.setLinkedException((Exception)eof);
            throw jmsEx;
        }
        catch (IOException ioe) {
            JMSException jmsEx = new JMSException("Format error occured" + ioe.getMessage());
            jmsEx.setLinkedException((Exception)ioe);
            throw jmsEx;
        }
    }

    public char readChar() throws JMSException {
        this.initializeReading();
        try {
            return this.dataIn.readChar();
        }
        catch (EOFException eof) {
            MessageEOFException jmsEx = new MessageEOFException(eof.getMessage());
            jmsEx.setLinkedException((Exception)eof);
            throw jmsEx;
        }
        catch (IOException ioe) {
            JMSException jmsEx = new JMSException("Format error occured" + ioe.getMessage());
            jmsEx.setLinkedException((Exception)ioe);
            throw jmsEx;
        }
    }

    public int readInt() throws JMSException {
        this.initializeReading();
        try {
            return this.dataIn.readInt();
        }
        catch (EOFException eof) {
            MessageEOFException jmsEx = new MessageEOFException(eof.getMessage());
            jmsEx.setLinkedException((Exception)eof);
            throw jmsEx;
        }
        catch (IOException ioe) {
            JMSException jmsEx = new JMSException("Format error occured" + ioe.getMessage());
            jmsEx.setLinkedException((Exception)ioe);
            throw jmsEx;
        }
    }

    public long readLong() throws JMSException {
        this.initializeReading();
        try {
            return this.dataIn.readLong();
        }
        catch (EOFException eof) {
            MessageEOFException jmsEx = new MessageEOFException(eof.getMessage());
            jmsEx.setLinkedException((Exception)eof);
            throw jmsEx;
        }
        catch (IOException ioe) {
            JMSException jmsEx = new JMSException("Format error occured" + ioe.getMessage());
            jmsEx.setLinkedException((Exception)ioe);
            throw jmsEx;
        }
    }

    public float readFloat() throws JMSException {
        this.initializeReading();
        try {
            return this.dataIn.readFloat();
        }
        catch (EOFException eof) {
            MessageEOFException jmsEx = new MessageEOFException(eof.getMessage());
            jmsEx.setLinkedException((Exception)eof);
            throw jmsEx;
        }
        catch (IOException ioe) {
            JMSException jmsEx = new JMSException("Format error occured" + ioe.getMessage());
            jmsEx.setLinkedException((Exception)ioe);
            throw jmsEx;
        }
    }

    public double readDouble() throws JMSException {
        this.initializeReading();
        try {
            return this.dataIn.readDouble();
        }
        catch (EOFException eof) {
            MessageEOFException jmsEx = new MessageEOFException(eof.getMessage());
            jmsEx.setLinkedException((Exception)eof);
            throw jmsEx;
        }
        catch (IOException ioe) {
            JMSException jmsEx = new JMSException("Format error occured" + ioe.getMessage());
            jmsEx.setLinkedException((Exception)ioe);
            throw jmsEx;
        }
    }

    public String readUTF() throws JMSException {
        this.initializeReading();
        try {
            return this.dataIn.readUTF();
        }
        catch (EOFException eof) {
            MessageEOFException jmsEx = new MessageEOFException(eof.getMessage());
            jmsEx.setLinkedException((Exception)eof);
            throw jmsEx;
        }
        catch (IOException ioe) {
            JMSException jmsEx = new JMSException("Format error occured" + ioe.getMessage());
            jmsEx.setLinkedException((Exception)ioe);
            throw jmsEx;
        }
    }

    public int readBytes(byte[] value) throws JMSException {
        return this.readBytes(value, value.length);
    }

    public int readBytes(byte[] value, int length) throws JMSException {
        this.initializeReading();
        try {
            int n;
            int count;
            for (n = 0; n < length && (count = this.dataIn.read(value, n, length - n)) >= 0; n += count) {
            }
            if (n == 0 && length > 0) {
                n = -1;
            }
            return n;
        }
        catch (EOFException eof) {
            MessageEOFException jmsEx = new MessageEOFException(eof.getMessage());
            jmsEx.setLinkedException((Exception)eof);
            throw jmsEx;
        }
        catch (IOException ioe) {
            JMSException jmsEx = new JMSException("Format error occured" + ioe.getMessage());
            jmsEx.setLinkedException((Exception)ioe);
            throw jmsEx;
        }
    }

    public void writeBoolean(boolean value) throws JMSException {
        this.initializeWriting();
        try {
            this.dataOut.writeBoolean(value);
        }
        catch (IOException ioe) {
            JMSException jmsEx = new JMSException("Could not write data:" + ioe.getMessage());
            jmsEx.setLinkedException((Exception)ioe);
            throw jmsEx;
        }
    }

    public void writeByte(byte value) throws JMSException {
        this.initializeWriting();
        try {
            this.dataOut.writeByte(value);
        }
        catch (IOException ioe) {
            JMSException jmsEx = new JMSException("Could not write data:" + ioe.getMessage());
            jmsEx.setLinkedException((Exception)ioe);
            throw jmsEx;
        }
    }

    public void writeShort(short value) throws JMSException {
        this.initializeWriting();
        try {
            this.dataOut.writeShort(value);
        }
        catch (IOException ioe) {
            JMSException jmsEx = new JMSException("Could not write data:" + ioe.getMessage());
            jmsEx.setLinkedException((Exception)ioe);
            throw jmsEx;
        }
    }

    public void writeChar(char value) throws JMSException {
        this.initializeWriting();
        try {
            this.dataOut.writeChar(value);
        }
        catch (IOException ioe) {
            JMSException jmsEx = new JMSException("Could not write data:" + ioe.getMessage());
            jmsEx.setLinkedException((Exception)ioe);
            throw jmsEx;
        }
    }

    public void writeInt(int value) throws JMSException {
        this.initializeWriting();
        try {
            this.dataOut.writeInt(value);
        }
        catch (IOException ioe) {
            JMSException jmsEx = new JMSException("Could not write data:" + ioe.getMessage());
            jmsEx.setLinkedException((Exception)ioe);
            throw jmsEx;
        }
    }

    public void writeLong(long value) throws JMSException {
        this.initializeWriting();
        try {
            this.dataOut.writeLong(value);
        }
        catch (IOException ioe) {
            JMSException jmsEx = new JMSException("Could not write data:" + ioe.getMessage());
            jmsEx.setLinkedException((Exception)ioe);
            throw jmsEx;
        }
    }

    public void writeFloat(float value) throws JMSException {
        this.initializeWriting();
        try {
            this.dataOut.writeFloat(value);
        }
        catch (IOException ioe) {
            JMSException jmsEx = new JMSException("Could not write data:" + ioe.getMessage());
            jmsEx.setLinkedException((Exception)ioe);
            throw jmsEx;
        }
    }

    public void writeDouble(double value) throws JMSException {
        this.initializeWriting();
        try {
            this.dataOut.writeDouble(value);
        }
        catch (IOException ioe) {
            JMSException jmsEx = new JMSException("Could not write data:" + ioe.getMessage());
            jmsEx.setLinkedException((Exception)ioe);
            throw jmsEx;
        }
    }

    public void writeUTF(String value) throws JMSException {
        this.initializeWriting();
        try {
            this.dataOut.writeUTF(value);
        }
        catch (IOException ioe) {
            JMSException jmsEx = new JMSException("Could not write data:" + ioe.getMessage());
            jmsEx.setLinkedException((Exception)ioe);
            throw jmsEx;
        }
    }

    public void writeBytes(byte[] value) throws JMSException {
        this.initializeWriting();
        try {
            this.dataOut.write(value);
        }
        catch (IOException ioe) {
            JMSException jmsEx = new JMSException("Could not write data:" + ioe.getMessage());
            jmsEx.setLinkedException((Exception)ioe);
            throw jmsEx;
        }
    }

    public void writeBytes(byte[] value, int offset, int length) throws JMSException {
        this.initializeWriting();
        try {
            this.dataOut.write(value, offset, length);
        }
        catch (IOException ioe) {
            JMSException jmsEx = new JMSException("Could not write data:" + ioe.getMessage());
            jmsEx.setLinkedException((Exception)ioe);
            throw jmsEx;
        }
    }

    public void writeObject(Object value) throws JMSException {
        if (value == null) {
            throw new NullPointerException();
        }
        this.initializeWriting();
        if (value instanceof Boolean) {
            this.writeBoolean((Boolean)value);
        } else if (value instanceof Character) {
            this.writeChar(((Character)value).charValue());
        } else if (value instanceof Byte) {
            this.writeByte((Byte)value);
        } else if (value instanceof Short) {
            this.writeShort((Short)value);
        } else if (value instanceof Integer) {
            this.writeInt((Integer)value);
        } else if (value instanceof Double) {
            this.writeDouble((Double)value);
        } else if (value instanceof Long) {
            this.writeLong((Long)value);
        } else if (value instanceof Float) {
            this.writeFloat(((Float)value).floatValue());
        } else if (value instanceof Double) {
            this.writeDouble((Double)value);
        } else if (value instanceof String) {
            this.writeUTF(value.toString());
        } else if (value instanceof byte[]) {
            this.writeBytes((byte[])value);
        } else {
            throw new MessageFormatException("Cannot write non-primitive type:" + value.getClass());
        }
    }

    public void reset() throws JMSException {
        this.storeContent();
        this.bytesOut = null;
        this.dataIn = null;
        this.dataOut = null;
    }

    private void initializeWriting() throws MessageNotWriteableException {
        this.checkReadOnlyBody();
        if (this.dataOut == null) {
            this.bytesOut = new ByteArrayOutputStream();
            this.dataOut = new DataOutputStream(this.bytesOut);
        }
    }

    private void initializeReading() throws MessageNotReadableException {
        this.checkWriteOnlyBody();
        if (this.dataIn == null) {
            ByteArrayInputStream bytesIn = new ByteArrayInputStream(this._body.toByteArray());
            this.dataIn = new DataInputStream(bytesIn);
        }
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        NevadoBytesMessage that = (NevadoBytesMessage)o;
        if (this._messageID != null ? !this._messageID.equals(that._messageID) : that._messageID != null) {
            return false;
        }
        return !(this._body != null ? !this._body.equals(that._body) : that._body != null);
    }

    public int hashCode() {
        return new HashCodeBuilder().append((Object)this._messageID).append((Object)this._body).toHashCode();
    }
}

