/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hive.ql.exec.vector;

import java.util.Collection;
import java.util.HashMap;
import java.util.Map;
import java.util.concurrent.Future;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.hive.ql.exec.MapJoinOperator;
import org.apache.hadoop.hive.ql.exec.persistence.HybridHashTableContainer;
import org.apache.hadoop.hive.ql.exec.persistence.MapJoinTableContainer;
import org.apache.hadoop.hive.ql.exec.persistence.ObjectContainer;
import org.apache.hadoop.hive.ql.exec.vector.VectorAssignRowSameBatch;
import org.apache.hadoop.hive.ql.exec.vector.VectorizationContext;
import org.apache.hadoop.hive.ql.exec.vector.VectorizationContextRegion;
import org.apache.hadoop.hive.ql.exec.vector.VectorizedBatchUtil;
import org.apache.hadoop.hive.ql.exec.vector.VectorizedRowBatch;
import org.apache.hadoop.hive.ql.exec.vector.VectorizedRowBatchCtx;
import org.apache.hadoop.hive.ql.metadata.HiveException;
import org.apache.hadoop.hive.ql.plan.MapJoinDesc;
import org.apache.hadoop.hive.ql.plan.OperatorDesc;
import org.apache.hadoop.hive.serde2.objectinspector.ObjectInspector;
import org.apache.hadoop.hive.serde2.objectinspector.StructObjectInspector;
import org.apache.hadoop.io.DataOutputBuffer;

public class VectorMapJoinBaseOperator
extends MapJoinOperator
implements VectorizationContextRegion {
    private static final Log LOG = LogFactory.getLog((String)VectorMapJoinBaseOperator.class.getName());
    private static final long serialVersionUID = 1L;
    protected VectorizationContext vOutContext;
    protected transient VectorizedRowBatch outputBatch;
    protected transient VectorizedRowBatch scratchBatch;
    protected transient Map<ObjectInspector, VectorAssignRowSameBatch> outputVectorAssignRowMap;
    protected transient VectorizedRowBatchCtx vrbCtx = null;
    protected transient int tag;

    public VectorMapJoinBaseOperator() {
    }

    public VectorMapJoinBaseOperator(VectorizationContext vContext, OperatorDesc conf) throws HiveException {
        MapJoinDesc desc = (MapJoinDesc)conf;
        this.conf = desc;
        this.order = desc.getTagOrder();
        this.numAliases = desc.getExprs().size();
        this.posBigTable = (byte)desc.getPosBigTable();
        this.filterMaps = desc.getFilterMap();
        this.noOuterJoin = desc.isNoOuterJoin();
        this.vOutContext = new VectorizationContext(this.getName(), desc.getOutputColumnNames());
    }

    @Override
    public Collection<Future<?>> initializeOp(Configuration hconf) throws HiveException {
        Collection<Future<?>> result = super.initializeOp(hconf);
        this.vrbCtx = new VectorizedRowBatchCtx();
        this.vrbCtx.init(this.vOutContext.getScratchColumnTypeMap(), (StructObjectInspector)this.outputObjInspector);
        this.outputBatch = this.vrbCtx.createVectorizedRowBatch();
        this.outputVectorAssignRowMap = new HashMap<ObjectInspector, VectorAssignRowSameBatch>();
        return result;
    }

    @Override
    protected void internalForward(Object row, ObjectInspector outputOI) throws HiveException {
        Object[] values = (Object[])row;
        VectorAssignRowSameBatch va = this.outputVectorAssignRowMap.get(outputOI);
        if (va == null) {
            va = new VectorAssignRowSameBatch();
            va.init((StructObjectInspector)outputOI, this.vOutContext.getProjectedColumns());
            va.setOneBatch(this.outputBatch);
            this.outputVectorAssignRowMap.put(outputOI, va);
        }
        va.assignRow(this.outputBatch.size, values);
        ++this.outputBatch.size;
        if (this.outputBatch.size == 1024) {
            this.flushOutput();
        }
    }

    private void flushOutput() throws HiveException {
        this.forward(this.outputBatch, null);
        this.outputBatch.reset();
    }

    @Override
    public void closeOp(boolean aborted) throws HiveException {
        super.closeOp(aborted);
        for (MapJoinTableContainer tableContainer : this.mapJoinTables) {
            if (tableContainer == null) continue;
            tableContainer.dumpMetrics();
        }
        if (!aborted && 0 < this.outputBatch.size) {
            this.flushOutput();
        }
    }

    @Override
    protected void reProcessBigTable(int partitionId) throws HiveException {
        if (this.scratchBatch == null) {
            return;
        }
        HybridHashTableContainer.HashPartition partition = this.firstSmallTable.getHashPartitions()[partitionId];
        ObjectContainer bigTable = partition.getMatchfileObjContainer();
        DataOutputBuffer dataOutputBuffer = new DataOutputBuffer();
        while (bigTable.hasNext()) {
            Object row = bigTable.next();
            VectorizedBatchUtil.addProjectedRowToBatchFrom(row, (StructObjectInspector)this.inputObjInspectors[this.posBigTable], this.scratchBatch.size, this.scratchBatch, dataOutputBuffer);
            ++this.scratchBatch.size;
            if (this.scratchBatch.size != 1024) continue;
            this.process(this.scratchBatch, this.tag);
            this.scratchBatch.reset();
            dataOutputBuffer.reset();
        }
        if (this.scratchBatch.size > 0) {
            this.process(this.scratchBatch, this.tag);
            this.scratchBatch.reset();
            dataOutputBuffer.reset();
        }
        bigTable.clear();
    }

    @Override
    public VectorizationContext getOuputVectorizationContext() {
        return this.vOutContext;
    }
}

