/*
 * Decompiled with CFR 0.152.
 */
package org.springdoc.core.customizers;

import io.swagger.v3.oas.models.OpenAPI;
import io.swagger.v3.oas.models.PathItem;
import io.swagger.v3.oas.models.media.Schema;
import io.swagger.v3.oas.models.media.StringSchema;
import io.swagger.v3.oas.models.parameters.PathParameter;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.springdoc.core.customizers.OpenApiCustomiser;
import org.springframework.boot.actuate.autoconfigure.endpoint.web.WebEndpointProperties;
import org.springframework.util.CollectionUtils;

public class ActuatorOpenApiCustomizer
implements OpenApiCustomiser {
    private final Pattern pathPathern = Pattern.compile("\\{(.*?)}");
    private WebEndpointProperties webEndpointProperties;

    public ActuatorOpenApiCustomizer(WebEndpointProperties webEndpointProperties) {
        this.webEndpointProperties = webEndpointProperties;
    }

    @Override
    public void customise(OpenAPI openApi) {
        if (!CollectionUtils.isEmpty((Map)openApi.getPaths())) {
            openApi.getPaths().entrySet().stream().filter(stringPathItemEntry -> ((String)stringPathItemEntry.getKey()).startsWith(this.webEndpointProperties.getBasePath() + "/")).forEach(stringPathItemEntry -> {
                String path = (String)stringPathItemEntry.getKey();
                Matcher matcher = this.pathPathern.matcher(path);
                while (matcher.find()) {
                    String pathParam = matcher.group(1);
                    PathItem pathItem = (PathItem)stringPathItemEntry.getValue();
                    pathItem.readOperations().forEach(operation -> {
                        List existingParameters = operation.getParameters();
                        Optional<Object> existingParam = Optional.empty();
                        if (!CollectionUtils.isEmpty((Collection)existingParameters)) {
                            existingParam = existingParameters.stream().filter(p -> pathParam.equals(p.getName())).findAny();
                        }
                        if (!existingParam.isPresent()) {
                            operation.addParametersItem(new PathParameter().name(pathParam).schema((Schema)new StringSchema()));
                        }
                    });
                }
            });
        }
    }
}

