/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.cloud.kubernetes.config;

import io.fabric8.kubernetes.api.model.Secret;
import io.fabric8.kubernetes.api.model.SecretList;
import io.fabric8.kubernetes.client.KubernetesClient;
import io.fabric8.kubernetes.client.dsl.FilterWatchListDeletable;
import io.fabric8.kubernetes.client.dsl.NonNamespaceOperation;
import io.fabric8.kubernetes.client.dsl.Resource;
import java.util.Base64;
import java.util.HashMap;
import java.util.Map;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.springframework.core.env.Environment;
import org.springframework.core.env.MapPropertySource;
import org.springframework.util.StringUtils;

public class SecretsPropertySource
extends MapPropertySource {
    private static final Log LOG = LogFactory.getLog(SecretsPropertySource.class);
    private static final String PREFIX = "secrets";

    public SecretsPropertySource(KubernetesClient client, Environment env, String name, String namespace, Map<String, String> labels) {
        super(SecretsPropertySource.getSourceName(client, env, name, namespace), SecretsPropertySource.getSourceData(client, env, name, namespace, labels));
    }

    private static String getSourceName(KubernetesClient client, Environment env, String name, String namespace) {
        return PREFIX + "." + name + "." + namespace;
    }

    private static Map<String, Object> getSourceData(KubernetesClient client, Environment env, String name, String namespace, Map<String, String> labels) {
        HashMap<String, Object> result = new HashMap<String, Object>();
        try {
            Secret secret = StringUtils.isEmpty((Object)namespace) ? (Secret)((Resource)client.secrets().withName(name)).get() : (Secret)((Resource)((NonNamespaceOperation)client.secrets().inNamespace(namespace)).withName(name)).get();
            SecretsPropertySource.putAll(secret, result);
            if (!labels.isEmpty()) {
                if (StringUtils.isEmpty((Object)namespace)) {
                    ((SecretList)((FilterWatchListDeletable)client.secrets().withLabels(labels)).list()).getItems().forEach(s -> SecretsPropertySource.putAll(s, result));
                } else {
                    ((SecretList)((FilterWatchListDeletable)((NonNamespaceOperation)client.secrets().inNamespace(namespace)).withLabels(labels)).list()).getItems().forEach(s -> SecretsPropertySource.putAll(s, result));
                }
            }
        }
        catch (Exception e) {
            LOG.warn((Object)("Can't read secret with name: [" + name + "] or labels [" + labels + "] in namespace:[" + namespace + "] (cause: " + e.getMessage() + "). Ignoring"));
        }
        return result;
    }

    private static void putAll(Secret secret, Map<String, Object> result) {
        if (secret != null && secret.getData() != null) {
            secret.getData().forEach((k, v) -> result.put((String)k, new String(Base64.getDecoder().decode((String)v)).trim()));
        }
    }

    public String toString() {
        return ((Object)((Object)this)).getClass().getSimpleName() + " {name='" + this.name + "'}";
    }
}

