/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.data.elasticsearch.core.geo;

import java.util.Objects;
import org.springframework.data.geo.Point;

public class GeoPoint {
    private double lat;
    private double lon;

    private GeoPoint() {
    }

    public GeoPoint(double latitude, double longitude) {
        this.lat = latitude;
        this.lon = longitude;
    }

    public double getLat() {
        return this.lat;
    }

    public double getLon() {
        return this.lon;
    }

    public static GeoPoint fromPoint(Point point) {
        return new GeoPoint(point.getX(), point.getY());
    }

    public static Point toPoint(GeoPoint point) {
        return new Point(point.getLat(), point.getLon());
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        GeoPoint geoPoint = (GeoPoint)o;
        return Double.compare(geoPoint.lat, this.lat) == 0 && Double.compare(geoPoint.lon, this.lon) == 0;
    }

    public int hashCode() {
        return Objects.hash(this.lat, this.lon);
    }

    public String toString() {
        return "GeoPoint{lat=" + this.lat + ", lon=" + this.lon + '}';
    }
}

