/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.data.elasticsearch.core;

import java.util.Map;
import java.util.Set;
import org.springframework.data.elasticsearch.core.document.Document;
import org.springframework.data.elasticsearch.core.index.AliasActions;
import org.springframework.data.elasticsearch.core.index.AliasData;
import org.springframework.data.elasticsearch.core.index.DeleteTemplateRequest;
import org.springframework.data.elasticsearch.core.index.ExistsTemplateRequest;
import org.springframework.data.elasticsearch.core.index.GetTemplateRequest;
import org.springframework.data.elasticsearch.core.index.PutTemplateRequest;
import org.springframework.data.elasticsearch.core.index.TemplateData;
import org.springframework.data.elasticsearch.core.mapping.IndexCoordinates;
import reactor.core.publisher.Mono;

public interface ReactiveIndexOperations {
    public Mono<Boolean> create();

    public Mono<Boolean> create(Document var1);

    public Mono<Boolean> delete();

    public Mono<Boolean> exists();

    public Mono<Void> refresh();

    public Mono<Document> createMapping();

    public Mono<Document> createMapping(Class<?> var1);

    default public Mono<Boolean> putMapping() {
        return this.putMapping(this.createMapping());
    }

    public Mono<Boolean> putMapping(Mono<Document> var1);

    default public Mono<Boolean> putMapping(Class<?> clazz) {
        return this.putMapping(this.createMapping(clazz));
    }

    public Mono<Document> getMapping();

    public Mono<Document> createSettings();

    public Mono<Document> createSettings(Class<?> var1);

    default public Mono<Document> getSettings() {
        return this.getSettings(false);
    }

    public Mono<Document> getSettings(boolean var1);

    public Mono<Boolean> alias(AliasActions var1);

    public Mono<Map<String, Set<AliasData>>> getAliases(String ... var1);

    public Mono<Map<String, Set<AliasData>>> getAliasesForIndex(String ... var1);

    public Mono<Boolean> putTemplate(PutTemplateRequest var1);

    default public Mono<TemplateData> getTemplate(String templateName) {
        return this.getTemplate(new GetTemplateRequest(templateName));
    }

    public Mono<TemplateData> getTemplate(GetTemplateRequest var1);

    default public Mono<Boolean> existsTemplate(String templateName) {
        return this.existsTemplate(new ExistsTemplateRequest(templateName));
    }

    public Mono<Boolean> existsTemplate(ExistsTemplateRequest var1);

    default public Mono<Boolean> deleteTemplate(String templateName) {
        return this.deleteTemplate(new DeleteTemplateRequest(templateName));
    }

    public Mono<Boolean> deleteTemplate(DeleteTemplateRequest var1);

    public IndexCoordinates getIndexCoordinates();
}

