/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.data.elasticsearch.core.convert;

import java.lang.reflect.Field;
import java.time.temporal.TemporalAccessor;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.Set;
import java.util.concurrent.ConcurrentHashMap;
import java.util.stream.Collectors;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.BeansException;
import org.springframework.beans.factory.InitializingBean;
import org.springframework.context.ApplicationContext;
import org.springframework.context.ApplicationContextAware;
import org.springframework.core.CollectionFactory;
import org.springframework.core.convert.ConversionService;
import org.springframework.core.convert.converter.ConverterRegistry;
import org.springframework.core.convert.support.DefaultConversionService;
import org.springframework.core.convert.support.GenericConversionService;
import org.springframework.data.convert.CustomConversions;
import org.springframework.data.elasticsearch.ElasticsearchException;
import org.springframework.data.elasticsearch.annotations.ScriptedField;
import org.springframework.data.elasticsearch.core.convert.ConversionException;
import org.springframework.data.elasticsearch.core.convert.ElasticsearchConverter;
import org.springframework.data.elasticsearch.core.convert.ElasticsearchCustomConversions;
import org.springframework.data.elasticsearch.core.convert.ElasticsearchTypeMapper;
import org.springframework.data.elasticsearch.core.document.Document;
import org.springframework.data.elasticsearch.core.document.SearchDocument;
import org.springframework.data.elasticsearch.core.join.JoinField;
import org.springframework.data.elasticsearch.core.mapping.ElasticsearchPersistentEntity;
import org.springframework.data.elasticsearch.core.mapping.ElasticsearchPersistentProperty;
import org.springframework.data.elasticsearch.core.mapping.ElasticsearchPersistentPropertyConverter;
import org.springframework.data.elasticsearch.core.query.Criteria;
import org.springframework.data.elasticsearch.core.query.CriteriaQuery;
import org.springframework.data.elasticsearch.core.query.SeqNoPrimaryTerm;
import org.springframework.data.mapping.PersistentProperty;
import org.springframework.data.mapping.PersistentPropertyAccessor;
import org.springframework.data.mapping.context.MappingContext;
import org.springframework.data.mapping.model.ConvertingPropertyAccessor;
import org.springframework.data.mapping.model.EntityInstantiator;
import org.springframework.data.mapping.model.EntityInstantiators;
import org.springframework.data.mapping.model.ParameterValueProvider;
import org.springframework.data.mapping.model.PersistentEntityParameterValueProvider;
import org.springframework.data.mapping.model.PropertyValueProvider;
import org.springframework.data.util.ClassTypeInformation;
import org.springframework.data.util.Streamable;
import org.springframework.data.util.TypeInformation;
import org.springframework.format.datetime.DateFormatterRegistrar;
import org.springframework.lang.Nullable;
import org.springframework.util.Assert;
import org.springframework.util.ClassUtils;
import org.springframework.util.ObjectUtils;

public class MappingElasticsearchConverter
implements ElasticsearchConverter,
ApplicationContextAware,
InitializingBean {
    private static final Logger LOGGER = LoggerFactory.getLogger(MappingElasticsearchConverter.class);
    private final MappingContext<? extends ElasticsearchPersistentEntity<?>, ElasticsearchPersistentProperty> mappingContext;
    private final GenericConversionService conversionService;
    @Nullable
    private CustomConversions conversions = null;
    private final EntityInstantiators instantiators = new EntityInstantiators();
    private final ElasticsearchTypeMapper typeMapper;
    private final ConcurrentHashMap<String, Integer> propertyWarnings = new ConcurrentHashMap();

    public MappingElasticsearchConverter(MappingContext<? extends ElasticsearchPersistentEntity<?>, ElasticsearchPersistentProperty> mappingContext) {
        this(mappingContext, null);
    }

    public MappingElasticsearchConverter(MappingContext<? extends ElasticsearchPersistentEntity<?>, ElasticsearchPersistentProperty> mappingContext, @Nullable GenericConversionService conversionService) {
        Assert.notNull(mappingContext, (String)"MappingContext must not be null!");
        this.mappingContext = mappingContext;
        this.conversionService = conversionService != null ? conversionService : new DefaultConversionService();
        this.typeMapper = ElasticsearchTypeMapper.create(mappingContext);
    }

    public void setApplicationContext(ApplicationContext applicationContext) throws BeansException {
        if (this.mappingContext instanceof ApplicationContextAware) {
            ((ApplicationContextAware)this.mappingContext).setApplicationContext(applicationContext);
        }
    }

    public MappingContext<? extends ElasticsearchPersistentEntity<?>, ElasticsearchPersistentProperty> getMappingContext() {
        return this.mappingContext;
    }

    public ConversionService getConversionService() {
        return this.conversionService;
    }

    public void setConversions(CustomConversions conversions) {
        this.conversions = conversions;
    }

    private CustomConversions getConversions() {
        if (this.conversions == null) {
            this.conversions = new ElasticsearchCustomConversions(Collections.emptyList());
        }
        return this.conversions;
    }

    public void afterPropertiesSet() {
        DateFormatterRegistrar.addDateConverters((ConverterRegistry)this.conversionService);
        this.getConversions().registerConvertersIn((ConverterRegistry)this.conversionService);
    }

    public <R> R read(Class<R> type, Document source) {
        ClassTypeInformation typeHint = ClassTypeInformation.from((Class)ClassUtils.getUserClass(type));
        typeHint = this.typeMapper.readType(source, (TypeInformation)typeHint);
        if (this.getConversions().hasCustomReadTarget(Map.class, typeHint.getType())) {
            Object converted = this.conversionService.convert((Object)source, typeHint.getType());
            if (converted == null) {
                throw new ConversionException("conversion service to type " + typeHint.getType().getName() + " returned null");
            }
            return (R)converted;
        }
        if (typeHint.isMap() || ClassTypeInformation.OBJECT.equals((Object)typeHint)) {
            return (R)source;
        }
        ElasticsearchPersistentEntity entity = (ElasticsearchPersistentEntity)this.mappingContext.getRequiredPersistentEntity((TypeInformation)typeHint);
        return this.readEntity(entity, source);
    }

    protected <R> R readEntity(ElasticsearchPersistentEntity<?> entity, Map<String, Object> source) {
        ElasticsearchPersistentEntity<?> targetEntity = this.computeClosestEntity(entity, source);
        ElasticsearchPropertyValueProvider propertyValueProvider = new ElasticsearchPropertyValueProvider(new MapValueAccessor(source));
        EntityInstantiator instantiator = this.instantiators.getInstantiatorFor(targetEntity);
        Object instance = instantiator.createInstance(targetEntity, (ParameterValueProvider)new PersistentEntityParameterValueProvider(targetEntity, (PropertyValueProvider)propertyValueProvider, null));
        if (!targetEntity.requiresPropertyPopulation()) {
            return (R)instance;
        }
        Object result = this.readProperties(targetEntity, instance, propertyValueProvider);
        if (source instanceof Document) {
            Document document = (Document)source;
            if (document.hasId()) {
                ElasticsearchPersistentProperty idProperty = (ElasticsearchPersistentProperty)targetEntity.getIdProperty();
                ConvertingPropertyAccessor accessor = new ConvertingPropertyAccessor(targetEntity.getPropertyAccessor(result), (ConversionService)this.conversionService);
                if (idProperty != null && idProperty.getType().isAssignableFrom(String.class)) {
                    accessor.setProperty((PersistentProperty)idProperty, (Object)document.getId());
                }
            }
            if (document.hasVersion()) {
                long version = document.getVersion();
                ElasticsearchPersistentProperty versionProperty = targetEntity.getVersionProperty();
                if (versionProperty != null && versionProperty.getType().isAssignableFrom(Long.class)) {
                    Assert.isTrue((version != -1L ? 1 : 0) != 0, (String)"Version in response is -1");
                    targetEntity.getPropertyAccessor(result).setProperty((PersistentProperty)versionProperty, (Object)version);
                }
            }
            if (targetEntity.hasSeqNoPrimaryTermProperty() && document.hasSeqNo() && document.hasPrimaryTerm() && this.isAssignedSeqNo(document.getSeqNo()) && this.isAssignedPrimaryTerm(document.getPrimaryTerm())) {
                SeqNoPrimaryTerm seqNoPrimaryTerm = new SeqNoPrimaryTerm(document.getSeqNo(), document.getPrimaryTerm());
                ElasticsearchPersistentProperty property = targetEntity.getRequiredSeqNoPrimaryTermProperty();
                targetEntity.getPropertyAccessor(result).setProperty((PersistentProperty)property, (Object)seqNoPrimaryTerm);
            }
        }
        if (source instanceof SearchDocument) {
            SearchDocument searchDocument = (SearchDocument)source;
            if (targetEntity.hasScoreProperty()) {
                targetEntity.getPropertyAccessor(result).setProperty((PersistentProperty)targetEntity.getScoreProperty(), (Object)Float.valueOf(searchDocument.getScore()));
            }
            this.populateScriptFields(result, searchDocument);
        }
        return (R)result;
    }

    private boolean isAssignedSeqNo(long seqNo) {
        return seqNo >= 0L;
    }

    private boolean isAssignedPrimaryTerm(long primaryTerm) {
        return primaryTerm > 0L;
    }

    protected <R> R readProperties(ElasticsearchPersistentEntity<?> entity, R instance, ElasticsearchPropertyValueProvider valueProvider) {
        ConvertingPropertyAccessor accessor = new ConvertingPropertyAccessor(entity.getPropertyAccessor(instance), (ConversionService)this.conversionService);
        Iterator iterator = entity.iterator();
        while (iterator.hasNext()) {
            Object value;
            ElasticsearchPersistentProperty prop = (ElasticsearchPersistentProperty)iterator.next();
            if (entity.isConstructorArgument(prop) || prop.isScoreProperty() || !prop.isReadable() || (value = valueProvider.getPropertyValue(prop)) == null) continue;
            accessor.setProperty((PersistentProperty)prop, value);
        }
        return (R)accessor.getBean();
    }

    @Nullable
    protected <R> R readValue(@Nullable Object source, ElasticsearchPersistentProperty property, TypeInformation<R> targetType) {
        String propertyName;
        String key;
        int count;
        if (source == null) {
            return null;
        }
        Class rawType = targetType.getType();
        if (property.hasPropertyConverter()) {
            source = this.propertyConverterRead(property, source);
        } else if (TemporalAccessor.class.isAssignableFrom(property.getType()) && !this.getConversions().hasCustomReadTarget(source.getClass(), rawType) && (count = this.propertyWarnings.computeIfAbsent(key = (propertyName = property.getOwner().getType().getSimpleName() + '.' + property.getName()) + "-read", k -> 0).intValue()) < 5) {
            LOGGER.warn("Type {} of property {} is a TemporalAccessor class but has neither a @Field annotation defining the date type nor a registered converter for reading! It cannot be mapped from a complex object in Elasticsearch!", (Object)property.getType().getSimpleName(), (Object)propertyName);
            this.propertyWarnings.put(key, count + 1);
        }
        if (this.getConversions().hasCustomReadTarget(source.getClass(), rawType)) {
            return (R)rawType.cast(this.conversionService.convert(source, rawType));
        }
        if (source instanceof List) {
            return this.readCollectionValue((List)source, property, targetType);
        }
        if (source instanceof Map) {
            return this.readMapValue((Map)source, property, targetType);
        }
        return (R)this.readSimpleValue(source, targetType);
    }

    private Object propertyConverterRead(ElasticsearchPersistentProperty property, Object source) {
        ElasticsearchPersistentPropertyConverter propertyConverter = Objects.requireNonNull(property.getPropertyConverter());
        if (source instanceof String[]) {
            source = Arrays.asList((String[])source);
        }
        source = source instanceof List ? source.stream().map(it -> this.convertOnRead(propertyConverter, it)).collect(Collectors.toList()) : (source instanceof Set ? ((Set)source).stream().map(it -> this.convertOnRead(propertyConverter, it)).collect(Collectors.toSet()) : this.convertOnRead(propertyConverter, source));
        return source;
    }

    private Object convertOnRead(ElasticsearchPersistentPropertyConverter propertyConverter, Object source) {
        if (String.class.isAssignableFrom(source.getClass())) {
            source = propertyConverter.read((String)source);
        }
        return source;
    }

    @Nullable
    private <R> R readCollectionValue(@Nullable List<?> source, ElasticsearchPersistentProperty property, TypeInformation<R> targetType) {
        if (source == null) {
            return null;
        }
        Collection<Object> target = this.createCollectionForValue(targetType, source.size());
        TypeInformation<R> componentType = targetType.getComponentType();
        for (Object value : source) {
            if (value == null) {
                target.add(null);
                continue;
            }
            if (componentType != null && !ClassTypeInformation.OBJECT.equals((Object)componentType) && this.isSimpleType(componentType.getType())) {
                target.add(this.readSimpleValue(value, componentType));
                continue;
            }
            if (this.isSimpleType(value)) {
                target.add(this.readSimpleValue(value, componentType != null ? componentType : targetType));
                continue;
            }
            if (value instanceof List) {
                target.add(this.readValue(value, property, property.getTypeInformation().getActualType()));
                continue;
            }
            if (!(value instanceof Map)) continue;
            target.add(this.readMapValue((Map)value, property, property.getTypeInformation().getActualType()));
        }
        return (R)target;
    }

    private <R> R readMapValue(@Nullable Map<String, Object> source, ElasticsearchPersistentProperty property, TypeInformation<R> targetType) {
        TypeInformation information = this.typeMapper.readType(source);
        if (property.isEntity() && !property.isMap() || information != null) {
            ElasticsearchPersistentEntity targetEntity = information != null ? (ElasticsearchPersistentEntity)this.mappingContext.getRequiredPersistentEntity(information) : (ElasticsearchPersistentEntity)this.mappingContext.getRequiredPersistentEntity((PersistentProperty)property);
            return this.readEntity(targetEntity, source);
        }
        LinkedHashMap<String, Object> target = new LinkedHashMap<String, Object>();
        for (Map.Entry<String, Object> entry : source.entrySet()) {
            String entryKey = entry.getKey();
            Object entryValue = entry.getValue();
            if (entryValue == null) {
                target.put(entryKey, null);
                continue;
            }
            if (this.isSimpleType(entryValue)) {
                target.put(entryKey, this.readSimpleValue(entryValue, targetType.isMap() ? targetType.getMapValueType() : targetType));
                continue;
            }
            ElasticsearchPersistentEntity<?> targetEntity = this.computeGenericValueTypeForRead(property, entryValue);
            if (targetEntity.getTypeInformation().isMap()) {
                Map valueMap = (Map)entryValue;
                if (this.typeMapper.containsTypeInformation(valueMap)) {
                    target.put(entryKey, this.readEntity(targetEntity, valueMap));
                    continue;
                }
                target.put(entryKey, this.readValue(valueMap, property, targetEntity.getTypeInformation()));
                continue;
            }
            if (targetEntity.getTypeInformation().isCollectionLike()) {
                target.put(entryKey, this.readValue(entryValue, property, targetEntity.getTypeInformation().getActualType()));
                continue;
            }
            target.put(entryKey, this.readEntity(targetEntity, (Map)entryValue));
        }
        return (R)target;
    }

    @Nullable
    private Object readSimpleValue(@Nullable Object value, TypeInformation<?> targetType) {
        Class target = targetType.getType();
        if (value == null || ClassUtils.isAssignableValue((Class)target, (Object)value)) {
            return value;
        }
        if (this.getConversions().hasCustomReadTarget(value.getClass(), target)) {
            return this.conversionService.convert(value, target);
        }
        if (Enum.class.isAssignableFrom(target)) {
            return Enum.valueOf(target, value.toString());
        }
        return this.conversionService.convert(value, target);
    }

    private <T> void populateScriptFields(T result, SearchDocument searchDocument) {
        Map<String, List<Object>> fields = searchDocument.getFields();
        if (!fields.isEmpty()) {
            for (Field field : result.getClass().getDeclaredFields()) {
                String name;
                Object value;
                ScriptedField scriptedField = field.getAnnotation(ScriptedField.class);
                if (scriptedField == null || (value = searchDocument.getFieldValue(name = scriptedField.name().isEmpty() ? field.getName() : scriptedField.name())) == null) continue;
                field.setAccessible(true);
                try {
                    field.set(result, value);
                }
                catch (IllegalArgumentException e) {
                    throw new ElasticsearchException("failed to set scripted field: " + name + " with value: " + value, e);
                }
                catch (IllegalAccessException e) {
                    throw new ElasticsearchException("failed to access scripted field: " + name, e);
                }
            }
        }
    }

    public void write(Object source, Document sink) {
        Optional customTarget;
        Assert.notNull((Object)source, (String)"source to map must not be null");
        if (source instanceof Map) {
            sink.putAll((Map)source);
            return;
        }
        Class entityType = ClassUtils.getUserClass(source.getClass());
        ClassTypeInformation type = ClassTypeInformation.from((Class)entityType);
        if (this.requiresTypeHint((TypeInformation<?>)type, source.getClass(), null)) {
            this.typeMapper.writeType(source.getClass(), sink);
        }
        if ((customTarget = this.getConversions().getCustomWriteTarget(entityType, Map.class)).isPresent()) {
            sink.putAll((Map)this.conversionService.convert(source, Map.class));
            return;
        }
        ElasticsearchPersistentEntity entity = type.getType().equals(entityType) ? (ElasticsearchPersistentEntity)this.mappingContext.getRequiredPersistentEntity((TypeInformation)type) : (ElasticsearchPersistentEntity)this.mappingContext.getRequiredPersistentEntity(entityType);
        this.writeEntity(entity, source, sink, null);
    }

    protected void writeEntity(ElasticsearchPersistentEntity<?> entity, Object source, Document sink, @Nullable TypeInformation<?> containingStructure) {
        PersistentPropertyAccessor accessor = entity.getPropertyAccessor(source);
        if (this.requiresTypeHint(entity.getTypeInformation(), source.getClass(), containingStructure)) {
            this.typeMapper.writeType(source.getClass(), sink);
        }
        this.writeProperties(entity, accessor, new MapValueAccessor(sink));
    }

    protected void writeProperties(ElasticsearchPersistentEntity<?> entity, PersistentPropertyAccessor<?> accessor, MapValueAccessor sink) {
        Iterator iterator = entity.iterator();
        while (iterator.hasNext()) {
            String propertyName;
            String key;
            int count;
            ElasticsearchPersistentProperty property = (ElasticsearchPersistentProperty)iterator.next();
            if (!property.isWritable()) continue;
            Object value = accessor.getProperty((PersistentProperty)property);
            if (value == null) {
                if (!property.storeNullValue()) continue;
                sink.set(property, null);
                continue;
            }
            if (property.hasPropertyConverter()) {
                value = this.propertyConverterWrite(property, value);
            } else if (TemporalAccessor.class.isAssignableFrom(property.getActualType()) && !this.getConversions().hasCustomWriteTarget(value.getClass()) && (count = this.propertyWarnings.computeIfAbsent(key = (propertyName = entity.getType().getSimpleName() + '.' + property.getName()) + "-write", k -> 0).intValue()) < 5) {
                LOGGER.warn("Type {} of property {} is a TemporalAccessor class but has neither a @Field annotation defining the date type nor a registered converter for writing! It will be mapped to a complex object in Elasticsearch!", (Object)property.getType().getSimpleName(), (Object)propertyName);
                this.propertyWarnings.put(key, count + 1);
            }
            if (!this.isSimpleType(value)) {
                this.writeProperty(property, value, sink);
                continue;
            }
            Object writeSimpleValue = this.getWriteSimpleValue(value);
            if (writeSimpleValue == null) continue;
            sink.set(property, writeSimpleValue);
        }
    }

    private Object propertyConverterWrite(ElasticsearchPersistentProperty property, Object value) {
        ElasticsearchPersistentPropertyConverter propertyConverter = Objects.requireNonNull(property.getPropertyConverter());
        value = value instanceof List ? ((List)value).stream().map(propertyConverter::write).collect(Collectors.toList()) : (value instanceof Set ? ((Set)value).stream().map(propertyConverter::write).collect(Collectors.toSet()) : propertyConverter.write(value));
        return value;
    }

    protected void writeProperty(ElasticsearchPersistentProperty property, Object value, MapValueAccessor sink) {
        Optional customWriteTarget = this.getConversions().getCustomWriteTarget(value.getClass());
        if (customWriteTarget.isPresent()) {
            Class writeTarget = (Class)customWriteTarget.get();
            sink.set(property, this.conversionService.convert(value, writeTarget));
            return;
        }
        TypeInformation typeHint = property.getTypeInformation();
        if (typeHint.equals(ClassTypeInformation.OBJECT)) {
            if (value instanceof List) {
                typeHint = ClassTypeInformation.LIST;
            } else if (value instanceof Map) {
                typeHint = ClassTypeInformation.MAP;
            } else if (value instanceof Set) {
                typeHint = ClassTypeInformation.SET;
            } else if (value instanceof Collection) {
                typeHint = ClassTypeInformation.COLLECTION;
            }
        }
        sink.set(property, this.getWriteComplexValue(property, typeHint, value));
    }

    @Nullable
    protected Object getWriteSimpleValue(Object value) {
        Optional customTarget = this.getConversions().getCustomWriteTarget(value.getClass());
        if (customTarget.isPresent()) {
            return this.conversionService.convert(value, (Class)customTarget.get());
        }
        return Enum.class.isAssignableFrom(value.getClass()) ? ((Enum)value).name() : value;
    }

    protected Object getWriteComplexValue(ElasticsearchPersistentProperty property, TypeInformation<?> typeHint, Object value) {
        if (typeHint.isCollectionLike() || value instanceof Iterable) {
            return this.writeCollectionValue(value, property, typeHint);
        }
        if (typeHint.isMap()) {
            return this.writeMapValue((Map)value, property, typeHint);
        }
        if (property.isEntity() || !this.isSimpleType(value)) {
            return this.writeEntity(value, property);
        }
        return value;
    }

    private Object writeEntity(Object value, ElasticsearchPersistentProperty property) {
        Document target = Document.create();
        this.writeEntity((ElasticsearchPersistentEntity)this.mappingContext.getRequiredPersistentEntity(value.getClass()), value, target, property.getTypeInformation());
        return target;
    }

    private Object writeMapValue(Map<String, Object> value, ElasticsearchPersistentProperty property, TypeInformation<?> typeHint) {
        LinkedHashMap target = new LinkedHashMap();
        Streamable mapSource = Streamable.of(value.entrySet());
        TypeInformation actualType = typeHint.getActualType();
        if (actualType != null && !actualType.getType().equals(Object.class) && this.isSimpleType(typeHint.getMapValueType().getType())) {
            mapSource.forEach(it -> {
                if (it.getValue() == null) {
                    target.put(it.getKey(), null);
                } else {
                    target.put(it.getKey(), this.getWriteSimpleValue(it.getValue()));
                }
            });
        } else {
            mapSource.forEach(it -> {
                Object converted = null;
                if (it.getValue() != null) {
                    converted = this.isSimpleType(it.getValue()) ? this.getWriteSimpleValue(it.getValue()) : this.getWriteComplexValue(property, (TypeInformation<?>)ClassTypeInformation.from(it.getValue().getClass()), it.getValue());
                }
                target.put(it.getKey(), converted);
            });
        }
        return target;
    }

    private Object writeCollectionValue(Object value, ElasticsearchPersistentProperty property, TypeInformation<?> typeHint) {
        Class type;
        Streamable collectionSource = value instanceof Iterable ? Streamable.of((Iterable)((Iterable)value)) : Streamable.of((Object[])ObjectUtils.toObjectArray((Object)value));
        ArrayList target = new ArrayList();
        TypeInformation actualType = typeHint.getActualType();
        Class clazz = type = actualType != null ? actualType.getType() : null;
        if (type != null && !type.equals(Object.class) && this.isSimpleType(type)) {
            collectionSource.map(element -> element != null ? this.getWriteSimpleValue(element) : null).forEach(target::add);
        } else {
            collectionSource.map(it -> {
                if (it == null) {
                    return null;
                }
                if (this.isSimpleType(it)) {
                    return this.getWriteSimpleValue(it);
                }
                return this.getWriteComplexValue(property, (TypeInformation<?>)ClassTypeInformation.from(it.getClass()), it);
            }).forEach(target::add);
        }
        return target;
    }

    private Collection<Object> createCollectionForValue(TypeInformation<?> collectionTypeInformation, int size) {
        Class collectionType = collectionTypeInformation.isSubTypeOf(Collection.class) ? collectionTypeInformation.getType() : List.class;
        ClassTypeInformation componentType = collectionTypeInformation.getComponentType() != null ? collectionTypeInformation.getComponentType() : ClassTypeInformation.OBJECT;
        return collectionTypeInformation.getType().isArray() ? new ArrayList(size) : CollectionFactory.createCollection((Class)collectionType, (Class)componentType.getType(), (int)size);
    }

    private ElasticsearchPersistentEntity<?> computeGenericValueTypeForRead(ElasticsearchPersistentProperty property, Object value) {
        return ClassTypeInformation.OBJECT.equals((Object)property.getTypeInformation().getActualType()) ? (ElasticsearchPersistentEntity)this.mappingContext.getRequiredPersistentEntity(value.getClass()) : (ElasticsearchPersistentEntity)this.mappingContext.getRequiredPersistentEntity(property.getTypeInformation().getActualType());
    }

    private boolean requiresTypeHint(TypeInformation<?> type, Class<?> actualType, @Nullable TypeInformation<?> container) {
        if (container != null) {
            Class containerClass;
            if (container.isCollectionLike() && type.equals((Object)container.getActualType()) && type.getType().equals(actualType)) {
                return false;
            }
            if (container.isMap() && type.equals((Object)container.getMapValueType()) && type.getType().equals(actualType)) {
                return false;
            }
            if (container.equals(type) && type.getType().equals(actualType)) {
                return false;
            }
            if (container.getRawTypeInformation().equals(type) && (containerClass = container.getRawTypeInformation().getType()).equals(JoinField.class) && type.getType().equals(actualType)) {
                return false;
            }
        }
        return !this.getConversions().isSimpleType(type.getType()) && !type.isCollectionLike() && !this.getConversions().hasCustomWriteTarget(type.getType());
    }

    private ElasticsearchPersistentEntity<?> computeClosestEntity(ElasticsearchPersistentEntity<?> entity, Map<String, Object> source) {
        TypeInformation typeToUse = this.typeMapper.readType(source);
        if (typeToUse == null) {
            return entity;
        }
        if (!(entity.getTypeInformation().getType().isInterface() || entity.getTypeInformation().isCollectionLike() || entity.getTypeInformation().isMap() || ClassUtils.isAssignableValue((Class)entity.getType(), (Object)typeToUse.getType()))) {
            return entity;
        }
        return (ElasticsearchPersistentEntity)this.mappingContext.getRequiredPersistentEntity(typeToUse);
    }

    private boolean isSimpleType(Object value) {
        return this.isSimpleType(value.getClass());
    }

    private boolean isSimpleType(Class<?> type) {
        return this.getConversions().isSimpleType(type);
    }

    @Override
    public void updateCriteriaQuery(CriteriaQuery criteriaQuery, Class<?> domainClass) {
        ElasticsearchPersistentEntity persistentEntity = (ElasticsearchPersistentEntity)this.mappingContext.getPersistentEntity(domainClass);
        if (persistentEntity != null) {
            for (Criteria chainedCriteria : criteriaQuery.getCriteria().getCriteriaChain()) {
                this.updateCriteria(chainedCriteria, persistentEntity);
            }
        }
    }

    private void updateCriteria(Criteria criteria, ElasticsearchPersistentEntity<?> persistentEntity) {
        org.springframework.data.elasticsearch.core.query.Field field = criteria.getField();
        if (field == null) {
            return;
        }
        String name = field.getName();
        ElasticsearchPersistentProperty property = (ElasticsearchPersistentProperty)persistentEntity.getPersistentProperty(name);
        if (property != null && property.getName().equals(name)) {
            org.springframework.data.elasticsearch.annotations.Field fieldAnnotation;
            field.setName(property.getFieldName());
            if (property.hasPropertyConverter()) {
                ElasticsearchPersistentPropertyConverter propertyConverter = Objects.requireNonNull(property.getPropertyConverter());
                criteria.getQueryCriteriaEntries().forEach(criteriaEntry -> {
                    Object value = criteriaEntry.getValue();
                    if (value.getClass().isArray()) {
                        Object[] objects = (Object[])value;
                        for (int i = 0; i < objects.length; ++i) {
                            objects[i] = propertyConverter.write(objects[i]);
                        }
                    } else {
                        criteriaEntry.setValue(propertyConverter.write(value));
                    }
                });
            }
            if ((fieldAnnotation = (org.springframework.data.elasticsearch.annotations.Field)property.findAnnotation(org.springframework.data.elasticsearch.annotations.Field.class)) != null) {
                field.setFieldType(fieldAnnotation.type());
            }
        }
        for (Criteria subCriteria : criteria.getSubCriteria()) {
            for (Criteria chainedCriteria : subCriteria.getCriteriaChain()) {
                this.updateCriteria(chainedCriteria, persistentEntity);
            }
        }
    }

    class ElasticsearchPropertyValueProvider
    implements PropertyValueProvider<ElasticsearchPersistentProperty> {
        final MapValueAccessor mapValueAccessor;

        ElasticsearchPropertyValueProvider(MapValueAccessor mapValueAccessor) {
            this.mapValueAccessor = mapValueAccessor;
        }

        public <T> T getPropertyValue(ElasticsearchPersistentProperty property) {
            return (T)MappingElasticsearchConverter.this.readValue(this.mapValueAccessor.get(property), property, property.getTypeInformation());
        }
    }

    static class MapValueAccessor {
        final Map<String, Object> target;

        MapValueAccessor(Map<String, Object> target) {
            this.target = target;
        }

        @Nullable
        public Object get(ElasticsearchPersistentProperty property) {
            String fieldName = property.getFieldName();
            if (this.target instanceof Document) {
                Document document = (Document)this.target;
                if (property.isIdProperty() && document.hasId()) {
                    Object id = null;
                    if (!fieldName.contains(".")) {
                        id = this.target.get(fieldName);
                    }
                    return id != null ? id : document.getId();
                }
                if (property.isVersionProperty() && document.hasVersion()) {
                    return document.getVersion();
                }
            }
            if (this.target instanceof SearchDocument && property.isScoreProperty()) {
                return Float.valueOf(((SearchDocument)this.target).getScore());
            }
            if (!fieldName.contains(".")) {
                return this.target.get(fieldName);
            }
            Iterator<String> parts = Arrays.asList(fieldName.split("\\.")).iterator();
            Map<String, Object> source = this.target;
            Object result = null;
            while (parts.hasNext()) {
                result = source.get(parts.next());
                if (!parts.hasNext()) continue;
                source = this.getAsMap(result);
            }
            return result;
        }

        public void set(ElasticsearchPersistentProperty property, @Nullable Object value) {
            if (value != null) {
                if (property.isIdProperty()) {
                    ((Document)this.target).setId(value.toString());
                }
                if (property.isVersionProperty()) {
                    ((Document)this.target).setVersion((Long)value);
                }
            }
            this.target.put(property.getFieldName(), value);
        }

        private Map<String, Object> getAsMap(Object result) {
            if (result instanceof Map) {
                return (Map)result;
            }
            throw new IllegalArgumentException(String.format("%s is not a Map.", result));
        }
    }
}

