/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.integration.kafka.inbound;

import org.apache.kafka.clients.consumer.ConsumerRecord;
import org.springframework.integration.context.OrderlyShutdownCapable;
import org.springframework.integration.endpoint.MessageProducerSupport;
import org.springframework.kafka.listener.AbstractMessageListenerContainer;
import org.springframework.kafka.listener.AcknowledgingMessageListener;
import org.springframework.kafka.listener.adapter.FilteringAcknowledgingMessageListenerAdapter;
import org.springframework.kafka.listener.adapter.MessagingMessageListenerAdapter;
import org.springframework.kafka.listener.adapter.RecordFilterStrategy;
import org.springframework.kafka.listener.adapter.RetryingAcknowledgingMessageListenerAdapter;
import org.springframework.kafka.support.Acknowledgment;
import org.springframework.kafka.support.converter.MessageConverter;
import org.springframework.messaging.Message;
import org.springframework.retry.RecoveryCallback;
import org.springframework.retry.support.RetryTemplate;
import org.springframework.util.Assert;

public class KafkaMessageDrivenChannelAdapter<K, V>
extends MessageProducerSupport
implements OrderlyShutdownCapable {
    private final AbstractMessageListenerContainer<K, V> messageListenerContainer;
    private final MessagingMessageListenerAdapter<K, V> listener = new IntegrationMessageListener();
    private RecordFilterStrategy<K, V> recordFilterStrategy;
    private boolean ackDiscarded;
    private RetryTemplate retryTemplate;
    private RecoveryCallback<Void> recoveryCallback;
    private boolean filterInRetry;

    public KafkaMessageDrivenChannelAdapter(AbstractMessageListenerContainer<K, V> messageListenerContainer) {
        Assert.notNull(messageListenerContainer, (String)"messageListenerContainer is required");
        Assert.isNull((Object)messageListenerContainer.getContainerProperties().getMessageListener(), (String)"Container must not already have a listener");
        this.messageListenerContainer = messageListenerContainer;
        this.messageListenerContainer.setAutoStartup(false);
    }

    public void setMessageConverter(MessageConverter messageConverter) {
        this.listener.setMessageConverter(messageConverter);
    }

    public void setRecordFilterStrategy(RecordFilterStrategy<K, V> recordFilterStrategy) {
        this.recordFilterStrategy = recordFilterStrategy;
    }

    public void setAckDiscarded(boolean ackDiscarded) {
        this.ackDiscarded = ackDiscarded;
    }

    public void setRetryTemplate(RetryTemplate retryTemplate) {
        this.retryTemplate = retryTemplate;
    }

    public void setRecoveryCallback(RecoveryCallback<Void> recoveryCallback) {
        this.recoveryCallback = recoveryCallback;
    }

    public void setFilterInRetry(boolean filterInRetry) {
        this.filterInRetry = filterInRetry;
    }

    protected void onInit() {
        boolean filterInRetry;
        super.onInit();
        FilteringAcknowledgingMessageListenerAdapter listener = this.listener;
        boolean bl = filterInRetry = this.filterInRetry && this.retryTemplate != null && this.recordFilterStrategy != null;
        if (filterInRetry) {
            listener = new FilteringAcknowledgingMessageListenerAdapter(listener, this.recordFilterStrategy, this.ackDiscarded);
            listener = new RetryingAcknowledgingMessageListenerAdapter((AcknowledgingMessageListener)listener, this.retryTemplate, this.recoveryCallback);
        } else {
            if (this.retryTemplate != null) {
                listener = new RetryingAcknowledgingMessageListenerAdapter((AcknowledgingMessageListener)listener, this.retryTemplate, this.recoveryCallback);
            }
            if (this.recordFilterStrategy != null) {
                listener = new FilteringAcknowledgingMessageListenerAdapter((AcknowledgingMessageListener)listener, this.recordFilterStrategy, this.ackDiscarded);
            }
        }
        this.messageListenerContainer.getContainerProperties().setMessageListener((Object)listener);
    }

    protected void doStart() {
        this.messageListenerContainer.start();
    }

    protected void doStop() {
        this.messageListenerContainer.stop();
    }

    public String getComponentType() {
        return "kafka:message-driven-channel-adapter";
    }

    public int beforeShutdown() {
        this.messageListenerContainer.stop();
        return this.getPhase();
    }

    public int afterShutdown() {
        return this.getPhase();
    }

    private class IntegrationMessageListener
    extends MessagingMessageListenerAdapter<K, V> {
        IntegrationMessageListener() {
            super(null);
        }

        public void onMessage(ConsumerRecord<K, V> record, Acknowledgment acknowledgment) {
            Message message = this.toMessagingMessage(record, acknowledgment);
            KafkaMessageDrivenChannelAdapter.this.sendMessage(message);
        }
    }
}

