/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.kafka.event;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import org.apache.kafka.common.TopicPartition;
import org.springframework.kafka.event.KafkaEvent;

public class ListenerContainerIdleEvent
extends KafkaEvent {
    private final long idleTime;
    private final String listenerId;
    private final List<TopicPartition> topicPartitions;

    public ListenerContainerIdleEvent(Object source, long idleTime, String id, Collection<TopicPartition> topicPartitions) {
        super(source);
        this.idleTime = idleTime;
        this.listenerId = id;
        this.topicPartitions = new ArrayList<TopicPartition>(topicPartitions);
    }

    public long getIdleTime() {
        return this.idleTime;
    }

    public Collection<TopicPartition> getTopicPartitions() {
        return Collections.unmodifiableList(this.topicPartitions);
    }

    public String getListenerId() {
        return this.listenerId;
    }

    public String toString() {
        return "ListenerContainerIdleEvent [idleTime=" + (float)this.idleTime / 1000.0f + "s, listenerId=" + this.listenerId + ", container=" + this.getSource() + ", topicPartitions=" + this.topicPartitions + "]";
    }
}

