/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.kafka.support.converter;

import com.fasterxml.jackson.core.JsonProcessingException;
import com.fasterxml.jackson.databind.ObjectMapper;
import org.apache.kafka.common.utils.Bytes;
import org.springframework.kafka.support.converter.ConversionException;
import org.springframework.kafka.support.converter.StringJsonMessageConverter;
import org.springframework.messaging.Message;

public class BytesJsonMessageConverter
extends StringJsonMessageConverter {
    public BytesJsonMessageConverter() {
    }

    public BytesJsonMessageConverter(ObjectMapper objectMapper) {
        super(objectMapper);
    }

    @Override
    protected Object convertPayload(Message<?> message) {
        try {
            return Bytes.wrap((byte[])this.getObjectMapper().writeValueAsBytes(message.getPayload()));
        }
        catch (JsonProcessingException e) {
            throw new ConversionException("Failed to convert to JSON", e);
        }
    }
}

