/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.kafka.support.micrometer;

import io.micrometer.core.instrument.MeterRegistry;
import io.micrometer.core.instrument.Timer;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import org.springframework.context.ApplicationContext;
import org.springframework.lang.Nullable;

public final class MicrometerHolder {
    private final Map<String, Timer> meters = new ConcurrentHashMap<String, Timer>();
    private final MeterRegistry registry;
    private final String timerName;
    private final String timerDesc;
    private final String name;
    private final Map<String, String> tags;

    public MicrometerHolder(@Nullable ApplicationContext context, String name, String timerName, String timerDesc, Map<String, String> tags) {
        if (context == null) {
            throw new IllegalStateException("No micrometer registry present");
        }
        Map registries = context.getBeansOfType(MeterRegistry.class, false, false);
        this.timerName = timerName;
        this.timerDesc = timerDesc;
        this.name = name;
        this.tags = tags;
        if (registries.size() != 1) {
            throw new IllegalStateException("No micrometer registry present (or more than one)");
        }
        this.registry = (MeterRegistry)registries.values().iterator().next();
        this.buildTimer("none");
    }

    public Object start() {
        return Timer.start((MeterRegistry)this.registry);
    }

    public void success(Object sample) {
        ((Timer.Sample)sample).stop(this.meters.get("none"));
    }

    public void failure(Object sample, String exception) {
        Timer timer = this.meters.get(exception);
        if (timer == null) {
            timer = this.buildTimer(exception);
        }
        ((Timer.Sample)sample).stop(timer);
    }

    private Timer buildTimer(String exception) {
        Timer.Builder builder = Timer.builder((String)this.timerName).description(this.timerDesc).tag("name", this.name).tag("result", exception.equals("none") ? "success" : "failure").tag("exception", exception);
        if (this.tags != null && !this.tags.isEmpty()) {
            this.tags.forEach((key, value) -> builder.tag(key, value));
        }
        Timer registeredTimer = builder.register(this.registry);
        this.meters.put(exception, registeredTimer);
        return registeredTimer;
    }

    public void destroy() {
        this.meters.values().forEach(arg_0 -> ((MeterRegistry)this.registry).remove(arg_0));
        this.meters.clear();
    }
}

