/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.web.socket.config.annotation;

import org.springframework.context.annotation.Bean;
import org.springframework.messaging.MessageChannel;
import org.springframework.messaging.SubscribableChannel;
import org.springframework.messaging.simp.config.AbstractMessageBrokerConfiguration;
import org.springframework.messaging.simp.user.UserSessionRegistry;
import org.springframework.scheduling.TaskScheduler;
import org.springframework.scheduling.concurrent.ThreadPoolTaskScheduler;
import org.springframework.web.servlet.HandlerMapping;
import org.springframework.web.socket.WebSocketHandler;
import org.springframework.web.socket.config.annotation.StompEndpointRegistry;
import org.springframework.web.socket.config.annotation.WebMvcStompEndpointRegistry;
import org.springframework.web.socket.config.annotation.WebSocketTransportRegistration;
import org.springframework.web.socket.messaging.SubProtocolWebSocketHandler;

public abstract class WebSocketMessageBrokerConfigurationSupport
extends AbstractMessageBrokerConfiguration {
    private WebSocketTransportRegistration transportRegistration;

    protected WebSocketMessageBrokerConfigurationSupport() {
    }

    @Bean
    public HandlerMapping stompWebSocketHandlerMapping() {
        WebSocketHandler webSocketHandler = this.subProtocolWebSocketHandler();
        UserSessionRegistry sessionRegistry = this.userSessionRegistry();
        WebSocketTransportRegistration transportRegistration = this.getTransportRegistration();
        ThreadPoolTaskScheduler taskScheduler = this.messageBrokerSockJsTaskScheduler();
        WebMvcStompEndpointRegistry registry = new WebMvcStompEndpointRegistry(webSocketHandler, transportRegistration, sessionRegistry, (TaskScheduler)taskScheduler);
        this.registerStompEndpoints(registry);
        return registry.getHandlerMapping();
    }

    @Bean
    public WebSocketHandler subProtocolWebSocketHandler() {
        return new SubProtocolWebSocketHandler((MessageChannel)this.clientInboundChannel(), (SubscribableChannel)this.clientOutboundChannel());
    }

    protected final WebSocketTransportRegistration getTransportRegistration() {
        if (this.transportRegistration == null) {
            this.transportRegistration = new WebSocketTransportRegistration();
            this.configureWebSocketTransport(this.transportRegistration);
        }
        return this.transportRegistration;
    }

    protected void configureWebSocketTransport(WebSocketTransportRegistration registry) {
    }

    @Bean
    public ThreadPoolTaskScheduler messageBrokerSockJsTaskScheduler() {
        ThreadPoolTaskScheduler scheduler = new ThreadPoolTaskScheduler();
        scheduler.setPoolSize(Runtime.getRuntime().availableProcessors());
        scheduler.setThreadNamePrefix("MessageBrokerSockJS-");
        return scheduler;
    }

    protected abstract void registerStompEndpoints(StompEndpointRegistry var1);
}

