/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.webflow.engine.impl;

import org.springframework.webflow.core.collection.AttributeMap;
import org.springframework.webflow.core.collection.MutableAttributeMap;
import org.springframework.webflow.definition.FlowDefinition;
import org.springframework.webflow.definition.StateDefinition;
import org.springframework.webflow.definition.TransitionDefinition;
import org.springframework.webflow.execution.Event;
import org.springframework.webflow.execution.FlowExecutionException;
import org.springframework.webflow.execution.FlowExecutionListener;
import org.springframework.webflow.execution.FlowSession;
import org.springframework.webflow.execution.RequestContext;
import org.springframework.webflow.execution.View;

class FlowExecutionListeners {
    private FlowExecutionListener[] EMPTY_LISTENER_ARRAY = new FlowExecutionListener[0];
    private FlowExecutionListener[] listeners;

    public FlowExecutionListeners() {
        this(null);
    }

    public FlowExecutionListeners(FlowExecutionListener ... listeners) {
        this.listeners = listeners != null ? listeners : this.EMPTY_LISTENER_ARRAY;
    }

    public FlowExecutionListener[] getArray() {
        return this.listeners;
    }

    public int size() {
        return this.listeners.length;
    }

    public void fireRequestSubmitted(RequestContext context) {
        for (FlowExecutionListener listener : this.listeners) {
            listener.requestSubmitted(context);
        }
    }

    public void fireRequestProcessed(RequestContext context) {
        for (FlowExecutionListener listener : this.listeners) {
            listener.requestProcessed(context);
        }
    }

    public void fireSessionCreating(RequestContext context, FlowDefinition flow) {
        for (FlowExecutionListener listener : this.listeners) {
            listener.sessionCreating(context, flow);
        }
    }

    public void fireSessionStarting(RequestContext context, FlowSession session, MutableAttributeMap<?> input) {
        for (FlowExecutionListener listener : this.listeners) {
            listener.sessionStarting(context, session, input);
        }
    }

    public void fireSessionStarted(RequestContext context, FlowSession session) {
        for (FlowExecutionListener listener : this.listeners) {
            listener.sessionStarted(context, session);
        }
    }

    public void fireEventSignaled(RequestContext context, Event event) {
        for (FlowExecutionListener listener : this.listeners) {
            listener.eventSignaled(context, event);
        }
    }

    public void fireStateEntering(RequestContext context, StateDefinition nextState) {
        for (FlowExecutionListener listener : this.listeners) {
            listener.stateEntering(context, nextState);
        }
    }

    public void fireStateEntered(RequestContext context, StateDefinition previousState) {
        for (FlowExecutionListener listener : this.listeners) {
            listener.stateEntered(context, previousState, context.getCurrentState());
        }
    }

    public void fireViewRendering(RequestContext context, View view) {
        for (FlowExecutionListener listener : this.listeners) {
            listener.viewRendering(context, view, context.getCurrentState());
        }
    }

    public void fireViewRendered(RequestContext context, View view) {
        for (FlowExecutionListener listener : this.listeners) {
            listener.viewRendered(context, view, context.getCurrentState());
        }
    }

    public void fireTransitionExecuting(RequestContext context, TransitionDefinition transition) {
        for (FlowExecutionListener listener : this.listeners) {
            listener.transitionExecuting(context, transition);
        }
    }

    public void firePaused(RequestContext context) {
        for (FlowExecutionListener listener : this.listeners) {
            listener.paused(context);
        }
    }

    public void fireResuming(RequestContext context) {
        for (FlowExecutionListener listener : this.listeners) {
            listener.resuming(context);
        }
    }

    public void fireSessionEnding(RequestContext context, FlowSession session, String outcomeId, MutableAttributeMap<?> output) {
        for (FlowExecutionListener listener : this.listeners) {
            listener.sessionEnding(context, session, outcomeId, output);
        }
    }

    public void fireSessionEnded(RequestContext context, FlowSession session, String outcomeId, AttributeMap<?> output) {
        for (FlowExecutionListener listener : this.listeners) {
            listener.sessionEnded(context, session, outcomeId, output);
        }
    }

    public void fireExceptionThrown(RequestContext context, FlowExecutionException exception) {
        for (FlowExecutionListener listener : this.listeners) {
            listener.exceptionThrown(context, exception);
        }
    }
}

