/*
 * Decompiled with CFR 0.152.
 */
package org.subethamail.smtp.io;

import java.io.IOException;
import java.io.OutputStream;

public class DotTerminatedOutputStream
extends OutputStream {
    private static final byte[] DOT_CRLF = new byte[]{46, 13, 10};
    private static final byte[] CRLF_DOT_CRLF = new byte[]{13, 10, 46, 13, 10};
    private final OutputStream out;
    private final byte[] lastBytes = new byte[]{13, 10};

    public DotTerminatedOutputStream(OutputStream out) {
        this.out = out;
    }

    public void write(int b) throws IOException {
        this.lastBytes[0] = this.lastBytes[1];
        this.lastBytes[1] = (byte)b;
        this.out.write(b);
    }

    public void write(byte[] b, int off, int len) throws IOException {
        if (len == 1) {
            this.lastBytes[0] = this.lastBytes[1];
            this.lastBytes[1] = b[off];
        } else if (len >= 2) {
            this.lastBytes[0] = b[off + len - 2];
            this.lastBytes[1] = b[off + len - 1];
        }
        super.write(b, off, len);
    }

    public void writeTerminatingSequence() throws IOException {
        if (this.lastBytes[0] == 13 && this.lastBytes[1] == 10) {
            this.out.write(DOT_CRLF);
        } else {
            this.out.write(CRLF_DOT_CRLF);
        }
    }
}

